/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.PrintfFormat;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.util.ArrayList;
import java.util.Iterator;

public class OSSWriter {
    public static void writeOSS(DataSource dataSource, boolean bl) {
        Object object;
        Trial trial = new Trial();
        trial.setDataSource(dataSource);
        ParaProfTrial paraProfTrial = new ParaProfTrial();
        DataSorter dataSorter = new DataSorter(paraProfTrial);
        int n = dataSource.getNumberOfMetrics();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            object = dataSource.getMetric(n3);
            if (object.isTimeMetric()) {
                n2 = n3;
            }
            ++n3;
        }
        object = new ArrayList();
        if (!bl) {
            object = dataSource.getAllThreads();
        }
        if (dataSource.getAllThreads().size() > 1 || bl) {
            object.add(dataSource.getTotalData());
            object.add(dataSource.getMeanData());
        }
        int n4 = 0;
        while (n4 < object.size()) {
            Object object2;
            Thread thread = (Thread)object.get(n4);
            System.out.println("\n-------------------------------------------------------------------------------");
            if (thread.getNodeID() == -2) {
                System.out.println("Thread: Total");
            } else {
                System.out.println("Thread: " + thread);
            }
            System.out.println("-------------------------------------------------------------------------------");
            String string = " excl.secs  excl.%   cum.%";
            int n5 = 0;
            while (n5 < n) {
                if (n5 != n2) {
                    object2 = trial.getDataSource().getMetric(n5);
                    String string2 = object2.getName();
                    int n6 = Math.max(16, string2.length() + 2);
                    string = string + UtilFncs.lpad((String)string2, (int)n6);
                }
                ++n5;
            }
            string = string + "     calls  function";
            System.out.println(string);
            object2 = dataSorter.getFunctionProfiles(thread);
            double d = 0.0;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)iterator.next();
                FunctionProfile functionProfile = pPFunctionProfile.getFunctionProfile();
                double d2 = functionProfile.getExclusive(n2) / 1000.0 / 1000.0;
                double d3 = functionProfile.getExclusivePercent(n2);
                String string3 = new PrintfFormat("%10.3G ").sprintf(d2) + new PrintfFormat("%6.1f%% ").sprintf(d3) + new PrintfFormat("%6.1f%%").sprintf(d += d3);
                int n7 = 0;
                while (n7 < n) {
                    if (n7 != n2) {
                        double d4 = functionProfile.getExclusive(n7);
                        Metric metric = trial.getDataSource().getMetric(n7);
                        String string4 = metric.getName();
                        string3 = string3 + new PrintfFormat("%" + Math.max(16, string4.length() + 2) + ".0f").sprintf(d4);
                    }
                    ++n7;
                }
                string3 = string3 + new PrintfFormat("%10.0f").sprintf(functionProfile.getNumCalls());
                string3 = string3 + "  " + functionProfile.getName();
                System.out.println(string3);
            }
            ++n4;
        }
    }
}

