/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPThread;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.paraprof.interfaces.ToolBarListener;
import edu.uoregon.tau.paraprof.util.ObjectFilter;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Snapshot;
import edu.uoregon.tau.perfdmf.Thread;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Printable;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;

public class SnapshotBreakdownWindow
extends JFrame
implements Observer,
ParaProfWindow,
ImageExport,
ToolBarListener {
    private ParaProfTrial ppTrial;
    private Thread thread;
    private ChartPanel panel;
    private DataSorter dataSorter;
    private static int defaultWidth = 750;
    private static int defaultHeight = 610;
    private DefaultTableXYDataset dataSet = new DefaultTableXYDataset();
    private boolean timeline = true;
    private boolean differential = true;
    private boolean middleTime = true;
    private boolean square = true;
    private boolean topTen = true;
    private static final String ST_TOP_TEN = "Top 20";
    private static final String ST_DIFFERENTIAL = "Differential";
    private static final String ST_SQUARE = "Square";
    private static final String ST_TIMELINE = "Timeline";
    private static final int STYLE_STACKED = 0;
    private static final int STYLE_TRANSPARENT_AREA = 1;
    private static final int STYLE_LINE = 2;
    private static final String ST_STYLE_STACKED = "Stacked";
    private static final String ST_STYLE_TRANSPARENT_AREA = "Area";
    private static final String ST_STYLE_LINE = "Line";
    private JFreeChart chart;
    private JToggleButton button_topTen = new JToggleButton("Top 20", this.topTen);
    private JToggleButton button_square = new JToggleButton("Square", this.square);
    private JToggleButton button_timeline = new JToggleButton("Timeline", this.square);
    private JToggleButton button_differential = new JToggleButton("Differential", this.differential);
    private static final int topNum = 20;
    private ObjectFilter filter;
    private int style = 0;

    public SnapshotBreakdownWindow(ParaProfTrial paraProfTrial, Thread thread, Component component) {
        this.ppTrial = paraProfTrial;
        this.thread = thread;
        PPThread pPThread = new PPThread(thread, paraProfTrial);
        this.filter = new ObjectFilter(thread.getSnapshots());
        this.filter.addObserver(this);
        this.setTitle("TAU: ParaProf: Snapshots for " + pPThread.getFullName() + " - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SnapshotBreakdownWindow.this.closeThisWindow();
            }
        });
        this.dataSorter = new DataSorter(paraProfTrial);
        this.createToolbar();
        this.chart = this.createChart();
        this.panel = new ChartPanel(this.chart);
        this.getContentPane().add((Component)this.panel);
        ((Component)this).setSize(ParaProfUtils.checkSize(new Dimension(defaultWidth, defaultHeight)));
        ((Component)this).setLocation(WindowPlacer.getNewLocation(this, component));
        this.setupMenus();
        ParaProfUtils.setFrameIcon(this);
        ParaProf.incrementNumWindows();
    }

    private void recreateChart() {
        this.topTen = this.button_topTen.isSelected();
        this.square = this.button_square.isSelected();
        this.timeline = this.button_timeline.isSelected();
        this.differential = this.button_differential.isSelected();
        this.getContentPane().remove((Component)this.panel);
        this.chart = this.createChart();
        this.panel = new ChartPanel(this.chart);
        this.getContentPane().add((Component)this.panel);
        this.validate();
        this.repaint();
    }

    private void createToolbar() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotBreakdownWindow.this.recreateChart();
            }
        };
        Vector<String> vector = new Vector<String>();
        vector.add(ST_STYLE_STACKED);
        vector.add(ST_STYLE_TRANSPARENT_AREA);
        vector.add(ST_STYLE_LINE);
        final JComboBox jComboBox = new JComboBox(vector);
        jComboBox.setMaximumSize(jComboBox.getPreferredSize());
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotBreakdownWindow.this.setStyle(jComboBox.getSelectedIndex());
                SnapshotBreakdownWindow.this.toolBarUsed();
            }
        });
        this.button_topTen.addActionListener(actionListener);
        this.button_square.addActionListener(actionListener);
        this.button_differential.addActionListener(actionListener);
        this.button_timeline.addActionListener(actionListener);
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this.button_topTen);
        jToolBar.add(this.button_square);
        jToolBar.add(this.button_differential);
        jToolBar.add(this.button_timeline);
        jToolBar.addSeparator();
        jToolBar.add(jComboBox);
        jToolBar.addSeparator();
        ParaProfUtils.createMetricToolbarItems(jToolBar, this.ppTrial, this.dataSorter, this);
        jToolBar.addSeparator();
        this.getContentPane().add((Component)jToolBar, "North");
    }

    public void setStyle(int n) {
        this.style = n;
    }

    private JFreeChart createChart() {
        List list;
        Object object;
        this.dataSet = new DefaultTableXYDataset();
        this.dataSet.removeAllSeries();
        this.dataSorter.setDescendingOrder(true);
        List list2 = this.thread.getSnapshots();
        List list3 = this.dataSorter.getBasicFunctionProfiles(this.thread);
        long l = this.thread.getStartTime();
        long l2 = 0L;
        int n = list3.size();
        if (this.topTen) {
            n = Math.min(21, list3.size());
        }
        int n2 = 0;
        while (n2 < n) {
            int n3;
            XYSeries xYSeries;
            object = (FunctionProfile)list3.get(n2);
            if (this.topTen && n2 == 20) {
                xYSeries = new XYSeries("Other", true, false);
            } else {
                String string = object.getName();
                while (string.indexOf("[{") != -1) {
                    n3 = string.indexOf("[{");
                    int n4 = string.indexOf("}]");
                    string = string.substring(0, n3) + string.substring(n4 + 2);
                }
                xYSeries = new XYSeries(string, true, false);
            }
            boolean bl = false;
            n3 = list2.size();
            list = this.filter.getFilteredObjects();
            int n5 = 0;
            while (n5 < list.size()) {
                long l3;
                double d;
                int n6;
                int n7 = n6 = ((Snapshot)list.get(n5)).getID();
                if (this.topTen && n2 == 20) {
                    d = 0.0;
                    int n8 = n2;
                    while (n8 < list3.size()) {
                        FunctionProfile functionProfile = (FunctionProfile)list3.get(n8);
                        d = this.differential && n7 != 0 ? (d += this.dataSorter.getValue(functionProfile, n7) - this.dataSorter.getValue(functionProfile, n7 - 1)) : (d += this.dataSorter.getValue(functionProfile, n7));
                        ++n8;
                    }
                } else {
                    d = this.differential && n7 != 0 ? this.dataSorter.getValue((FunctionProfile)object, n7) - this.dataSorter.getValue((FunctionProfile)object, n7 - 1) : this.dataSorter.getValue((FunctionProfile)object, n7);
                }
                Snapshot snapshot = (Snapshot)list2.get(n6);
                l2 = l3 = snapshot.getTimestamp() - l;
                if (this.timeline) {
                    long l4;
                    long l5;
                    if (n6 == 0) {
                        l5 = l;
                        l4 = 0L;
                    } else {
                        Snapshot snapshot2 = (Snapshot)list2.get(n6 - 1);
                        l5 = snapshot2.getTimestamp();
                        l4 = snapshot2.getTimestamp() - l;
                    }
                    if (this.square) {
                        xYSeries.add(1.0E-4 + (double)l4 / 1000000.0, d);
                        xYSeries.add((double)l3 / 1000000.0, d);
                    } else if (this.middleTime) {
                        double d2 = l3 - (snapshot.getTimestamp() - l5) / 2L;
                        xYSeries.add(d2 / 1000000.0, d);
                    } else {
                        xYSeries.add((double)l3 / 1000000.0, d);
                    }
                } else if (this.square) {
                    xYSeries.add((double)n6, d);
                    xYSeries.add((double)n6 + 0.9999, d);
                } else {
                    xYSeries.add((double)n6, d);
                }
                ++n5;
            }
            this.dataSet.addSeries(xYSeries);
            ++n2;
        }
        object = this.ppTrial.getMetric(this.dataSorter.getSelectedMetricID());
        int n9 = this.dataSorter.getValueType().getUnits(0, (Metric)object);
        String string = this.dataSorter.getValueType().getSuffix(n9, (Metric)object).trim();
        String string2 = this.dataSorter.getValueType() + " (" + string + ")";
        list = null;
        if (this.style == 0) {
            list = ChartFactory.createStackedXYAreaChart((String)"Snapshot Breakdown", (String)"Snapshots", (String)string2, (TableXYDataset)this.dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        } else if (this.style == 1) {
            list = ChartFactory.createXYAreaChart((String)"Snapshot Breakdown", (String)"Snapshots", (String)string2, (XYDataset)this.dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            list.getPlot().setForegroundAlpha(0.4f);
        } else if (this.style == 2) {
            list = ChartFactory.createXYLineChart((String)"Snapshot Breakdown", (String)"Snapshots", (String)string2, (XYDataset)this.dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        } else {
            throw new ParaProfException("Unrecognized style: " + this.style);
        }
        if (this.timeline) {
            XYPlot xYPlot = list.getXYPlot();
            NumberAxis numberAxis = new NumberAxis("Timeline (seconds)");
            numberAxis.setRange(new Range(0.0, (double)l2 / 1000000.0));
            xYPlot.setDomainAxis(0, (ValueAxis)numberAxis);
        } else {
            XYPlot xYPlot = list.getXYPlot();
            NumberAxis numberAxis = new NumberAxis("Snapshots");
            System.out.println(list2.size());
            numberAxis.setRange(new Range(0.0, (double)list2.size()));
            xYPlot.setDomainAxis(0, (ValueAxis)numberAxis);
        }
        return list;
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Filter");
        JMenuItem jMenuItem = new JMenuItem("Filter Snapshots");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotBreakdownWindow.this.filter.showFrame("Filter Snapshots");
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(ParaProfUtils.createFileMenu(this, (Printable)this.panel, this));
        jMenuBar.add(jMenu);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        if (ParaProf.scripts.size() > 0) {
            jMenuBar.add(ParaProfUtils.createScriptMenu(this.ppTrial, this));
        }
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    public void update(Observable observable, Object object) {
        this.recreateChart();
    }

    public void closeThisWindow() {
        try {
            this.filter.closeWindow();
            ((Component)this).setVisible(false);
            this.ppTrial.deleteObserver(this);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.dispose();
    }

    public void help(boolean bl) {
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        this.panel.setDoubleBuffered(false);
        this.panel.paintAll(graphics2D);
        this.panel.setDoubleBuffered(true);
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        return this.panel.getSize();
    }

    public void toolBarUsed() {
        this.recreateChart();
    }
}

