/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Snapshot;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SnapshotControlWindow
extends JFrame {
    private ParaProfTrial ppTrial;
    private DataSource dataSource;
    private JSlider slider;
    private JLabel indexLabel = new JLabel("");
    private JLabel timeLabel = new JLabel("");
    private JLabel nameLabel = new JLabel("");
    private int numSnapshots;
    private int selectedSnapshot = -1;
    private JCheckBox animateCheckbox = new JCheckBox("Replay");
    private JSlider animateSlider = new JSlider(0, 100);
    private Animator animator;
    private volatile float rotateSpeed = 0.5f;
    private long lastTime;

    public SnapshotControlWindow(ParaProfTrial paraProfTrial) {
        this.ppTrial = paraProfTrial;
        this.dataSource = paraProfTrial.getDataSource();
        this.setTitle("TAU: ParaProf: Snapshot Controller: " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        ((Component)this).setSize(new Dimension(300, 180));
        this.numSnapshots = this.dataSource.getMeanData().getNumSnapshots();
        this.selectedSnapshot = this.numSnapshots - 1;
        this.slider = new JSlider(0, this.selectedSnapshot);
        this.slider.setSnapToTicks(true);
        this.slider.setPaintTicks(true);
        this.slider.setValue(this.selectedSnapshot);
        this.slider.setBackground(Color.white);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SnapshotControlWindow.this.selectedSnapshot = SnapshotControlWindow.this.slider.getValue();
                SnapshotControlWindow.this.setLabels();
                SnapshotControlWindow.this.ppTrial.setSelectedSnapshot(SnapshotControlWindow.this.selectedSnapshot);
            }
        });
        this.animateSlider.setBackground(Color.white);
        this.animateCheckbox.setBackground(Color.white);
        this.animateCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (SnapshotControlWindow.this.animateCheckbox.isSelected()) {
                        SnapshotControlWindow.this.animator = new Animator();
                        SnapshotControlWindow.this.animator.start();
                    } else {
                        SnapshotControlWindow.this.animator.end();
                        SnapshotControlWindow.this.animator = null;
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        });
        this.setLabels();
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        ParaProfUtils.addCompItem(jPanel, (Component)this.indexLabel, gridBagConstraints, 0, 0, 2, 1);
        gridBagConstraints.fill = 2;
        ParaProfUtils.addCompItem(jPanel, (Component)this.slider, gridBagConstraints, 0, 1, 2, 1);
        gridBagConstraints.fill = 0;
        ParaProfUtils.addCompItem(jPanel, (Component)this.nameLabel, gridBagConstraints, 0, 2, 2, 1);
        ParaProfUtils.addCompItem(jPanel, (Component)this.timeLabel, gridBagConstraints, 0, 3, 2, 1);
        gridBagConstraints.anchor = 15;
        ParaProfUtils.addCompItem(jPanel, (Component)this.animateCheckbox, gridBagConstraints, 0, 4, 1, 1);
        ParaProfUtils.addCompItem(jPanel, (Component)this.animateSlider, gridBagConstraints, 1, 4, 1, 1);
        this.getContentPane().add(jPanel);
        ParaProfUtils.setFrameIcon(this);
    }

    private void setLabels() {
        this.indexLabel.setText("Snapshot " + this.selectedSnapshot);
        Snapshot snapshot = (Snapshot)this.dataSource.getMeanData().getSnapshots().get(this.selectedSnapshot);
        long l = snapshot.getTimestamp() - this.dataSource.getMeanData().getStartTime();
        l = (long)((double)l / 1000000.0);
        this.timeLabel.setText("Time Position: " + l + " Seconds");
        this.nameLabel.setText("Name: " + snapshot.getName());
    }

    static /* synthetic */ long access$300(SnapshotControlWindow snapshotControlWindow) {
        return snapshotControlWindow.lastTime;
    }

    static /* synthetic */ long access$302(SnapshotControlWindow snapshotControlWindow, long l) {
        snapshotControlWindow.lastTime = l;
        return snapshotControlWindow.lastTime;
    }

    private class Animator
    extends Thread {
        private volatile boolean stop = false;

        private Animator() {
        }

        public void run() {
            this.stop = false;
            while (!this.stop) {
                try {
                    if (SnapshotControlWindow.this.rotateSpeed == 0.0f) {
                        Thread.sleep(250L);
                        continue;
                    }
                    Runnable runnable = new Runnable(this){
                        private final /* synthetic */ Animator this$1;
                        {
                            this.this$1 = animator;
                        }

                        public void run() {
                            if (SnapshotControlWindow.access$200(Animator.access$100(this.this$1)).getValue() >= SnapshotControlWindow.access$200(Animator.access$100(this.this$1)).getMaximum()) {
                                SnapshotControlWindow.access$200(Animator.access$100(this.this$1)).setValue(0);
                                long l = System.currentTimeMillis();
                                double d = ((double)l - (double)SnapshotControlWindow.access$300(Animator.access$100(this.this$1))) / 1000.0;
                                SnapshotControlWindow.access$302(Animator.access$100(this.this$1), l);
                                System.out.println("Duration: " + d);
                            } else {
                                SnapshotControlWindow.access$200(Animator.access$100(this.this$1)).setValue(SnapshotControlWindow.access$200(Animator.access$100(this.this$1)).getValue() + 2);
                            }
                        }
                    };
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void end() {
            this.stop = true;
        }

        static /* synthetic */ SnapshotControlWindow access$100(Animator animator) {
            return animator.SnapshotControlWindow.this;
        }
    }
}

