/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.PreferencesWindow;
import edu.uoregon.tau.paraprof.SearchPanel;
import edu.uoregon.tau.paraprof.StatWindowPanel;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.UserEventValueType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.paraprof.interfaces.ScrollBarController;
import edu.uoregon.tau.paraprof.interfaces.SearchableOwner;
import edu.uoregon.tau.paraprof.interfaces.UnitListener;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class StatWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer,
SearchableOwner,
ScrollBarController,
KeyListener,
ParaProfWindow,
UnitListener {
    private ParaProfTrial ppTrial = null;
    private DataSorter dataSorter;
    private Function phase;
    private int nodeID = -1;
    private int contextID = -1;
    private int threadID = -1;
    private boolean userEventWindow;
    private JMenu optionsMenu = null;
    private JMenu unitsSubMenu = null;
    private boolean sortByName;
    private JCheckBoxMenuItem descendingOrder = null;
    private JCheckBoxMenuItem showPathTitleInReverse = null;
    private JCheckBoxMenuItem showMetaData = null;
    private JCheckBoxMenuItem showFindPanelBox;
    private JScrollPane jScrollpane = null;
    private StatWindowPanel panel = null;
    private List list = new ArrayList();
    private int units = ParaProf.preferences.getUnits();
    private SearchPanel searchPanel;
    private Thread thread;

    public StatWindow(ParaProfTrial paraProfTrial, Thread thread, boolean bl, Function function, Component component) {
        this.ppTrial = paraProfTrial;
        this.phase = function;
        paraProfTrial.addObserver(this);
        this.dataSorter = new DataSorter(paraProfTrial);
        this.dataSorter.setPhase(function);
        this.userEventWindow = bl;
        this.thread = thread;
        ((Component)this).setSize(ParaProfUtils.checkSize(new Dimension(1000, 600)));
        ((Component)this).setLocation(WindowPlacer.getNewLocation(this, component));
        this.nodeID = thread.getNodeID();
        this.contextID = thread.getContextID();
        this.threadID = thread.getThreadID();
        String string = this.nodeID == -1 ? "TAU: ParaProf: Mean Data Statistics: " : (this.nodeID == -2 ? "TAU: ParaProf: Total Statistics: " : (this.nodeID == -3 ? "TAU: ParaProf: Standard Deviation Statistics: " : "TAU: ParaProf: n,c,t, " + this.nodeID + "," + this.contextID + "," + this.threadID));
        string = string + " - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse());
        if (function != null) {
            this.setTitle(string + " Phase: " + function.getName());
        } else {
            this.setTitle(string);
        }
        ParaProfUtils.setFrameIcon(this);
        this.addKeyListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                StatWindow.this.thisWindowClosing(windowEvent);
            }
        });
        if (ParaProf.getHelpWindow().isVisible()) {
            this.help(false);
        }
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.addKeyListener(this);
        JMenu jMenu = null;
        Object var9_9 = null;
        this.optionsMenu = new JMenu("Options");
        Object var10_10 = null;
        ButtonGroup buttonGroup = null;
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        this.showFindPanelBox = new JCheckBoxMenuItem("Show Find Panel", false);
        this.showFindPanelBox.addActionListener(this);
        this.optionsMenu.add(this.showFindPanelBox);
        this.showMetaData = new JCheckBoxMenuItem("Show Meta Data in Panel", true);
        this.showMetaData.addActionListener(this);
        this.optionsMenu.add(this.showMetaData);
        this.optionsMenu.add(new JSeparator());
        this.descendingOrder = new JCheckBoxMenuItem("Descending Order", true);
        this.descendingOrder.addActionListener(this);
        this.optionsMenu.add(this.descendingOrder);
        this.unitsSubMenu = !bl ? ParaProfUtils.createUnitsMenu(this, this.units, true) : new JMenu("Select Units");
        this.optionsMenu.add(this.unitsSubMenu);
        jMenu = new JMenu("Sort By");
        buttonGroup = new ButtonGroup();
        if (bl) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Name", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Samples", true);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Min. Value", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Max. Value", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Mean Value", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Standard Deviation", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
        } else {
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Name", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Exclusive", true);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Inclusive", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Child Calls", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem("Inclusive Per Call", false);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
        }
        jMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(jMenu);
        this.optionsMenu.addMenuListener(this);
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panel = new StatWindowPanel(paraProfTrial, this, bl);
        this.jScrollpane = new JScrollPane(this.panel);
        JScrollBar jScrollBar = this.jScrollpane.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
        this.setHeader();
        this.sortLocalData();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.jScrollpane, gridBagConstraints, 0, 0, 1, 1);
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this.panel, this.panel));
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(paraProfTrial, this));
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
        ParaProf.incrementNumWindows();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Name")) {
                    this.sortByName = true;
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Show Find Panel")) {
                    if (this.showFindPanelBox.isSelected()) {
                        this.showSearchPanel(true);
                    } else {
                        this.showSearchPanel(false);
                    }
                } else if (string.equals("Descending Order")) {
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Exclusive")) {
                    this.sortByName = false;
                    this.dataSorter.setValueType(ValueType.EXCLUSIVE);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Inclusive")) {
                    this.sortByName = false;
                    this.dataSorter.setValueType(ValueType.INCLUSIVE);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Number of Calls")) {
                    this.sortByName = false;
                    this.dataSorter.setValueType(ValueType.NUMCALLS);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Number of Child Calls")) {
                    this.sortByName = false;
                    this.dataSorter.setValueType(ValueType.NUMSUBR);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Inclusive Per Call")) {
                    this.sortByName = false;
                    this.dataSorter.setValueType(ValueType.INCLUSIVE_PER_CALL);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Exclusive Per Call")) {
                    this.sortByName = false;
                    this.dataSorter.setValueType(ValueType.EXCLUSIVE_PER_CALL);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Number of Samples")) {
                    this.sortByName = false;
                    this.dataSorter.setUserEventValueType(UserEventValueType.NUMSAMPLES);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Min. Value")) {
                    this.sortByName = false;
                    this.dataSorter.setUserEventValueType(UserEventValueType.MIN);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Max. Value")) {
                    this.sortByName = false;
                    this.dataSorter.setUserEventValueType(UserEventValueType.MAX);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Mean Value")) {
                    this.sortByName = false;
                    this.dataSorter.setUserEventValueType(UserEventValueType.MEAN);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Standard Deviation")) {
                    this.sortByName = false;
                    this.dataSorter.setUserEventValueType(UserEventValueType.STDDEV);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                } else if (string.equals("Show Meta Data in Panel")) {
                    this.setHeader();
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.ppTrial.isTimeMetric() && !this.userEventWindow) {
                this.unitsSubMenu.setEnabled(true);
            } else {
                this.unitsSubMenu.setEnabled(false);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("prefEvent")) {
            this.setHeader();
            this.panel.repaint();
        }
        if (string.equals("colorEvent")) {
            this.panel.repaint();
        } else if (string.equals("dataEvent")) {
            if (!this.ppTrial.isTimeMetric()) {
                this.units = 0;
            }
            this.dataSorter.setSelectedMetricID(this.ppTrial.getDefaultMetricID());
            this.sortLocalData();
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        }
    }

    public void help(boolean bl) {
        ParaProf.getHelpWindow().clearText();
        if (bl) {
            ParaProf.getHelpWindow().show();
        }
        ParaProf.getHelpWindow().writeText("This is the statistics window");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("This window shows you textual statistics.");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("Use the options menu to select different ways of displaying the data.");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("Right click on any line within this window to bring up a popup");
        ParaProf.getHelpWindow().writeText("menu. In this menu you can change or reset the default color");
        ParaProf.getHelpWindow().writeText(", or to show more details about the Function / User Event.");
        ParaProf.getHelpWindow().writeText("You can also left click any line to highlight it in the system.");
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    public DataSorter getDataSorter() {
        return this.dataSorter;
    }

    private void sortLocalData() {
        if (this.sortByName) {
            this.dataSorter.setSortType(SortType.NAME);
        } else {
            this.dataSorter.setSortType(SortType.VALUE);
        }
        this.dataSorter.setDescendingOrder(this.descendingOrder.isSelected());
        this.list = this.userEventWindow ? this.dataSorter.getUserEventProfiles(this.thread) : this.dataSorter.getFunctionProfiles(this.thread);
        this.panel.resetStringSize();
    }

    public List getData() {
        return this.list;
    }

    public int units() {
        if (this.ppTrial.isTimeMetric()) {
            return this.units;
        }
        return 0;
    }

    public Dimension getViewportSize() {
        return this.jScrollpane.getViewport().getExtentSize();
    }

    public Rectangle getViewRect() {
        return this.jScrollpane.getViewport().getViewRect();
    }

    public void setHeader() {
        if (this.showMetaData.isSelected()) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setMargin(new Insets(3, 3, 3, 3));
            jTextArea.setEditable(false);
            jTextArea.addKeyListener(this);
            PreferencesWindow preferencesWindow = this.ppTrial.getPreferencesWindow();
            jTextArea.setFont(ParaProf.preferencesWindow.getFont());
            jTextArea.append(this.getHeaderString());
            this.jScrollpane.setColumnHeaderView(jTextArea);
        } else {
            this.jScrollpane.setColumnHeaderView(null);
        }
    }

    public String getHeaderString() {
        if (this.userEventWindow) {
            return "Sorted By: " + this.dataSorter.getUserEventValueType() + "\n";
        }
        if (this.phase != null) {
            return "Phase: " + this.phase.getName() + "\nMetric: " + this.ppTrial.getMetricName(this.ppTrial.getDefaultMetricID()) + "\n" + "Sorted By: " + this.dataSorter.getValueType() + "\n" + "Units: " + UtilFncs.getUnitsString((int)this.units, (boolean)this.ppTrial.isTimeMetric(), (boolean)this.ppTrial.isDerivedMetric()) + "\n";
        }
        return "Metric: " + this.ppTrial.getMetricName(this.ppTrial.getDefaultMetricID()) + "\n" + "Sorted By: " + this.dataSorter.getValueType() + "\n" + "Units: " + UtilFncs.getUnitsString((int)this.units, (boolean)this.ppTrial.isTimeMetric(), (boolean)this.ppTrial.isDerivedMetric()) + "\n";
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    public void closeThisWindow() {
        try {
            ((Component)this).setVisible(false);
            this.ppTrial.deleteObserver(this);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }

    public void showSearchPanel(boolean bl) {
        if (bl) {
            if (this.searchPanel == null) {
                this.searchPanel = new SearchPanel(this, this.panel.getSearcher());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.weightx = 0.1;
                gridBagConstraints.weighty = 0.01;
                this.addCompItem(this.searchPanel, gridBagConstraints, 0, 3, 2, 1);
                this.searchPanel.setFocus();
            }
        } else {
            this.getContentPane().remove(this.searchPanel);
            this.searchPanel = null;
        }
        this.showFindPanelBox.setSelected(bl);
        this.validate();
    }

    public void setVerticalScrollBarPosition(int n) {
        JScrollBar jScrollBar = this.jScrollpane.getVerticalScrollBar();
        jScrollBar.setValue(n);
    }

    public void setHorizontalScrollBarPosition(int n) {
        JScrollBar jScrollBar = this.jScrollpane.getHorizontalScrollBar();
        jScrollBar.setValue(n);
    }

    public Dimension getThisViewportSize() {
        return this.getViewportSize();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 70) {
            this.showSearchPanel(true);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void setUnits(int n) {
        this.units = n;
        this.setHeader();
        this.panel.repaint();
    }

    public Function getPhase() {
        return this.phase;
    }
}

