/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.barchart;

import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.Searcher;
import edu.uoregon.tau.paraprof.barchart.BarChartModel;
import edu.uoregon.tau.paraprof.barchart.BarChartModelListener;
import edu.uoregon.tau.paraprof.barchart.BarChartPanel;
import edu.uoregon.tau.paraprof.barchart.DrawObject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JPanel;

public class BarChart
extends JPanel
implements MouseListener,
MouseMotionListener,
BarChartModelListener {
    private BarChartModel model;
    private int maxRowLabelStringWidth;
    private boolean maxRowLabelStringWidthSet;
    private int maxValueLabelStringWidth;
    private boolean maxValueLabelStringWidthSet;
    private boolean preferredSizeSet;
    private boolean dataProcessed;
    double[] maxRowValues;
    double[] maxSubValues;
    double maxRowSum;
    double maxOverallValue;
    double[] rowSums;
    double maxSubSum;
    private FontMetrics fontMetrics;
    private boolean leftJustified;
    private int barLengthMultiple = 0;
    private int barLength = 0;
    private int leftMargin = 8;
    private int rightMargin = 12;
    private int horizSpacing = 10;
    private int additionalVerticalSpacing = 0;
    private int barHeight;
    private int topMargin = 0;
    private int rowStart;
    private int rowEnd;
    private ArrayList rowLabelDrawObjects = new ArrayList();
    private ArrayList valueDrawObjects = new ArrayList();
    private BarChartPanel panel;
    private Searcher searcher;
    private int barHorizSpacing = 5;
    private int threshold = 2;
    private boolean stacked = true;
    private boolean normalized = true;
    private boolean singleLine = true;
    private int fontHeight;
    private int mouseCol = -1;
    private int rowHeight;
    private boolean autoResize = true;
    private int autoWidth;
    private static final int minBarSize = 250;
    private static final boolean mouseOverHighlighting = false;

    public BarChart(BarChartModel barChartModel, BarChartPanel barChartPanel) {
        this.model = barChartModel;
        this.panel = barChartPanel;
        barChartModel.addBarChartModelListener(this);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.searcher = new Searcher(this, barChartPanel);
        this.searcher.setTopMargin(this.topMargin);
        this.addMouseListener(this.searcher);
        this.addMouseMotionListener(this.searcher);
        this.setAutoscrolls(true);
        this.barChartChanged();
        this.setToolTipText("...");
    }

    public void sizeChanged() {
        if (!this.autoResize) {
            return;
        }
        if (this.fontMetrics == null) {
            return;
        }
        if (this.leftJustified) {
            int n = this.leftMargin + this.getMaxRowLabelStringWidth();
            this.setBarLength(this.getParent().getWidth() - (n + this.horizSpacing + this.rightMargin));
        } else {
            this.barLengthMultiple = 250;
            int n = this.leftMargin + this.getMaxValueLabelStringWidth() + this.horizSpacing + this.barLengthMultiple + this.horizSpacing + this.getMaxRowLabelStringWidth() + this.rightMargin;
            if (n < this.getParent().getWidth()) {
                this.barLengthMultiple = Math.max(this.barLengthMultiple, this.getParent().getWidth() - (n - this.barLengthMultiple));
            }
            this.setBarLength(this.barLengthMultiple);
            n = this.leftMargin + this.getMaxValueLabelStringWidth() + this.horizSpacing + this.barLengthMultiple + this.horizSpacing + this.getMaxRowLabelStringWidth() + this.rightMargin;
            this.checkPreferredSize();
            this.revalidate();
        }
    }

    public boolean getLeftJustified() {
        return this.leftJustified;
    }

    public void setLeftJustified(boolean bl) {
        this.leftJustified = bl;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.rowLabelDrawObjects.size();
        int n4 = 0;
        while (n4 < n3) {
            DrawObject drawObject = (DrawObject)this.rowLabelDrawObjects.get(n4);
            if (n >= drawObject.getXBeg() && n <= drawObject.getXEnd() && n2 >= drawObject.getYBeg() && n2 <= drawObject.getYEnd()) {
                return this.model.getRowLabelToolTipText(n4 + this.rowStart);
            }
            ++n4;
        }
        n3 = this.valueDrawObjects.size();
        int n5 = 0;
        while (n5 < n3) {
            ArrayList arrayList = (ArrayList)this.valueDrawObjects.get(n5);
            int n6 = arrayList.size();
            int n7 = 0;
            while (n7 < n6) {
                DrawObject drawObject = (DrawObject)arrayList.get(n7);
                if (drawObject != null && n >= drawObject.getXBeg() && n <= drawObject.getXEnd() && n2 >= drawObject.getYBeg() && n2 <= drawObject.getYEnd()) {
                    if (n7 == n6 - 1) {
                        return this.model.getOtherToolTopText(n5 + this.rowStart);
                    }
                    return this.model.getValueToolTipText(n5 + this.rowStart, n7);
                }
                ++n7;
            }
            ++n5;
        }
        return null;
    }

    protected void paintComponent(Graphics graphics) {
        try {
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(Color.white);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.export((Graphics2D)graphics, true, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.rowLabelDrawObjects.size();
        int n4 = 0;
        while (n4 < n3) {
            DrawObject drawObject = (DrawObject)this.rowLabelDrawObjects.get(n4);
            if (n >= drawObject.getXBeg() && n <= drawObject.getXEnd() && n2 >= drawObject.getYBeg() && n2 <= drawObject.getYEnd()) {
                this.model.fireRowLabelClick(n4 + this.rowStart, mouseEvent, this);
                return;
            }
            ++n4;
        }
        n3 = this.valueDrawObjects.size();
        int n5 = 0;
        while (n5 < n3) {
            ArrayList arrayList = (ArrayList)this.valueDrawObjects.get(n5);
            int n6 = arrayList.size();
            int n7 = 0;
            while (n7 < n6) {
                DrawObject drawObject = (DrawObject)arrayList.get(n7);
                if (drawObject != null && n >= drawObject.getXBeg() && n <= drawObject.getXEnd() && n2 >= drawObject.getYBeg() && n2 <= drawObject.getYEnd() && n7 != n6 - 1) {
                    this.model.fireValueClick(n5 + this.rowStart, n7, mouseEvent, this);
                }
                ++n7;
            }
            ++n5;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private int getMaxRowLabelStringWidth() {
        if (this.fontMetrics == null) {
            return 0;
        }
        if (!this.maxRowLabelStringWidthSet) {
            this.maxRowLabelStringWidth = 0;
            int n = 0;
            while (n < this.model.getNumRows()) {
                String string = this.model.getRowLabel(n);
                this.maxRowLabelStringWidth = Math.max(this.maxRowLabelStringWidth, this.fontMetrics.stringWidth(string));
                ++n;
            }
            this.maxRowLabelStringWidthSet = true;
        }
        return this.maxRowLabelStringWidth;
    }

    private int getMaxValueLabelStringWidth() {
        if (!this.maxValueLabelStringWidthSet) {
            this.maxValueLabelStringWidth = 0;
            int n = 0;
            while (n < this.model.getNumRows()) {
                int n2 = 0;
                while (n2 < this.model.getSubSize()) {
                    String string = this.model.getValueLabel(n, n2);
                    this.maxValueLabelStringWidth = Math.max(this.maxValueLabelStringWidth, this.fontMetrics.stringWidth(string));
                    ++n2;
                }
                ++n;
            }
            this.maxValueLabelStringWidthSet = true;
        }
        return this.maxValueLabelStringWidth;
    }

    private void checkPreferredSize() {
        int n;
        int n2;
        if (this.preferredSizeSet || this.fontMetrics == null) {
            return;
        }
        this.preferredSizeSet = true;
        int n3 = this.model.getNumRows() * this.fontHeight + this.topMargin + this.fontMetrics.getMaxDescent() + this.fontMetrics.getLeading();
        if (!this.singleLine) {
            n2 = this.fontHeight * this.model.getSubSize() + 10;
            n3 = this.model.getNumRows() * n2;
        }
        if (this.autoResize) {
            int n4;
            if (!this.leftJustified) {
                n4 = this.leftMargin + this.getMaxValueLabelStringWidth() + this.horizSpacing + this.barLengthMultiple + this.horizSpacing + this.getMaxRowLabelStringWidth() + this.rightMargin;
                if (this.barLengthMultiple > 250) {
                    n4 = 0;
                }
            } else {
                n4 = 0;
            }
            this.setPreferredSize(new Dimension(n4, n3 + 5));
            this.setSize(new Dimension(n4, n3 + 5));
            this.invalidate();
            return;
        }
        if (this.model.getSubSize() == 1) {
            n = this.leftMargin + this.getMaxValueLabelStringWidth() + this.horizSpacing + this.barLengthMultiple + this.horizSpacing + this.getMaxRowLabelStringWidth() + this.rightMargin;
        } else if (this.singleLine) {
            if (this.stacked) {
                n = this.leftMargin + this.getMaxRowLabelStringWidth() + this.horizSpacing + this.barLengthMultiple + this.rightMargin;
            } else {
                n = this.leftMargin + this.getMaxRowLabelStringWidth() + this.horizSpacing + this.rightMargin;
                double d = 0.0;
                int n5 = 0;
                while (n5 < this.model.getSubSize()) {
                    int n6 = (int)(this.maxSubValues[n5] / this.maxRowSum * (double)this.barLengthMultiple);
                    if (n6 >= this.threshold) {
                        n = (int)((double)n + (this.maxSubValues[n5] / this.maxRowSum * (double)this.barLengthMultiple + (double)this.barHorizSpacing));
                    }
                    ++n5;
                }
            }
        } else {
            n2 = this.fontHeight * this.model.getSubSize() + 10;
            n = this.barLengthMultiple + this.getMaxRowLabelStringWidth() + this.getMaxValueLabelStringWidth() + this.leftMargin + 2 * this.horizSpacing + this.rightMargin;
            n3 = this.model.getNumRows() * n2;
        }
        super.setPreferredSize(new Dimension(n, n3 + 5));
        super.setSize(new Dimension(n, n3 + 5));
        this.invalidate();
    }

    private void processData() {
        if (this.dataProcessed) {
            return;
        }
        this.dataProcessed = true;
        this.maxRowValues = new double[this.model.getNumRows()];
        this.maxSubValues = new double[this.model.getSubSize()];
        this.rowSums = new double[this.model.getNumRows()];
        this.maxRowSum = 0.0;
        this.maxOverallValue = 0.0;
        int n = 0;
        while (n < this.model.getNumRows()) {
            double d = 0.0;
            int n2 = 0;
            while (n2 < this.model.getSubSize()) {
                double d2 = Math.max(0.0, this.model.getValue(n, n2));
                this.maxRowValues[n] = Math.max(this.maxRowValues[n], d2);
                this.maxSubValues[n2] = Math.max(this.maxSubValues[n2], d2);
                d += d2;
                int n3 = n;
                this.rowSums[n3] = this.rowSums[n3] + d2;
                this.maxOverallValue = Math.max(this.maxOverallValue, d2);
                ++n2;
            }
            this.maxRowSum = Math.max(this.maxRowSum, d);
            ++n;
        }
        this.maxSubSum = 0.0;
        int n4 = 0;
        while (n4 < this.model.getSubSize()) {
            double d = this.maxSubValues[n4];
            this.maxSubSum += d;
            ++n4;
        }
    }

    private Color lighter(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = Math.max(n, n2);
        n4 = Math.max(n4, n3);
        n4 = Math.max(n4, 255);
        n += (int)((double)(n4 - n) / 2.36);
        n2 += (int)((double)(n4 - n2) / 2.36);
        n3 += (int)((double)(n4 - n3) / 2.36);
        return new Color(n, n2, n3);
    }

    private void drawBar(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color, Color color2) {
        boolean bl = true;
        if (bl && n4 > 4) {
            graphics2D.setColor(color);
            graphics2D.fillRect(n, n2, n3, n4 - 1);
            graphics2D.setColor(this.lighter(color));
            int n5 = n4 / 4;
            graphics2D.fillRect(n, n2 + n5 / 2 + 1, n3, n5);
            int n6 = n5 / 3;
            graphics2D.setColor(this.lighter(this.lighter(color)));
            graphics2D.fillRect(n, n2 + n5 / 2 + 1 + n6, n3, n6);
            graphics2D.setColor(Color.black);
            if (color2 != null) {
                graphics2D.setColor(color2);
                graphics2D.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 3);
            }
            graphics2D.drawRect(n, n2, n3, n4 - 1);
        } else {
            n4 = Math.max(n4, 1);
            graphics2D.setColor(color);
            graphics2D.fillRect(n, n2, n3, n4);
            if (n4 > 3) {
                graphics2D.setColor(Color.black);
                if (color2 != null) {
                    graphics2D.setColor(color2);
                    graphics2D.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
                }
                graphics2D.drawRect(n, n2, n3, n4);
            }
        }
    }

    private void drawSingleGraph(Graphics2D graphics2D, int n, int n2, int n3) {
        int n4 = n;
        int n5 = this.rowStart;
        while (n5 <= this.rowEnd) {
            int n6;
            int n7;
            int n8;
            String string = this.model.getRowLabel(n5);
            int n9 = this.fontMetrics.stringWidth(string);
            ArrayList<DrawObject> arrayList = new ArrayList<DrawObject>();
            this.valueDrawObjects.add(arrayList);
            String string2 = this.model.getValueLabel(n5, 0);
            double d = this.model.getValue(n5, 0);
            double d2 = d / this.maxRowSum;
            int n10 = (int)(d2 * (double)this.barLengthMultiple);
            int n11 = this.fontMetrics.stringWidth(string2);
            int n12 = n4 - n3;
            if (this.leftJustified) {
                n8 = n2 + this.horizSpacing;
                n7 = n2 - n9;
                n6 = n2 + n10 + 2 * this.horizSpacing;
            } else {
                n8 = n2 - n10 - this.horizSpacing;
                n7 = n2;
                n6 = n2 - n10 - n11 - 2 * this.horizSpacing;
            }
            this.drawBar(graphics2D, n8, n12, n10, this.barHeight, this.model.getValueColor(n5, 0), this.model.getValueHighlightColor(n5, 0));
            arrayList.add(new DrawObject(n8, n12, n8 + n10, n4 - n3 + this.barHeight));
            this.searcher.drawHighlights(graphics2D, n7, n4, n5);
            graphics2D.setColor(Color.black);
            graphics2D.drawString(string, n7, n4);
            this.rowLabelDrawObjects.add(new DrawObject(n7, n4 - this.fontHeight, n7 + n9, n4));
            graphics2D.drawString(string2, n6, n4);
            n4 += this.rowHeight;
            arrayList.add(null);
            ++n5;
        }
    }

    private void drawMultiGraphHorizontal(Graphics2D graphics2D, int n, int n2, int n3) {
        int n4 = n;
        int n5 = this.rowStart;
        while (n5 <= this.rowEnd) {
            int n6;
            int n7;
            String string = this.model.getRowLabel(n5);
            int n8 = this.fontMetrics.stringWidth(string);
            ArrayList<DrawObject> arrayList = new ArrayList<DrawObject>();
            this.valueDrawObjects.add(arrayList);
            int n9 = n4 - n3;
            double d = !this.stacked ? this.maxSubSum : (this.normalized ? this.rowSums[n5] : this.maxRowSum);
            if (this.leftJustified) {
                n7 = n2 + this.horizSpacing;
                n6 = n2 - n8;
            } else {
                n7 = 0;
                n6 = 0;
            }
            this.searcher.drawHighlights(graphics2D, n6, n4, n5);
            graphics2D.setColor(Color.black);
            graphics2D.drawString(string, n6, n4);
            this.rowLabelDrawObjects.add(new DrawObject(n6, n4 - this.fontHeight, n6 + n8, n4));
            if (d > 0.0) {
                int n10;
                double d2 = 0.0;
                double d3 = 0.0;
                int n11 = 0;
                while (n11 < this.model.getSubSize()) {
                    graphics2D.setColor(this.model.getValueColor(n5, n11));
                    double d4 = this.model.getValue(n5, n11);
                    Color color = this.model.getValueColor(n5, n11);
                    double d5 = d4 / d;
                    int n12 = (int)(d5 * (double)this.barLengthMultiple + d3);
                    if (this.stacked) {
                        d3 = d5 * (double)this.barLengthMultiple + d3 - (double)n12;
                    }
                    if (n12 < this.threshold && this.stacked) {
                        d2 += d4;
                        arrayList.add(null);
                    } else {
                        int n13 = (int)(this.maxSubValues[n11] / d * (double)this.barLengthMultiple);
                        if (n13 < this.threshold) {
                            arrayList.add(null);
                            d2 += d4;
                        } else {
                            if (d4 < 0.0) {
                                arrayList.add(null);
                            } else if (n12 < this.threshold) {
                                arrayList.add(null);
                                d2 += d4;
                            } else {
                                if (n11 == this.mouseCol) {
                                    color = this.lighter(color);
                                }
                                this.drawBar(graphics2D, n7, n9, n12, this.barHeight, color, this.model.getValueHighlightColor(n5, n11));
                                arrayList.add(new DrawObject(n7, n9, n7 + n12, n9 + this.barHeight));
                            }
                            n7 = !this.stacked ? (int)((double)n7 + (this.maxSubValues[n11] / d * (double)this.barLengthMultiple + (double)this.barHorizSpacing)) : (n7 += n12);
                        }
                    }
                    ++n11;
                }
                if (this.normalized) {
                    n10 = this.barLengthMultiple + n2 + this.horizSpacing - n7;
                } else {
                    double d6 = d2 / d;
                    n10 = this.stacked ? (int)(d6 * (double)this.barLengthMultiple + d3) : (int)(d6 * (double)this.barLengthMultiple);
                }
                this.drawBar(graphics2D, n7, n9, n10, this.barHeight, Color.black, null);
                arrayList.add(new DrawObject(n7, n9, n7 + n10, n9 + this.barHeight));
            }
            n4 += this.rowHeight;
            ++n5;
        }
    }

    private void drawMultiGraphVertical(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = this.rowStart;
        while (n6 <= this.rowEnd) {
            String string = this.model.getRowLabel(n6);
            int n7 = this.fontMetrics.stringWidth(string);
            ArrayList arrayList = new ArrayList();
            this.valueDrawObjects.add(arrayList);
            double d = this.maxOverallValue;
            this.leftJustified = false;
            int n8 = this.leftJustified ? n2 - n7 : n2;
            int n9 = n5 + this.rowHeight / 2 - n4;
            this.searcher.drawHighlights(graphics2D, n8, n9, n6);
            graphics2D.setColor(Color.black);
            graphics2D.drawString(string, n8, n9);
            this.rowLabelDrawObjects.add(new DrawObject(n8, n9 - this.fontHeight, n8 + n7, n9));
            int n10 = n5;
            int n11 = 0;
            while (n11 < this.model.getSubSize()) {
                double d2 = this.model.getValue(n6, n11);
                if (d2 < 0.0) {
                    n10 += this.fontHeight;
                } else {
                    int n12;
                    int n13;
                    String string2 = this.model.getValueLabel(n6, n11);
                    int n14 = this.fontMetrics.stringWidth(string2);
                    double d3 = d2 / d;
                    int n15 = (int)(d3 * (double)this.barLengthMultiple);
                    if (this.leftJustified) {
                        n13 = n2 + this.horizSpacing;
                        n12 = n2 + n15 + 2 * this.horizSpacing;
                    } else {
                        n13 = n2 - n15 - this.horizSpacing;
                        n12 = n2 - n15 - n14 - 2 * this.horizSpacing;
                    }
                    this.drawBar(graphics2D, n13, n10 - n3, n15, this.barHeight, this.model.getValueColor(n6, n11), this.model.getValueHighlightColor(n6, 0));
                    graphics2D.drawString(string2, n12, n10);
                    n10 += this.fontHeight;
                }
                ++n11;
            }
            n5 += this.rowHeight;
            ++n6;
        }
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2) {
        Font font = ParaProf.preferencesWindow.getFont();
        graphics2D.setFont(font);
        this.fontMetrics = graphics2D.getFontMetrics(font);
        this.rowLabelDrawObjects.clear();
        this.valueDrawObjects.clear();
        this.fontHeight = this.fontMetrics.getHeight();
        int n = this.fontMetrics.getMaxDescent();
        int n2 = this.fontMetrics.getMaxAscent();
        int n3 = this.fontMetrics.getLeading();
        this.barHeight = n + n2 + n3 - 2;
        if (this.autoResize) {
            if (this.autoWidth != this.getParent().getWidth()) {
                this.sizeChanged();
            }
            this.autoWidth = this.getParent().getWidth();
        }
        this.processData();
        if (this.barLengthMultiple == 0) {
            this.sizeChanged();
        }
        int n4 = this.leftJustified ? this.leftMargin + this.getMaxRowLabelStringWidth() : this.leftMargin + this.getMaxValueLabelStringWidth() + this.horizSpacing + this.barLengthMultiple + this.horizSpacing;
        int n5 = (int)((float)n2 - ((float)n + (float)n2 + (float)n3 - (float)this.barHeight) / 2.0f);
        this.checkPreferredSize();
        this.rowHeight = this.fontHeight + this.additionalVerticalSpacing;
        int n6 = this.rowHeight + this.topMargin;
        if (!this.singleLine) {
            this.rowHeight = this.rowHeight * this.model.getSubSize() + 10;
        }
        this.searcher.setLineHeight(this.rowHeight);
        this.searcher.setMaxDescent(this.fontMetrics.getMaxDescent());
        int[] nArray = ParaProfUtils.computeClipping(this.panel.getViewport().getViewRect(), this.panel.getViewport().getViewRect(), true, bl2, this.model.getNumRows(), this.rowHeight, n6);
        this.rowStart = nArray[0];
        this.rowEnd = nArray[1];
        n6 = nArray[2];
        this.searcher.setVisibleLines(this.rowStart, this.rowEnd);
        this.searcher.setG2d(graphics2D);
        this.searcher.setXOffset(n4);
        if (this.model.getSubSize() == 1) {
            this.drawSingleGraph(graphics2D, n6, n4, n5);
        } else if (this.singleLine) {
            this.drawMultiGraphHorizontal(graphics2D, n6, n4, n5);
        } else {
            this.drawMultiGraphVertical(graphics2D, n6, n4, n5, n2);
        }
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        return null;
    }

    public void barChartChanged() {
        this.preferredSizeSet = false;
        this.maxValueLabelStringWidthSet = false;
        this.maxRowLabelStringWidthSet = false;
        this.dataProcessed = false;
        this.setSearchLines();
        this.barLengthMultiple = 0;
        this.repaint();
    }

    private void setSearchLines() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.model.getNumRows()) {
            arrayList.add(this.model.getRowLabel(n));
            ++n;
        }
        this.searcher.setSearchLines(arrayList);
    }

    public int getBarLength() {
        return this.barLengthMultiple;
    }

    public void setBarLength(int n) {
        this.barLength = n;
        this.barLengthMultiple = n;
        this.preferredSizeSet = false;
        if (!this.stacked) {
            int n2 = n;
            int n3 = n + 1;
            while (n3 > n) {
                int n4;
                n3 = 0;
                double d = 0.0;
                int n5 = 0;
                while (n5 < this.model.getSubSize()) {
                    n4 = (int)(this.maxSubValues[n5] / this.maxSubSum * (double)n2);
                    if (n4 < this.threshold) {
                        d += this.maxSubValues[n5];
                    } else {
                        n3 += n4 + this.barHorizSpacing;
                    }
                    ++n5;
                }
                n4 = (int)(d / this.maxSubSum * (double)n2);
                n3 += n4;
                if ((n3 += this.horizSpacing + this.horizSpacing) <= n) continue;
                --n2;
            }
            this.barLengthMultiple = n2;
        }
        this.checkPreferredSize();
    }

    public Searcher getSearcher() {
        return this.searcher;
    }

    public boolean getNormalized() {
        return this.normalized;
    }

    public void setNormalized(boolean bl) {
        this.normalized = bl;
        this.preferredSizeSet = false;
    }

    public boolean getStacked() {
        return this.stacked;
    }

    public void setStacked(boolean bl) {
        this.stacked = bl;
        this.setBarLength(this.barLength);
        this.preferredSizeSet = false;
        this.checkPreferredSize();
    }

    public boolean getSingleLine() {
        return this.singleLine;
    }

    public void setSingleLine(boolean bl) {
        this.singleLine = bl;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseCol = -1;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.valueDrawObjects.size();
        int n4 = 0;
        while (n4 < n3) {
            ArrayList arrayList = (ArrayList)this.valueDrawObjects.get(n4);
            int n5 = arrayList.size();
            int n6 = 0;
            while (n6 < n5) {
                DrawObject drawObject = (DrawObject)arrayList.get(n6);
                if (drawObject != null) {
                    int n7 = drawObject.getXBeg();
                    int n8 = drawObject.getXEnd();
                    int n9 = drawObject.getYBeg() - (this.rowHeight - drawObject.getHeight()) / 2;
                    int n10 = drawObject.getYEnd() + (int)(((double)(this.rowHeight - drawObject.getHeight()) + 0.5) / 2.0);
                    if (n >= n7 && n <= n8 && n2 >= n9 && n2 <= n10) {
                        this.mouseCol = n6;
                    }
                }
                ++n6;
            }
            ++n4;
        }
        this.repaint();
    }

    public int getAdditionalVerticalSpacing() {
        return this.additionalVerticalSpacing;
    }

    public void setAdditionalVerticalSpacing(int n) {
        this.additionalVerticalSpacing = n;
    }

    public boolean getAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean bl) {
        this.autoResize = bl;
    }
}

