/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.barchart;

import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.DataSorterWrapper;
import edu.uoregon.tau.paraprof.FunctionBarChartWindow;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.barchart.AbstractBarChartModel;
import edu.uoregon.tau.paraprof.barchart.LegendModel;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;

public class ComparisonBarChartModel
extends AbstractBarChartModel {
    private List ppTrials = new ArrayList();
    private List threads = new ArrayList();
    private Map rowMap = new HashMap();
    private List rows = new ArrayList();
    private DataSorter dataSorter;
    private FunctionBarChartWindow window;
    private LegendModel legendModel;

    public ComparisonBarChartModel(FunctionBarChartWindow functionBarChartWindow, ParaProfTrial paraProfTrial, Thread thread, DataSorter dataSorter) {
        this.window = functionBarChartWindow;
        this.dataSorter = dataSorter;
        this.addThread(paraProfTrial, thread);
    }

    public LegendModel getLegendModel() {
        if (this.legendModel == null) {
            this.legendModel = new LegendModel(){

                public int getNumElements() {
                    return ComparisonBarChartModel.this.ppTrials.size();
                }

                public String getLabel(int n) {
                    ParaProfTrial paraProfTrial = (ParaProfTrial)ComparisonBarChartModel.this.ppTrials.get(n);
                    Thread thread = (Thread)ComparisonBarChartModel.this.threads.get(n);
                    return paraProfTrial.getName() + " - " + ParaProfUtils.getThreadIdentifier(thread);
                }

                public Color getColor(int n) {
                    return ComparisonBarChartModel.this.getValueColor(0, n);
                }
            };
        }
        return this.legendModel;
    }

    public void addThread(ParaProfTrial paraProfTrial, Thread thread) {
        this.ppTrials.add(paraProfTrial);
        this.threads.add(thread);
    }

    public void reloadData() {
        Object object;
        this.rows.clear();
        this.rowMap.clear();
        ParaProfTrial paraProfTrial = (ParaProfTrial)this.ppTrials.get(0);
        Thread thread = (Thread)this.threads.get(0);
        this.dataSorter.setPpTrial(paraProfTrial);
        List list = this.dataSorter.getFunctionProfiles(thread);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)iterator.next();
            object = new RowBlob(pPFunctionProfile.getDisplayName());
            this.rows.add(object);
            ((ArrayList)object).add(pPFunctionProfile);
            this.rowMap.put(pPFunctionProfile.getDisplayName(), object);
        }
        int n = 1;
        while (n < this.ppTrials.size()) {
            object = (ParaProfTrial)this.ppTrials.get(n);
            Thread thread2 = (Thread)this.threads.get(n);
            DataSorterWrapper dataSorterWrapper = new DataSorterWrapper(this.dataSorter, (ParaProfTrial)object);
            list = dataSorterWrapper.getFunctionProfiles(thread2);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)iterator2.next();
                if (!((ParaProfTrial)object).displayFunction(pPFunctionProfile.getFunction())) continue;
                RowBlob rowBlob = (RowBlob)this.rowMap.get(pPFunctionProfile.getDisplayName());
                if (rowBlob != null) {
                    rowBlob.add(n, pPFunctionProfile);
                    continue;
                }
                rowBlob = new RowBlob(pPFunctionProfile.getDisplayName());
                this.rows.add(rowBlob);
                this.rowMap.put(pPFunctionProfile.getDisplayName(), rowBlob);
                rowBlob.add(n, pPFunctionProfile);
            }
            ++n;
        }
        Collections.sort(this.rows);
        this.fireModelChanged();
    }

    public int getNumRows() {
        return this.rows.size();
    }

    public int getSubSize() {
        return this.ppTrials.size();
    }

    public String getLabel(int n) {
        return null;
    }

    public double getValue(int n, int n2) {
        RowBlob rowBlob = (RowBlob)this.rows.get(n);
        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)rowBlob.get(n2);
        if (pPFunctionProfile == null) {
            return -1.0;
        }
        return pPFunctionProfile.getValue();
    }

    public String getValueLabel(int n, int n2) {
        double d = this.getValue(n, n2);
        if (this.window.getDataSorter().getValueType() == ValueType.EXCLUSIVE_PERCENT || this.window.getDataSorter().getValueType() == ValueType.INCLUSIVE_PERCENT) {
            return UtilFncs.getOutputString((int)0, (double)d, (int)6) + "%";
        }
        String string = "";
        if (this.getValue(n, 0) > 0.0 && n2 != 0) {
            double d2 = d / this.getValue(n, 0) * 100.0;
            string = " (" + UtilFncs.getOutputString((int)0, (double)d2, (int)2) + "%)";
        }
        return UtilFncs.getOutputString((int)this.window.units(), (double)d, (int)ParaProf.defaultNumberPrecision) + string;
    }

    public String getRowLabel(int n) {
        RowBlob rowBlob = (RowBlob)this.rows.get(n);
        return rowBlob.getFunctionName();
    }

    public Color getValueColor(int n, int n2) {
        Vector vector = ParaProf.colorChooser.getColors();
        return (Color)vector.get(n2 % vector.size());
    }

    public Color getValueHighlightColor(int n, int n2) {
        return null;
    }

    public void fireValueClick(int n, int n2, MouseEvent mouseEvent, JComponent jComponent) {
    }

    public void fireRowLabelClick(int n, MouseEvent mouseEvent, JComponent jComponent) {
    }

    public String getValueToolTipText(int n, int n2) {
        return null;
    }

    public String getRowLabelToolTipText(int n) {
        return null;
    }

    public String getOtherToolTopText(int n) {
        return null;
    }

    public static void main(String[] stringArray) {
        ParaProf.initialize();
        File[] fileArray = new File[]{new File("/home/amorris/data/packed/lu.C.512.ppk")};
        ParaProfTrial paraProfTrial = ComparisonBarChartModel.loadTrial(fileArray, 7);
        fileArray[0] = new File("/home/amorris/data/packed/lu.A.128.ppk");
        ParaProfTrial paraProfTrial2 = ComparisonBarChartModel.loadTrial(fileArray, 7);
        FunctionBarChartWindow functionBarChartWindow = FunctionBarChartWindow.CreateComparisonWindow(paraProfTrial, paraProfTrial.getDataSource().getMeanData(), null);
        functionBarChartWindow.addThread(paraProfTrial, paraProfTrial.getDataSource().getThread(0, 0, 0));
        functionBarChartWindow.addThread(paraProfTrial, paraProfTrial.getDataSource().getThread(1, 0, 0));
        functionBarChartWindow.addThread(paraProfTrial2, paraProfTrial2.getDataSource().getMeanData());
        ((Component)functionBarChartWindow).setVisible(true);
    }

    public static ParaProfTrial loadTrial(File[] fileArray, int n) {
        ParaProfApplication paraProfApplication = ParaProf.applicationManager.addApplication();
        paraProfApplication.setName("New Application");
        ParaProfExperiment paraProfExperiment = paraProfApplication.addExperiment();
        ParaProf.paraProfManagerWindow.addTrial(paraProfApplication, paraProfExperiment, fileArray, n, false, false);
        Vector vector = paraProfExperiment.getTrials();
        ParaProfTrial paraProfTrial = (ParaProfTrial)vector.get(0);
        while (paraProfTrial.loading()) {
            ComparisonBarChartModel.sleep(500);
        }
        return paraProfTrial;
    }

    private static void sleep(int n) {
        try {
            java.lang.Thread.sleep(n);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception while sleeping");
        }
    }

    public List getThreads() {
        return this.threads;
    }

    public List getPpTrials() {
        return this.ppTrials;
    }

    public void setThreads(List list) {
        this.threads = list;
    }

    private class RowBlob
    extends ArrayList
    implements Comparable {
        String functionName;

        public RowBlob(String string) {
            this.functionName = string;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public void add(int n, Object object) {
            while (n >= this.size()) {
                this.add(null);
            }
            super.set(n, object);
        }

        public Object get(int n) {
            if (n >= this.size()) {
                return null;
            }
            return super.get(n);
        }

        private double getMax() {
            double d = 0.0;
            int n = 0;
            while (n < ComparisonBarChartModel.this.ppTrials.size()) {
                PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)this.get(n);
                if (pPFunctionProfile != null) {
                    d = Math.max(d, pPFunctionProfile.getSortValue());
                }
                ++n;
            }
            return d;
        }

        private int privateCompare(RowBlob rowBlob) {
            if (ComparisonBarChartModel.this.dataSorter.getSortType() == SortType.NAME) {
                return this.functionName.compareTo(rowBlob.getFunctionName());
            }
            return (int)(rowBlob.getMax() - this.getMax());
        }

        public int compareTo(Object object) {
            if (ComparisonBarChartModel.this.dataSorter.getDescendingOrder()) {
                return this.privateCompare((RowBlob)object);
            }
            return -this.privateCompare((RowBlob)object);
        }
    }
}

