/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.graph;

import edu.uoregon.tau.paraprof.graph.Vertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Layout {
    private static final int HORIZONTAL_SPACING = 10;
    private static final int MARGIN = 20;

    public static void runSugiyama(List list) {
        Layout.runPhaseOne(list);
    }

    private static void runPhaseOne(List list) {
        int n = 100;
        while (n > 0) {
            int n2 = 0;
            while (n2 < list.size() - 1) {
                Layout.assignBaryCenters((List)list.get(n2), (List)list.get(n2 + 1), true);
                Collections.sort((List)list.get(n2));
                ++n2;
            }
            int n3 = list.size() - 1;
            while (n3 > 0) {
                Layout.assignBaryCenters((List)list.get(n3), (List)list.get(n3 - 1), false);
                Collections.sort((List)list.get(n3));
                --n3;
            }
            --n;
        }
    }

    private static void assignBaryCenters(List list, List list2, boolean bl) {
        int n = 0;
        while (n < list2.size()) {
            Vertex vertex = (Vertex)list2.get(n);
            vertex.setLevelIndex(n);
            ++n;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            int n3;
            int n4;
            Vertex vertex = (Vertex)list.get(n2);
            if (bl) {
                n4 = 0;
                n3 = 0;
                while (n3 < vertex.getChildren().size()) {
                    n4 += ((Vertex)vertex.getChildren().get(n3)).getLevelIndex();
                    ++n3;
                }
                if (vertex.getChildren().size() != 0) {
                    vertex.setBaryCenter(n4 / vertex.getChildren().size());
                }
            } else {
                n4 = 0;
                n3 = 0;
                while (n3 < vertex.getParents().size()) {
                    n4 += ((Vertex)vertex.getParents().get(n3)).getLevelIndex();
                    ++n3;
                }
                if (vertex.getParents().size() != 0) {
                    vertex.setBaryCenter(n4 / vertex.getParents().size());
                }
            }
            ++n2;
        }
    }

    private static void assignGridBaryCenters(List list, boolean bl, boolean bl2) {
        int n = 0;
        while (n < list.size()) {
            int n2;
            float f;
            Vertex vertex = (Vertex)list.get(n);
            if (bl) {
                if (vertex.getChildren().size() != 0) {
                    f = 0.0f;
                    n2 = 0;
                    while (n2 < vertex.getChildren().size()) {
                        f += (float)((Vertex)vertex.getChildren().get(n2)).getPosition();
                        ++n2;
                    }
                    vertex.setGridBaryCenter(f / (float)vertex.getChildren().size());
                }
            } else if (vertex.getParents().size() != 0) {
                f = 0.0f;
                n2 = 0;
                while (n2 < vertex.getParents().size()) {
                    f += (float)((Vertex)vertex.getParents().get(n2)).getPosition();
                    ++n2;
                }
                vertex.setGridBaryCenter(f / (float)vertex.getParents().size());
            }
            ++n;
        }
    }

    private static void improvePositions(List list, int n, boolean bl, boolean bl2) {
        List list2 = (List)list.get(n);
        Layout.assignGridBaryCenters(list2, bl, bl2);
        int n2 = 0;
        while (n2 < list2.size()) {
            Vertex vertex = (Vertex)list2.get(n2);
            int n3 = (int)vertex.getGridBaryCenter();
            if (!bl || vertex.getChildren().size() != 0) {
                int n4;
                int n5;
                if (n3 > vertex.getPosition()) {
                    n5 = Layout.moveRight(list2, n2, n3 - vertex.getPosition(), bl, vertex.getPriority(bl));
                    n4 = n2 - 1;
                    while (n4 >= 0 && bl2) {
                        Layout.moveRight(list2, n4, n5, bl, vertex.getPriority(bl));
                        --n4;
                    }
                } else {
                    n5 = Layout.moveLeft(list2, n2, vertex.getPosition() - n3, bl, vertex.getPriority(bl));
                    n4 = n2 + 1;
                    while (n4 < list2.size() && bl2) {
                        Layout.moveLeft(list2, n4, n5, bl, vertex.getPriority(bl));
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    private static int moveRight(List list, int n, int n2, boolean bl, int n3) {
        int n4;
        Vertex vertex = (Vertex)list.get(n);
        int n5 = n + 1;
        if (n5 >= list.size()) {
            vertex.setPosition(vertex.getPosition() + n2);
            return n2;
        }
        Vertex vertex2 = (Vertex)list.get(n5);
        int n6 = vertex.getPosition() + vertex.getWidth() / 2;
        if (n6 + n2 + 10 < (n4 = vertex2.getPosition() - vertex2.getWidth() / 2)) {
            vertex.setPosition(vertex.getPosition() + n2);
            return n2;
        }
        if (vertex2.getPriority(bl) > n3) {
            int n7 = vertex2.getPosition() - (vertex.getWidth() + vertex2.getWidth()) / 2 - 10;
            int n8 = n7 - vertex.getPosition();
            vertex.setPosition(vertex.getPosition() + n8);
            return n8;
        }
        int n9 = vertex.getPosition() + n2 + (vertex2.getWidth() + vertex.getWidth()) / 2 + 10;
        Layout.moveRight(list, n5, n9 - vertex2.getPosition(), bl, n3);
        int n10 = vertex2.getPosition() - (vertex.getWidth() + vertex2.getWidth()) / 2 - 10;
        int n11 = n10 - vertex.getPosition();
        vertex.setPosition(vertex.getPosition() + n11);
        return n11;
    }

    private static int moveLeft(List list, int n, int n2, boolean bl, int n3) {
        int n4;
        Vertex vertex = (Vertex)list.get(n);
        int n5 = n - 1;
        if (n5 < 0) {
            vertex.setPosition(vertex.getPosition() - n2);
            return n2;
        }
        Vertex vertex2 = (Vertex)list.get(n5);
        int n6 = vertex.getPosition() - vertex.getWidth() / 2;
        if (n6 - n2 - 10 > (n4 = vertex2.getPosition() + vertex2.getWidth() / 2)) {
            vertex.setPosition(vertex.getPosition() - n2);
            return n2;
        }
        if (vertex2.getPriority(bl) > n3) {
            int n7 = vertex2.getPosition() + (vertex2.getWidth() + vertex.getWidth()) / 2 + 10;
            int n8 = vertex.getPosition() - n7;
            vertex.setPosition(vertex.getPosition() - n8);
            return n8;
        }
        int n9 = vertex.getPosition() - n2 - vertex.getWidth() / 2 - 10 - vertex2.getWidth() / 2;
        Layout.moveLeft(list, n5, vertex2.getPosition() - n9, bl, n3);
        int n10 = vertex2.getPosition() + (vertex2.getWidth() + vertex.getWidth()) / 2 + 10;
        int n11 = vertex.getPosition() - n10;
        vertex.setPosition(vertex.getPosition() - n11);
        return n11;
    }

    public static void assignPositions(List list) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        while (n6 < list.size()) {
            List list2 = (List)list.get(n6);
            n5 = 0;
            ((Vertex)list2.get(0)).setPosition(0);
            n4 = 1;
            while (n4 < list2.size()) {
                Vertex vertex = (Vertex)list2.get(n4);
                vertex.setPosition(n5 + 10 + (((Vertex)list2.get(n4 - 1)).getWidth() + vertex.getWidth()) / 2);
                n5 = vertex.getPosition();
                vertex.setDownPriority(vertex.getChildren().size());
                if (vertex.getUserObject() == null) {
                    vertex.setDownPriority(2);
                }
                vertex.setUpPriority(vertex.getParents().size());
                if (vertex.getUserObject() == null) {
                    vertex.setUpPriority(2);
                }
                ++n4;
            }
            if (list2.size() % 2 == 0) {
                n3 = ((Vertex)list2.get((list2.size() - 2) / 2)).getPosition();
                n2 = ((Vertex)list2.get(list2.size() / 2)).getPosition();
                n = (n3 + n2) / 2;
            } else {
                n = ((Vertex)list2.get((list2.size() - 1) / 2)).getPosition();
            }
            n3 = 0;
            while (n3 < list2.size()) {
                Vertex vertex = (Vertex)list2.get(n3);
                vertex.setPosition(vertex.getPosition() - n);
                ++n3;
            }
            ++n6;
        }
        int n7 = 1;
        while (n7 < list.size()) {
            Layout.improvePositions(list, n7, false, false);
            ++n7;
        }
        n5 = list.size() - 2;
        while (n5 >= 0) {
            Layout.improvePositions(list, n5, true, false);
            --n5;
        }
        n4 = 1;
        while (n4 < list.size()) {
            Layout.improvePositions(list, n4, false, false);
            ++n4;
        }
        n = list.size() - 2;
        while (n >= 0) {
            Layout.improvePositions(list, n, true, true);
            --n;
        }
        n3 = list.size() - 2;
        while (n3 >= 0) {
            Layout.improvePositions(list, n3, true, false);
            --n3;
        }
        n2 = 0;
        int n8 = 0;
        while (n8 < list.size()) {
            List list3 = (List)list.get(n8);
            int n9 = 0;
            while (n9 < list3.size()) {
                Vertex vertex = (Vertex)list3.get(n9);
                if (vertex.getPosition() - vertex.getWidth() / 2 < n2) {
                    n2 = vertex.getPosition() - vertex.getWidth() / 2;
                }
                ++n9;
            }
            ++n8;
        }
        int n10 = 0;
        while (n10 < list.size()) {
            List list4 = (List)list.get(n10);
            int n11 = 0;
            while (n11 < list4.size()) {
                Vertex vertex = (Vertex)list4.get(n11);
                vertex.setPosition(vertex.getPosition() + (-n2 + 20));
                ++n11;
            }
            ++n10;
        }
    }

    public static void assignLevel(Vertex vertex) {
        int n = 0;
        int n2 = 0;
        while (n2 < vertex.getParents().size()) {
            Vertex vertex2 = (Vertex)vertex.getParents().get(n2);
            if (vertex2.getLevel() == -1) {
                Layout.assignLevel(vertex2);
            }
            if (vertex2.getLevel() > n) {
                n = vertex2.getLevel();
            }
            ++n2;
        }
        vertex.setLevel(n + 1);
    }

    public static void fillLevels(Vertex vertex, List list, int n) {
        if (vertex.getVisited()) {
            return;
        }
        vertex.setVisited(true);
        if (list.size() == n) {
            list.add(new ArrayList());
        }
        vertex.setLevel(n);
        List list2 = (List)list.get(n);
        list2.add(vertex);
        int n2 = 0;
        while (n2 < vertex.getChildren().size()) {
            Vertex vertex2 = (Vertex)vertex.getChildren().get(n2);
            Layout.fillLevels(vertex2, list, n + 1);
            ++n2;
        }
    }

    public static void insertDummies(Vertex vertex) {
        int n = 0;
        while (n < vertex.getChildren().size()) {
            Vertex vertex2 = (Vertex)vertex.getChildren().get(n);
            if (vertex2.getLevel() - vertex.getLevel() > 1) {
                vertex.getChildren().remove(n);
                vertex2.getParents().remove(vertex);
                Vertex vertex3 = new Vertex(null, 1, 1);
                vertex3.setLevel(vertex.getLevel() + 1);
                vertex3.getChildren().add(vertex2);
                vertex2.getParents().add(vertex3);
                vertex.getChildren().add(n, vertex3);
                vertex3.getParents().add(vertex);
                Layout.insertDummies(vertex3);
            }
            ++n;
        }
    }

    public static List findRoots(Map map) {
        Object object;
        Object object2;
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            object2 = (Vertex)iterator.next();
            ((Vertex)object2).setVisited(false);
        }
        object2 = map.values().iterator();
        while (object2.hasNext()) {
            object = (Vertex)object2.next();
            int n = 0;
            while (n < ((Vertex)object).getChildren().size()) {
                Vertex vertex = (Vertex)((Vertex)object).getChildren().get(n);
                vertex.setVisited(true);
                ++n;
            }
        }
        object = map.values().iterator();
        while (object.hasNext()) {
            Vertex vertex = (Vertex)object.next();
            if (vertex.getVisited()) continue;
            arrayList.add(vertex);
        }
        return arrayList;
    }
}

