/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.tablemodel;

import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.Experiment;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultTreeModel;

public class ExperimentTableModel
extends AbstractTableModel {
    private ParaProfExperiment experiment;
    private String[] columnNames = new String[]{"ExpField", "Value"};
    private ParaProfManagerWindow paraProfManager;
    private DefaultTreeModel defaultTreeModel;
    private List fieldNames;

    public ExperimentTableModel(ParaProfManagerWindow paraProfManagerWindow, ParaProfExperiment paraProfExperiment, DefaultTreeModel defaultTreeModel) {
        this.experiment = paraProfExperiment;
        this.paraProfManager = paraProfManagerWindow;
        this.defaultTreeModel = defaultTreeModel;
        this.fieldNames = new ArrayList();
        this.fieldNames.add("Name");
        this.fieldNames.add("Application ID");
        this.fieldNames.add("Experiment ID");
        int n = 0;
        while (n < this.experiment.getNumFields()) {
            this.fieldNames.add(this.experiment.getFieldName(n));
            ++n;
        }
    }

    public void updateDatabaseFields(ParaProfExperiment paraProfExperiment) {
        if (paraProfExperiment != null) {
            this.fieldNames = new ArrayList();
            this.fieldNames.add("Name");
            this.fieldNames.add("Application ID");
            int n = 0;
            while (n < this.experiment.getNumFields()) {
                this.fieldNames.add(this.experiment.getFieldName(n));
                ++n;
            }
            int n2 = 0;
            while (n2 < paraProfExperiment.getNumFields()) {
                this.fieldNames.add(paraProfExperiment.getFieldName(n2));
                ++n2;
            }
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public int getRowCount() {
        return this.fieldNames.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.fieldNames.get(n);
        }
        switch (n) {
            case 0: {
                return this.experiment.getName();
            }
            case 1: {
                return new Integer(this.experiment.getApplicationID());
            }
            case 2: {
                return new Integer(this.experiment.getID());
            }
        }
        return this.experiment.getField(n - 3);
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 1 && n != 1 && n != 2;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (!(object instanceof String)) {
            return;
        }
        String string = (String)object;
        if (n == 0) {
            this.experiment.setName(string);
            this.updateDB();
        } else {
            this.experiment.setField(n - 3, string);
            this.updateDB();
        }
        this.defaultTreeModel.nodeChanged(this.experiment.getDMTN());
    }

    private void updateDB() {
        DatabaseAPI databaseAPI;
        if (this.experiment.dBExperiment() && (databaseAPI = this.paraProfManager.getDatabaseAPI(this.experiment.getDatabase())) != null) {
            databaseAPI.saveExperiment((Experiment)this.experiment);
            databaseAPI.terminate();
        }
    }
}

