/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.common.treetable.AbstractTreeTableModel;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.treetable.TreeTableNode;
import edu.uoregon.tau.paraprof.treetable.TreeTableWindow;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CallPathModel
extends AbstractTreeTableModel {
    private List roots;
    private Thread thread;
    private DataSource dataSource;
    private ParaProfTrial ppTrial;
    private double[] maxValues;
    private int sortColumn;
    private boolean sortAscending;
    private int colorMetric;
    private boolean reversedCallPaths = true;
    private TreeTableWindow window;
    static /* synthetic */ Class class$edu$uoregon$tau$common$treetable$TreeTableModel;

    public CallPathModel(TreeTableWindow treeTableWindow, ParaProfTrial paraProfTrial, Thread thread, boolean bl) {
        super(null);
        this.window = treeTableWindow;
        this.root = new TreeTableNode(null, this, "root");
        this.dataSource = paraProfTrial.getDataSource();
        this.thread = thread;
        this.ppTrial = paraProfTrial;
        this.reversedCallPaths = bl;
        this.setupData();
    }

    private void setupData() {
        this.roots = new ArrayList();
        DataSorter dataSorter = new DataSorter(this.ppTrial);
        List list = dataSorter.getCallPathFunctionProfiles(this.thread);
        HashMap<Function, String> hashMap = new HashMap<Function, String>();
        Group group = this.ppTrial.getGroup("TAU_CALLPATH_DERIVED");
        if (this.window.getTreeMode()) {
            Object object;
            Object object2;
            Object object3;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object3 = (PPFunctionProfile)iterator.next();
                object2 = ((PPFunctionProfile)object3).getFunctionProfile();
                if (object2 == null || !object2.isCallPathFunction()) continue;
                if (this.reversedCallPaths) {
                    object = UtilFncs.getRevLeftSide((String)object2.getFunction().getReversedName());
                } else {
                    if (object2.getFunction().isGroupMember(group)) continue;
                    object = UtilFncs.getLeftSide((String)object2.getName());
                }
                if (hashMap.get(hashMap) != null) continue;
                hashMap.put((Function)object, "1");
            }
            object3 = hashMap.keySet().iterator();
            while (object3.hasNext()) {
                TreeTableNode treeTableNode;
                object2 = (String)object3.next();
                object = this.dataSource.getFunction((String)object2);
                if (object == null) {
                    treeTableNode = new TreeTableNode(null, this, (String)object2);
                } else {
                    FunctionProfile functionProfile = this.thread.getFunctionProfile(object);
                    treeTableNode = new TreeTableNode(functionProfile, this, null);
                }
                this.roots.add(treeTableNode);
            }
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)iterator.next();
                FunctionProfile functionProfile = pPFunctionProfile.getFunctionProfile();
                if (functionProfile == null || !this.ppTrial.displayFunction(functionProfile.getFunction())) continue;
                String string = functionProfile.getName();
                TreeTableNode treeTableNode = new TreeTableNode(functionProfile, this, null);
                this.roots.add(treeTableNode);
            }
        }
        Collections.sort(this.roots);
        this.computeMaximum();
    }

    public void computeMaximum() {
        int n = this.window.getPPTrial().getNumberOfMetrics();
        this.maxValues = new double[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            this.maxValues[n3] = this.maxValues[n3] + this.thread.getMaxInclusive(n2, this.ppTrial.getSelectedSnapshot());
            ++n2;
        }
    }

    public int getColumnCount() {
        return 1 + this.window.getColumns().size();
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Name";
        }
        return this.window.getColumns().get(n - 1).toString();
    }

    public Object getValueAt(Object object, int n) {
        if (object == this.root) {
            return null;
        }
        TreeTableNode treeTableNode = (TreeTableNode)object;
        return treeTableNode;
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return class$edu$uoregon$tau$common$treetable$TreeTableModel == null ? (class$edu$uoregon$tau$common$treetable$TreeTableModel = CallPathModel.class$("edu.uoregon.tau.common.treetable.TreeTableModel")) : class$edu$uoregon$tau$common$treetable$TreeTableModel;
        }
        return this.window.getColumns().get(n - 1).getClass();
    }

    public int getChildCount(Object object) {
        if (object == this.root) {
            return this.roots.size();
        }
        if (this.window.getTreeMode()) {
            TreeTableNode treeTableNode = (TreeTableNode)object;
            return treeTableNode.getNumChildren();
        }
        return 0;
    }

    public Object getChild(Object object, int n) {
        if (object == this.root) {
            return this.roots.get(n);
        }
        TreeTableNode treeTableNode = (TreeTableNode)object;
        return treeTableNode.getChildren().get(n);
    }

    public Thread getThread() {
        return this.thread;
    }

    public double[] getMaxValues() {
        return this.maxValues;
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public boolean getSortAscending() {
        return this.sortAscending;
    }

    public void sortColumn(int n, boolean bl) {
        super.sortColumn(n, bl);
        this.sortColumn = n;
        this.sortAscending = bl;
        Collections.sort(this.roots);
        Iterator iterator = this.roots.iterator();
        while (iterator.hasNext()) {
            TreeTableNode treeTableNode = (TreeTableNode)iterator.next();
            treeTableNode.sortChildren();
        }
    }

    public TreeTableWindow getWindow() {
        return this.window;
    }

    public ParaProfTrial getPPTrial() {
        return this.ppTrial;
    }

    public boolean getReversedCallPaths() {
        return this.reversedCallPaths;
    }

    public void setReversedCallPaths(boolean bl) {
        this.reversedCallPaths = bl;
    }

    public int getColorMetric() {
        return this.colorMetric;
    }

    public void setColorMetric(int n) {
        this.colorMetric = n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

