/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.paraprof.treetable.ContextEventModel;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class ContextEventTreeNode
extends DefaultMutableTreeNode
implements Comparable {
    private List children;
    private String displayName;
    private ContextEventModel model;
    private UserEventProfile userEventProfile;
    private String name;

    public ContextEventTreeNode(String string, ContextEventModel contextEventModel) {
        this(null, contextEventModel, string);
    }

    public ContextEventTreeNode(UserEventProfile userEventProfile, ContextEventModel contextEventModel, String string) {
        this.userEventProfile = userEventProfile;
        this.model = contextEventModel;
        if (userEventProfile == null) {
            this.name = string;
            this.displayName = UtilFncs.getRightMost((String)string);
        } else {
            this.name = userEventProfile.getUserEvent().getName();
            this.displayName = this.name.substring(0, this.name.indexOf(":")).trim();
        }
    }

    public UserEventProfile getUserEventProfile() {
        return this.userEventProfile;
    }

    public List getChildren() {
        this.checkInitChildren();
        return this.children;
    }

    private String removeRuns(String string) {
        int n = string.indexOf("  ");
        while (n > 0) {
            string = string.substring(0, n) + string.substring(n + 1);
            n = string.indexOf("  ");
        }
        return string;
    }

    private void checkInitChildren() {
        if (this.children == null) {
            Object object;
            String string;
            UserEventProfile userEventProfile;
            this.children = new ArrayList();
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            List list = this.model.getThread().getUserEventProfiles();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object2;
                userEventProfile = (UserEventProfile)iterator.next();
                if (userEventProfile == null || !userEventProfile.getUserEvent().isContextEvent()) continue;
                string = userEventProfile.getName().substring(userEventProfile.getName().indexOf(":") + 1).trim();
                if (!(string = this.removeRuns(string)).startsWith(this.name)) continue;
                object = string.substring(this.name.length()).trim();
                if (((String)object).startsWith("=>")) {
                    object = ((String)object).substring(2).trim();
                    object2 = this.name + " => " + UtilFncs.getLeftSide((String)object);
                    hashMap.put(object2, "1");
                    continue;
                }
                if (((String)object).length() != 0) continue;
                object2 = new ContextEventTreeNode(userEventProfile, this.model, null);
                this.children.add(object2);
            }
            userEventProfile = hashMap.keySet().iterator();
            while (userEventProfile.hasNext()) {
                string = (String)userEventProfile.next();
                object = new ContextEventTreeNode(string, this.model);
                this.children.add(object);
            }
        }
    }

    public int getNumChildren() {
        this.checkInitChildren();
        return this.children.size();
    }

    public void sortChildren() {
        if (this.children != null) {
            Collections.sort(this.children);
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ContextEventTreeNode contextEventTreeNode = (ContextEventTreeNode)iterator.next();
                contextEventTreeNode.sortChildren();
            }
        }
    }

    public int compareTo(Object object) {
        int n = 0;
        int n2 = this.model.getSortColumn();
        if (n2 == 0) {
            n = this.toString().compareTo(((ContextEventTreeNode)object).toString());
        } else {
            Double d = (Double)this.model.getValueAt(object, n2);
            Double d2 = (Double)this.model.getValueAt(this, n2);
            if (d == null && d2 != null) {
                return 1;
            }
            if (d != null && d2 == null) {
                return -1;
            }
            n = d == null && d2 == null ? 0 : (int)(d2 - d);
        }
        if (this.model.getSortAscending()) {
            return -n;
        }
        return n;
    }

    public String toString() {
        return this.displayName;
    }
}

