/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.paraprof.ColorBar;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.treetable.CallPathModel;
import edu.uoregon.tau.paraprof.treetable.TreeTableColumn;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class TreeTableNode
extends DefaultMutableTreeNode
implements Comparable {
    private List children;
    private FunctionProfile functionProfile;
    private String displayName;
    private boolean expanded;
    private CallPathModel model;
    private String alternateName;

    public TreeTableNode(FunctionProfile functionProfile, CallPathModel callPathModel, String string) {
        this.functionProfile = functionProfile;
        this.model = callPathModel;
        this.alternateName = string;
        this.displayName = functionProfile != null ? (callPathModel.getWindow().getTreeMode() ? (callPathModel.getReversedCallPaths() ? ParaProfUtils.getReversedLeafDisplayName(functionProfile.getFunction()) : ParaProfUtils.getLeafDisplayName(functionProfile.getFunction())) : ParaProfUtils.getDisplayName(functionProfile.getFunction())) : string;
    }

    public FunctionProfile getFunctionProfile() {
        return this.functionProfile;
    }

    public List getChildren() {
        this.checkInitChildren();
        return this.children;
    }

    public int getNumChildren() {
        this.checkInitChildren();
        return this.children.size();
    }

    private void checkInitChildren() {
        if (this.children == null) {
            Object object;
            Object object2;
            Object object3;
            this.children = new ArrayList();
            List list = this.model.getThread().getFunctionProfiles();
            boolean bl = false;
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            boolean bl2 = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string;
                int n;
                int n2;
                object3 = (FunctionProfile)iterator.next();
                if (object3 == this.functionProfile || object3 == null || !object3.isCallPathFunction()) continue;
                if (this.model.getReversedCallPaths()) {
                    object2 = object3.getFunction().getReversedName();
                    object = "<=";
                } else {
                    object2 = object3.getName();
                    object = "=>";
                }
                String string2 = this.alternateName;
                if (this.functionProfile != null) {
                    string2 = this.model.getReversedCallPaths() ? this.functionProfile.getFunction().getReversedName() : this.functionProfile.getName();
                }
                if ((n2 = ((String)object2).indexOf(string2)) != -1) {
                    int n3 = ((String)object2).indexOf((String)object, n2 + string2.length());
                    n = ((String)object2).indexOf((String)object, n3 + 1);
                    if (n3 != -1) {
                        bl = true;
                        if (n == -1) {
                            hashMap.put(object3, new Object());
                        } else if (this.model.getReversedCallPaths()) {
                            hashMap.put(((String)object2).substring(0, n), new Object());
                        } else {
                            hashMap.put(((String)object2).substring(0, n), new Object());
                        }
                    }
                }
                if (n2 != 0 || (n = (string = ((String)object2).substring(string2.length()).trim()).lastIndexOf((String)object)) != 0) continue;
                bl2 = true;
                TreeTableNode treeTableNode = new TreeTableNode((FunctionProfile)object3, this.model, null);
                this.children.add(treeTableNode);
            }
            if (!bl2 && bl) {
                object3 = hashMap.keySet().iterator();
                while (object3.hasNext()) {
                    object2 = object3.next();
                    object = object2 instanceof String ? new TreeTableNode(null, this.model, (String)object2) : new TreeTableNode((FunctionProfile)object2, this.model, null);
                    this.children.add(object);
                }
            }
        }
        Collections.sort(this.children);
    }

    public String toString() {
        return this.displayName;
    }

    public boolean getExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    public double getColorValue(int n, boolean bl) {
        if (!this.model.getWindow().getTreeMode()) {
            return -1.0;
        }
        if (this.functionProfile == null) {
            double d = 0.0;
            if (bl) {
                d = 0.0;
            } else {
                Iterator iterator = this.getChildren().iterator();
                while (iterator.hasNext()) {
                    TreeTableNode treeTableNode = (TreeTableNode)iterator.next();
                    d += treeTableNode.getColorValue(n, false);
                }
            }
            return d;
        }
        if (this.functionProfile != null && this.model.getMaxValues()[n] != 0.0) {
            double d = bl ? this.functionProfile.getExclusive(n) : this.functionProfile.getInclusive(n);
            return d;
        }
        return 0.0;
    }

    public Color getColor(int n) {
        double d = this.getColorValue(n, this.expanded);
        if (d == -1.0) {
            return null;
        }
        Color color = ColorBar.getColor((float)(d / this.model.getMaxValues()[n]));
        return color;
    }

    public void sortChildren() {
        if (this.children != null) {
            Collections.sort(this.children);
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                TreeTableNode treeTableNode = (TreeTableNode)iterator.next();
                treeTableNode.sortChildren();
            }
        }
    }

    public int compareTo(Object object) {
        int n;
        if (this.model.getSortColumn() == 0) {
            n = this.toString().compareTo(((TreeTableNode)object).toString());
        } else {
            TreeTableColumn treeTableColumn = (TreeTableColumn)this.model.getWindow().getColumns().get(this.model.getSortColumn() - 1);
            Comparable comparable = (Comparable)treeTableColumn.getValueFor(this, true);
            Comparable comparable2 = (Comparable)treeTableColumn.getValueFor((TreeTableNode)object, true);
            n = comparable.compareTo(comparable2);
        }
        if (this.model.getSortAscending()) {
            return -n;
        }
        return n;
    }

    public CallPathModel getModel() {
        return this.model;
    }
}

