/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.FunctionOrdering;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.PPThread;
import edu.uoregon.tau.paraprof.PPUserEventProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.UserEventValueType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class DataSorter
implements Comparator {
    private ParaProfTrial ppTrial = null;
    private int selectedMetricID;
    private ValueType valueType;
    private UserEventValueType userEventValueType = UserEventValueType.NUMSAMPLES;
    private boolean descendingOrder;
    private SortType sortType;
    private ValueType sortValueType;
    private int sortMetric;
    private boolean sortByVisible = true;
    private Function phase;
    private static SortType defaultSortType = SortType.MEAN_VALUE;
    private static ValueType defaultValueType = ValueType.EXCLUSIVE;
    private static boolean defaultSortOrder = true;

    public DataSorter(ParaProfTrial paraProfTrial) {
        this.ppTrial = paraProfTrial;
        this.selectedMetricID = paraProfTrial.getDefaultMetricID();
        this.sortType = defaultSortType;
        this.valueType = defaultValueType;
        this.sortValueType = defaultValueType;
        this.descendingOrder = defaultSortOrder;
    }

    public boolean isTimeMetric() {
        String string = this.ppTrial.getMetricName(this.getSelectedMetricID());
        return (string = string.toUpperCase()).indexOf("TIME") != -1;
    }

    public boolean isDerivedMetric() {
        return this.ppTrial.getMetric(this.getSelectedMetricID()).getDerivedMetric();
    }

    public List getUserEventProfiles(Thread thread) {
        UserEventProfile userEventProfile = null;
        List list = thread.getUserEventProfiles();
        ArrayList<PPUserEventProfile> arrayList = new ArrayList<PPUserEventProfile>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            userEventProfile = (UserEventProfile)iterator.next();
            if (userEventProfile == null) continue;
            PPUserEventProfile pPUserEventProfile = new PPUserEventProfile(this, thread, userEventProfile);
            arrayList.add(pPUserEventProfile);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private List createFunctionProfileList(Thread thread, boolean bl) {
        ArrayList<PPFunctionProfile> arrayList = null;
        List list = thread.getFunctionProfiles();
        arrayList = new ArrayList<PPFunctionProfile>();
        for (int i = 0; i < list.size(); ++i) {
            PPFunctionProfile pPFunctionProfile;
            FunctionProfile functionProfile = (FunctionProfile)list.get(i);
            if (functionProfile == null) continue;
            if (bl) {
                if (!functionProfile.getFunction().isPhaseMember(this.phase)) continue;
                pPFunctionProfile = new PPFunctionProfile(this, thread, functionProfile);
                arrayList.add(pPFunctionProfile);
                continue;
            }
            if (!this.ppTrial.displayFunction(functionProfile.getFunction()) || !functionProfile.getFunction().isPhaseMember(this.phase)) continue;
            pPFunctionProfile = new PPFunctionProfile(this, thread, functionProfile);
            arrayList.add(pPFunctionProfile);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List getCallPathFunctionProfiles(Thread thread) {
        return this.createFunctionProfileList(thread, true);
    }

    public List getFunctionProfiles(Thread thread) {
        return this.createFunctionProfileList(thread, false);
    }

    public List getBasicFunctionProfiles(Thread thread) {
        ArrayList<FunctionProfile> arrayList = null;
        List list = thread.getFunctionProfiles();
        arrayList = new ArrayList<FunctionProfile>();
        for (int i = 0; i < list.size(); ++i) {
            FunctionProfile functionProfile = (FunctionProfile)list.get(i);
            if (functionProfile == null) continue;
            arrayList.add(functionProfile);
        }
        Collections.sort(arrayList, this);
        return arrayList;
    }

    public List getAllFunctionProfiles() {
        PPFunctionProfile pPFunctionProfile;
        Object object;
        Iterator iterator;
        PPThread pPThread;
        Thread thread;
        long l = System.currentTimeMillis();
        ArrayList<PPThread> arrayList = new ArrayList<PPThread>();
        PPThread pPThread2 = null;
        if (this.ppTrial.getDataSource().getAllThreads().size() > 1) {
            thread = this.ppTrial.getDataSource().getStdDevData();
            pPThread = new PPThread(thread, this.ppTrial);
            iterator = thread.getFunctionProfiles().iterator();
            while (iterator.hasNext()) {
                object = (FunctionProfile)iterator.next();
                if (object == null || !this.ppTrial.displayFunction(object.getFunction()) || !object.getFunction().isPhaseMember(this.phase)) continue;
                pPFunctionProfile = new PPFunctionProfile(this, thread, (FunctionProfile)object);
                pPThread.addFunction(pPFunctionProfile);
            }
            Collections.sort(pPThread.getFunctionList());
            arrayList.add(pPThread);
            thread = this.ppTrial.getDataSource().getMeanData();
            pPThread = new PPThread(thread, this.ppTrial);
            iterator = thread.getFunctionProfiles().iterator();
            while (iterator.hasNext()) {
                object = (FunctionProfile)iterator.next();
                if (object == null || !this.ppTrial.displayFunction(object.getFunction()) || !object.getFunction().isPhaseMember(this.phase)) continue;
                pPFunctionProfile = new PPFunctionProfile(this, thread, (FunctionProfile)object);
                pPThread.addFunction(pPFunctionProfile);
            }
            Collections.sort(pPThread.getFunctionList());
            arrayList.add(pPThread);
            pPThread2 = pPThread;
        }
        iterator = this.ppTrial.getDataSource().getAllThreads().iterator();
        while (iterator.hasNext()) {
            thread = (Thread)iterator.next();
            pPThread = new PPThread(thread, this.ppTrial);
            object = pPThread2.getFunctionListIterator();
            while (object.hasNext()) {
                pPFunctionProfile = (PPFunctionProfile)object.next();
                FunctionProfile functionProfile = thread.getFunctionProfile(pPFunctionProfile.getFunction());
                if (functionProfile == null) continue;
                pPThread.addFunction(new PPFunctionProfile(this, thread, functionProfile));
            }
            if (pPThread.getFunctionList().size() <= 0) continue;
            arrayList.add(pPThread);
        }
        l = System.currentTimeMillis() - l;
        return arrayList;
    }

    private void addThread(List list, List list2, Thread thread) {
        ArrayList<FunctionProfile> arrayList = new ArrayList<FunctionProfile>();
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            FunctionProfile functionProfile = (FunctionProfile)list2.get(i);
            FunctionProfile functionProfile2 = thread.getFunctionProfile(functionProfile.getFunction());
            if (functionProfile2 == null) continue;
            arrayList.add(functionProfile2);
        }
        if (arrayList.size() > 0) {
            list.add(arrayList);
        }
    }

    public List getAllFunctionProfilesMinimal() {
        long l = System.currentTimeMillis();
        ArrayList arrayList = new ArrayList();
        ArrayList<FunctionProfile> arrayList2 = new ArrayList<FunctionProfile>();
        List list = this.ppTrial.getDataSource().getMeanData().getFunctionProfiles();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            FunctionProfile functionProfile = (FunctionProfile)list.get(i);
            if (functionProfile == null || !this.ppTrial.displayFunction(functionProfile.getFunction()) || !functionProfile.getFunction().isPhaseMember(this.phase)) continue;
            arrayList2.add(functionProfile);
        }
        Collections.sort(arrayList2, this);
        this.addThread(arrayList, arrayList2, this.ppTrial.getDataSource().getStdDevData());
        arrayList.add(arrayList2);
        Iterator iterator = this.ppTrial.getDataSource().getAllThreads().iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            this.addThread(arrayList, arrayList2, thread);
        }
        l = System.currentTimeMillis() - l;
        return arrayList;
    }

    public FunctionOrdering getOrdering() {
        long l = System.currentTimeMillis();
        ArrayList<FunctionProfile> arrayList = new ArrayList<FunctionProfile>();
        List list = this.ppTrial.getDataSource().getMeanData().getFunctionProfiles();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            FunctionProfile functionProfile = (FunctionProfile)list.get(i);
            if (functionProfile == null || !this.ppTrial.displayFunction(functionProfile.getFunction()) || !functionProfile.getFunction().isPhaseMember(this.phase)) continue;
            arrayList.add(functionProfile);
        }
        Collections.sort(arrayList, this);
        Function[] functionArray = new Function[arrayList.size()];
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            functionArray[n] = ((FunctionProfile)arrayList.get(n)).getFunction();
        }
        FunctionOrdering functionOrdering = new FunctionOrdering(this);
        functionOrdering.setFunctions(functionArray);
        l = System.currentTimeMillis() - l;
        return functionOrdering;
    }

    public List getThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        if (this.ppTrial.getDataSource().getAllThreads().size() > 1) {
            arrayList.add(this.ppTrial.getDataSource().getStdDevData());
            arrayList.add(this.ppTrial.getDataSource().getMeanData());
        }
        Iterator iterator = this.ppTrial.getDataSource().getAllThreads().iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            arrayList.add(thread);
        }
        return arrayList;
    }

    public List getFunctionData(Function function, boolean bl, boolean bl2) {
        Object object;
        Thread thread;
        FunctionProfile functionProfile;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.ppTrial.getDataSource().getAllThreads().size() > 1) {
            if (bl && (functionProfile = (thread = this.ppTrial.getDataSource().getMeanData()).getFunctionProfile(function)) != null) {
                object = new PPFunctionProfile(this, thread, functionProfile);
                arrayList.add(object);
            }
            if (bl2 && (functionProfile = (thread = this.ppTrial.getDataSource().getStdDevData()).getFunctionProfile(function)) != null) {
                object = new PPFunctionProfile(this, thread, functionProfile);
                arrayList.add(object);
            }
        }
        functionProfile = this.ppTrial.getDataSource().getAllThreads().iterator();
        while (functionProfile.hasNext()) {
            thread = (Thread)functionProfile.next();
            object = thread.getFunctionProfile(function);
            if (object == null) continue;
            PPFunctionProfile pPFunctionProfile = new PPFunctionProfile(this, thread, (FunctionProfile)object);
            arrayList.add(pPFunctionProfile);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List getFunctionAcrossPhases(Function function, Thread thread) {
        ArrayList<PPFunctionProfile> arrayList = new ArrayList<PPFunctionProfile>();
        String string = function.getName();
        if (function.isCallPathFunction()) {
            string = string.substring(string.indexOf("=>") + 2).trim();
        }
        Iterator iterator = thread.getFunctionProfileIterator();
        while (iterator.hasNext()) {
            FunctionProfile functionProfile = (FunctionProfile)iterator.next();
            if (functionProfile == null || !functionProfile.isCallPathFunction()) continue;
            String string2 = functionProfile.getName();
            if (string.compareTo(string2 = string2.substring(string2.indexOf("=>") + 2).trim()) != 0) continue;
            PPFunctionProfile pPFunctionProfile = new PPFunctionProfile(this, thread, functionProfile);
            arrayList.add(pPFunctionProfile);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List getUserEventData(UserEvent userEvent) {
        PPUserEventProfile pPUserEventProfile;
        ArrayList<PPUserEventProfile> arrayList = new ArrayList<PPUserEventProfile>();
        Thread thread = this.ppTrial.getDataSource().getMeanData();
        UserEventProfile userEventProfile = thread.getUserEventProfile(userEvent);
        if (userEventProfile != null) {
            pPUserEventProfile = new PPUserEventProfile(this, thread, userEventProfile);
            arrayList.add(pPUserEventProfile);
        }
        if ((userEventProfile = (thread = this.ppTrial.getDataSource().getStdDevData()).getUserEventProfile(userEvent)) != null) {
            pPUserEventProfile = new PPUserEventProfile(this, thread, userEventProfile);
            arrayList.add(pPUserEventProfile);
        }
        Iterator iterator = this.ppTrial.getDataSource().getAllThreads().iterator();
        while (iterator.hasNext()) {
            thread = (Thread)iterator.next();
            userEventProfile = thread.getUserEventProfile(userEvent);
            if (userEventProfile == null) continue;
            pPUserEventProfile = new PPUserEventProfile(this, thread, userEventProfile);
            arrayList.add(pPUserEventProfile);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public int compare(Object object, Object object2) {
        FunctionProfile functionProfile = (FunctionProfile)object;
        FunctionProfile functionProfile2 = (FunctionProfile)object2;
        if (this.descendingOrder) {
            return -this.performComparison(functionProfile, functionProfile2);
        }
        return this.performComparison(functionProfile, functionProfile2);
    }

    private int performComparison(FunctionProfile functionProfile, FunctionProfile functionProfile2) {
        ValueType valueType = this.getSortValueType();
        if (this.sortType == SortType.NAME) {
            return DataSorter.getDisplayName(functionProfile2).compareTo(DataSorter.getDisplayName(functionProfile));
        }
        if (this.sortType == SortType.NCT) {
            return DataSorter.compareNCT(functionProfile, functionProfile2);
        }
        if (this.sortType == SortType.MEAN_VALUE) {
            return DataSorter.compareToHelper(valueType.getValue(functionProfile.getFunction().getMeanProfile(), this.getSortMetric(), this.getSelectedSnapshot()), valueType.getValue(functionProfile2.getFunction().getMeanProfile(), this.getSortMetric(), this.getSelectedSnapshot()), functionProfile.getFunction().getMeanProfile(), functionProfile2.getFunction().getMeanProfile());
        }
        if (this.sortType == SortType.VALUE) {
            return DataSorter.compareToHelper(valueType.getValue(functionProfile, this.getSortMetric(), this.getSelectedSnapshot()), valueType.getValue(functionProfile2, this.getSortMetric(), this.getSelectedSnapshot()));
        }
        throw new ParaProfException("Unexpected sort type: " + this.sortType);
    }

    public static String getDisplayName(FunctionProfile functionProfile) {
        if (ParaProf.preferences.getReversedCallPaths()) {
            return functionProfile.getFunction().getReversedName();
        }
        return functionProfile.getFunction().getName();
    }

    private static int compareNCT(FunctionProfile functionProfile, FunctionProfile functionProfile2) {
        Thread thread = functionProfile.getThread();
        Thread thread2 = functionProfile2.getThread();
        if (thread.getNodeID() != thread2.getNodeID()) {
            return thread.getNodeID() - thread2.getNodeID();
        }
        if (thread.getContextID() != thread2.getContextID()) {
            return thread.getContextID() - thread2.getContextID();
        }
        return thread.getThreadID() - thread2.getThreadID();
    }

    private static int compareToHelper(double d, double d2) {
        double d3 = d - d2;
        if (d3 < 0.0) {
            return -1;
        }
        if (d3 == 0.0) {
            return 0;
        }
        return 1;
    }

    private static int compareToHelper(double d, double d2, FunctionProfile functionProfile, FunctionProfile functionProfile2) {
        double d3 = d - d2;
        if (d3 < 0.0) {
            return -1;
        }
        if (d3 == 0.0) {
            return functionProfile.getFunction().compareTo((Object)functionProfile2.getFunction());
        }
        return 1;
    }

    public Function getPhase() {
        return this.phase;
    }

    public ParaProfTrial getPpTrial() {
        return this.ppTrial;
    }

    public void setPpTrial(ParaProfTrial paraProfTrial) {
        this.ppTrial = paraProfTrial;
    }

    public int getSortMetric() {
        if (this.getSortByVisible()) {
            return this.selectedMetricID;
        }
        return this.sortMetric;
    }

    public void setSortMetric(int n) {
        this.sortMetric = n;
    }

    public ValueType getSortValueType() {
        if (this.getSortByVisible()) {
            return this.valueType;
        }
        return this.sortValueType;
    }

    public void setSortValueType(ValueType valueType) {
        this.sortValueType = valueType;
    }

    public boolean getSortByVisible() {
        return this.sortByVisible;
    }

    public void setSortByVisible(boolean bl) {
        this.sortByVisible = bl;
    }

    public void setSelectedMetricID(int n) {
        this.selectedMetricID = n;
    }

    public double getValue(FunctionProfile functionProfile) {
        return this.valueType.getValue(functionProfile, this.selectedMetricID, this.getSelectedSnapshot());
    }

    public double getValue(FunctionProfile functionProfile, int n) {
        return this.valueType.getValue(functionProfile, this.selectedMetricID, n);
    }

    public int getSelectedMetricID() {
        return this.selectedMetricID;
    }

    public void setDescendingOrder(boolean bl) {
        this.descendingOrder = bl;
    }

    public boolean getDescendingOrder() {
        return this.descendingOrder;
    }

    public void setSortType(SortType sortType) {
        this.sortType = sortType;
    }

    public SortType getSortType() {
        return this.sortType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public void setPhase(Function function) {
        this.phase = function;
    }

    public UserEventValueType getUserEventValueType() {
        return this.userEventValueType;
    }

    public void setUserEventValueType(UserEventValueType userEventValueType) {
        this.userEventValueType = userEventValueType;
    }

    public static void setDefaultSortType(SortType sortType) {
        defaultSortType = sortType;
    }

    public static void setDefaultValueType(ValueType valueType) {
        defaultValueType = valueType;
    }

    public static void setDefaultSortOrder(boolean bl) {
        defaultSortOrder = bl;
    }

    public int getSelectedSnapshot() {
        return this.ppTrial.getSelectedSnapshot();
    }
}

