/*
 * Decompiled with CFR 0.152.
 */
package clustering;

import clustering.ClusterException;
import clustering.DataNormalizer;
import clustering.KMeansClusterInterface;
import clustering.PrincipalComponentsAnalysisInterface;
import clustering.RawDataInterface;
import common.EngineType;
import common.RMICubeData;
import java.util.List;

public abstract class AnalysisFactory {
    private static AnalysisFactory theFactory = null;

    protected AnalysisFactory() {
    }

    public static AnalysisFactory buildFactory(EngineType engineType) throws ClusterException {
        try {
            if (engineType == EngineType.RPROJECT) {
                return (AnalysisFactory)Class.forName("clustering.r.RAnalysisFactory").newInstance();
            }
            if (engineType == EngineType.WEKA) {
                return (AnalysisFactory)Class.forName("clustering.weka.WekaAnalysisFactory").newInstance();
            }
            if (engineType == EngineType.OCTAVE) {
                throw new ClusterException("Unsupported factory type");
            }
            throw new ClusterException("Unknown factory type");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClusterException("Unknown factory type", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ClusterException("Unknown factory type", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new ClusterException("Unknown factory type", instantiationException);
        }
    }

    public abstract RawDataInterface createRawData(String var1, List var2, int var3, int var4);

    public abstract KMeansClusterInterface createKMeansEngine();

    public abstract PrincipalComponentsAnalysisInterface createPCAEngine(RMICubeData var1);

    public abstract DataNormalizer createDataNormalizer(RawDataInterface var1);

    public abstract void closeFactory();
}

