/*
 * Decompiled with CFR 0.152.
 */
package server;

import common.ChartDataType;
import common.PerfExplorerOutput;
import common.RMIGeneralChartData;
import common.RMIPerfExplorerModel;
import common.TransformationType;
import edu.uoregon.tau.common.Gzip;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.IntervalEvent;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.database.DB;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import server.PerfExplorerServer;
import server.TauNamespaceContext;

public class GeneralChartData
extends RMIGeneralChartData {
    private RMIPerfExplorerModel model;
    private String metricName = null;
    private String groupName = null;
    private String eventName = null;
    private String groupByColumn = null;
    private List columnValues = null;
    private StringBuffer buf = null;

    public GeneralChartData(RMIPerfExplorerModel rMIPerfExplorerModel, ChartDataType chartDataType) {
        super(chartDataType);
        this.model = rMIPerfExplorerModel;
        this.metricName = rMIPerfExplorerModel.getMetricName();
        this.groupName = rMIPerfExplorerModel.getGroupName();
        this.eventName = rMIPerfExplorerModel.getEventName();
    }

    public static GeneralChartData getChartData(RMIPerfExplorerModel rMIPerfExplorerModel, ChartDataType chartDataType) {
        GeneralChartData generalChartData = new GeneralChartData(rMIPerfExplorerModel, chartDataType);
        generalChartData.doQuery();
        return generalChartData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doQuery() {
        block93: {
            List list;
            List list2;
            Object object;
            Object object2;
            Object object3;
            String string;
            Object object4;
            int n;
            int n2;
            Object object5 = null;
            DB dB = null;
            dB = PerfExplorerServer.getServer().getDB();
            Object object6 = this.model.getCurrentSelection();
            this.buf = GeneralChartData.buildCreateTableStatement("trial", "temp_trial", dB, true);
            this.buf.append("(select trial.* from trial ");
            this.buf.append("inner join experiment ");
            this.buf.append("on trial.experiment = experiment.id ");
            this.buf.append("inner join application ");
            this.buf.append("on experiment.application = application.id ");
            this.buf.append("where ");
            List list3 = this.model.getMultiSelection();
            if (list3 == null) {
                Object object7 = this.model.getCurrentSelection();
                if (object7 instanceof Application) {
                    this.buf.append("application.id = " + this.model.getApplication().getID());
                } else if (object7 instanceof Experiment) {
                    this.buf.append("experiment.id = " + this.model.getExperiment().getID());
                } else if (object7 instanceof Trial) {
                    this.buf.append("trial.id = " + this.model.getTrial().getID());
                }
            } else {
                int n3;
                boolean bl = false;
                for (n3 = 0; n3 < list3.size(); ++n3) {
                    if (!(list3.get(n3) instanceof Application)) continue;
                    Application application = (Application)list3.get(n3);
                    if (!bl) {
                        this.buf.append("application.id in (");
                        bl = true;
                    } else {
                        this.buf.append(",");
                    }
                    this.buf.append(application.getID());
                }
                if (bl) {
                    this.buf.append(") ");
                }
                n3 = 0;
                for (n2 = 0; n2 < list3.size(); ++n2) {
                    if (!(list3.get(n2) instanceof Experiment)) continue;
                    Experiment experiment = (Experiment)list3.get(n2);
                    if (n3 == 0) {
                        if (bl) {
                            this.buf.append(" and ");
                        }
                        this.buf.append("experiment.id in (");
                        n3 = 1;
                    } else {
                        this.buf.append(",");
                    }
                    this.buf.append(experiment.getID());
                }
                if (n3 != 0) {
                    this.buf.append(") ");
                }
                n2 = 0;
                for (n = 0; n < list3.size(); ++n) {
                    if (!(list3.get(n) instanceof Trial)) continue;
                    Trial trial = (Trial)list3.get(n);
                    if (n2 == 0) {
                        if (bl || n3 != 0) {
                            this.buf.append(" and ");
                        }
                        this.buf.append("trial.id in (");
                        n2 = 1;
                    } else {
                        this.buf.append(",");
                    }
                    this.buf.append(trial.getID());
                }
                if (n2 != 0) {
                    this.buf.append(") ");
                }
            }
            this.buf.append(") ");
            object5 = dB.prepareStatement(this.buf.toString());
            object5.execute();
            object5.close();
            boolean bl = false;
            if (this.model.getChartMetadataFieldName() != null || this.model.getChartMetadataFieldValue() != null || this.model.getChartSeriesName().toUpperCase().indexOf("XML") > 0 || this.model.getChartXAxisName().toUpperCase().indexOf("XML") > 0) {
                bl = true;
                Trial.getMetaData((DB)dB, (boolean)true);
                String[] stringArray = dB.getDatabase().getTrialFieldNames();
                n2 = 0;
                n = 0;
                for (int i = 0; i < Array.getLength(stringArray); ++i) {
                    if (stringArray[i].equalsIgnoreCase("XML_METADATA")) {
                        n2 = 1;
                        continue;
                    }
                    if (!stringArray[i].equalsIgnoreCase("XML_METADATA_GZ")) continue;
                    n = 1;
                }
                if (n2 != 0) {
                    this.buf = GeneralChartData.buildCreateTableStatement("xml_metadata", "temp_xml_metadata", dB, false);
                    if (dB.getDBType().compareTo("derby") == 0) {
                        this.buf.append(" (trial int, metadata_name varchar(4000), metadata_value varchar(4000))");
                    } else {
                        this.buf.append(" (trial int, metadata_name text, metadata_value text)");
                    }
                    object5 = dB.prepareStatement(this.buf.toString());
                    object5.execute();
                    object5.close();
                    object5 = n != 0 ? dB.prepareStatement("select id, XML_METADATA, XML_METADATA_GZ from temp_trial ") : dB.prepareStatement("select id, XML_METADATA from temp_trial ");
                    ResultSet resultSet = object5.executeQuery();
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    object4 = documentBuilderFactory.newDocumentBuilder();
                    dB.setAutoCommit(false);
                    while (resultSet.next()) {
                        Object object8;
                        string = resultSet.getString(2);
                        if (n != 0 && (string == null || string.length() == 0)) {
                            object3 = resultSet.getBinaryStream(3);
                            string = Gzip.decompress((InputStream)object3);
                        }
                        if (string == null || string.length() == 0) continue;
                        object3 = new StringReader(string);
                        object2 = new InputSource((Reader)object3);
                        object = ((DocumentBuilder)object4).parse((InputSource)object2);
                        NodeList nodeList = null;
                        NodeList nodeList2 = null;
                        try {
                            nodeList = XPathAPI.selectNodeList((Node)object, (String)"/metadata/CommonProfileAttributes/attribute/name");
                            nodeList2 = XPathAPI.selectNodeList((Node)object, (String)"/metadata/CommonProfileAttributes/attribute/value");
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            object8 = XPathFactory.newInstance().newXPath();
                            object8.setNamespaceContext(new TauNamespaceContext());
                            nodeList = (NodeList)object8.evaluate("/metadata/CommonProfileAttributes/attribute/name", object, XPathConstants.NODESET);
                            nodeList2 = (NodeList)object8.evaluate("/metadata/CommonProfileAttributes/attribute/value", object, XPathConstants.NODESET);
                        }
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            object8 = nodeList.item(i).getFirstChild();
                            Node node = nodeList2.item(i).getFirstChild();
                            if (this.model.getChartMetadataFieldName() != null && !this.model.getChartMetadataFieldName().equals(object8.getNodeValue()) || this.model.getChartMetadataFieldValue() != null && !this.model.getChartMetadataFieldValue().equals(node.getNodeValue())) continue;
                            this.buf = new StringBuffer();
                            this.buf.append("insert into temp_xml_metadata VALUES (?,?,?)");
                            PreparedStatement preparedStatement = dB.prepareStatement(this.buf.toString());
                            preparedStatement.setInt(1, resultSet.getInt(1));
                            preparedStatement.setString(2, object8.getNodeValue());
                            if (node == null) {
                                preparedStatement.setString(3, "");
                            } else {
                                preparedStatement.setString(3, node.getNodeValue());
                            }
                            preparedStatement.executeUpdate();
                            preparedStatement.close();
                        }
                    }
                    dB.commit();
                    resultSet.close();
                    object5.close();
                    dB.setAutoCommit(true);
                }
            }
            this.buf = GeneralChartData.buildCreateTableStatement("metric", "temp_metric", dB, true);
            this.buf.append("(select metric.* from metric ");
            this.buf.append("inner join temp_trial ");
            this.buf.append("on metric.trial = temp_trial.id ");
            List list4 = this.model.getMetricNames();
            if (list4 != null) {
                this.buf.append("where upper(metric.name) like ? ");
                for (n2 = 1; n2 < list4.size(); ++n2) {
                    this.buf.append("or upper(metric.name) like ? ");
                }
            }
            this.buf.append(") ");
            object5 = dB.prepareStatement(this.buf.toString());
            if (list4 != null) {
                for (n2 = 1; n2 <= list4.size(); ++n2) {
                    String string2 = (String)list4.get(n2 - 1);
                    object5.setString(n2, string2.toUpperCase());
                }
            }
            object5.execute();
            object5.close();
            if (this.model.getMainEventOnly()) {
                this.buf = new StringBuffer();
                this.buf.append("select ie.name from interval_event ie ");
                this.buf.append("inner join interval_mean_summary ims ");
                this.buf.append("on ie.id = ims.interval_event, ");
                this.buf.append("(select temp_trial.id as trialid, ");
                this.buf.append("temp_metric.id as metricid, ");
                this.buf.append("max(interval_mean_summary.inclusive) as maxinclusive ");
                this.buf.append("from interval_event inner join temp_trial ");
                this.buf.append("on interval_event.trial = temp_trial.id ");
                this.buf.append("inner join interval_mean_summary on ");
                this.buf.append("interval_mean_summary.interval_event = interval_event.id ");
                this.buf.append("inner join temp_metric ");
                this.buf.append("on interval_mean_summary.metric = temp_metric.id ");
                if (dB.getDBType().compareTo("derby") == 0) {
                    this.buf.append("group by temp_trial.id, temp_metric.id) mr ");
                } else {
                    this.buf.append("group by 1, 2) mr ");
                }
                this.buf.append("where ie.trial = trialid ");
                this.buf.append("and ims.metric = metricid ");
                this.buf.append("and ims.inclusive = maxinclusive");
                object5 = dB.prepareStatement(this.buf.toString());
                ResultSet resultSet = object5.executeQuery();
                while (resultSet.next()) {
                    this.model.addEventName(resultSet.getString(1));
                }
                resultSet.close();
                object5.close();
            }
            this.buf = GeneralChartData.buildCreateTableStatement("event", "temp_event", dB, true);
            this.buf.append("(select interval_event.* from interval_event ");
            this.buf.append("inner join temp_trial ");
            this.buf.append("on interval_event.trial = temp_trial.id ");
            this.buf.append("inner join interval_mean_summary ");
            this.buf.append("on interval_mean_summary.interval_event = interval_event.id ");
            this.buf.append("inner join temp_metric ");
            this.buf.append("on interval_mean_summary.metric = temp_metric.id ");
            boolean bl2 = false;
            if (this.model.getEventNoCallpath()) {
                if (bl2) {
                    this.buf.append("and ");
                } else {
                    this.buf.append("where ");
                    bl2 = true;
                }
                this.buf.append("(interval_event.group_name is null ");
                this.buf.append("or (interval_event.group_name not like '%TAU_CALLPATH%' ");
                this.buf.append("and interval_event.group_name not like '%TAU_PHASE%')) ");
            }
            if (this.model.getDimensionReduction() == TransformationType.OVER_X_PERCENT) {
                if (bl2) {
                    this.buf.append("and ");
                } else {
                    this.buf.append("where ");
                    bl2 = true;
                }
                this.buf.append("interval_mean_summary.exclusive_percentage > ");
                this.buf.append(this.model.getXPercent());
                this.buf.append(" ");
            }
            if (this.model.getEventExclusive100()) {
                if (bl2) {
                    this.buf.append("and ");
                } else {
                    this.buf.append("where ");
                    bl2 = true;
                }
                this.buf.append("interval_mean_summary.exclusive_percentage = 100 ");
            }
            if ((list2 = this.model.getGroupNames()) != null) {
                boolean bl3 = false;
                for (int i = 0; i < list2.size(); ++i) {
                    if (bl2) {
                        if (bl3) {
                            this.buf.append("or ");
                        } else {
                            this.buf.append("and ");
                            bl3 = true;
                        }
                    } else {
                        this.buf.append("where ");
                        bl2 = true;
                    }
                    if (dB.getDBType().compareTo("db2") == 0) {
                        this.buf.append("interval_event.group_name like ? ");
                        continue;
                    }
                    this.buf.append("interval_event.group_name = ? ");
                }
            }
            if ((list = this.model.getEventNames()) != null) {
                boolean bl4 = false;
                for (int i = 0; i < list.size(); ++i) {
                    if (bl2) {
                        if (bl4) {
                            this.buf.append("or ");
                        } else {
                            this.buf.append("and ");
                            bl4 = true;
                        }
                    } else {
                        this.buf.append("where ");
                        bl2 = true;
                    }
                    if (dB.getDBType().compareTo("db2") == 0) {
                        this.buf.append("interval_event.name like ? ");
                        continue;
                    }
                    this.buf.append("interval_event.name = ? ");
                }
            }
            this.buf.append(")");
            object5 = dB.prepareStatement(this.buf.toString());
            int n4 = 1;
            if (list2 != null) {
                for (int i = 0; i < list2.size(); ++i) {
                    string = (String)list2.get(i);
                    object5.setString(n4, string);
                    ++n4;
                }
            }
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    string = (String)list.get(i);
                    object5.setString(n4, string);
                    ++n4;
                }
            }
            object5.execute();
            object5.close();
            object4 = this.model.getChartSeriesName();
            string = this.model.getChartXAxisName();
            object3 = this.model.getChartYAxisName();
            object2 = "interval_mean_summary";
            if (((String)object3).indexOf("interval_mean_summary") >= 0) {
                object2 = "interval_mean_summary";
            } else if (((String)object3).indexOf("interval_total_summary") >= 0) {
                object2 = "interval_total_summary";
            }
            this.buf = new StringBuffer();
            this.buf.append("select ");
            if (dB.getDBType().compareTo("derby") == 0) {
                this.buf.append(this.fixClause((String)object4, dB) + ", ");
                this.buf.append(this.fixClause(string, dB) + ", ");
                this.buf.append(this.fixClause((String)object3, dB) + " ");
            } else {
                this.buf.append(this.fixClause((String)object4, dB) + " as series_name, ");
                this.buf.append(this.fixClause(string, dB) + " as xaxis_value, ");
                this.buf.append(this.fixClause((String)object3, dB) + " as yaxis_value ");
            }
            this.buf.append("from " + (String)object2 + " ");
            this.buf.append("inner join temp_metric ");
            this.buf.append("on " + (String)object2 + ".metric = temp_metric.id ");
            this.buf.append("inner join temp_event ");
            this.buf.append("on " + (String)object2 + ".interval_event = temp_event.id ");
            this.buf.append("inner join temp_trial ");
            this.buf.append("on temp_event.trial = temp_trial.id ");
            if (bl) {
                this.buf.append("inner join temp_xml_metadata ");
                this.buf.append("on temp_event.trial = temp_xml_metadata.trial ");
            }
            this.buf.append("inner join experiment ");
            this.buf.append("on temp_trial.experiment = experiment.id ");
            this.buf.append("inner join application ");
            this.buf.append("on experiment.application = application.id ");
            if (dB.getDBType().compareTo("derby") == 0) {
                this.buf.append("group by " + this.fixClause((String)object4, dB) + ", " + this.fixClause(string, dB));
                if (((String)object4).startsWith("temp_trial.node_count") || string.startsWith("temp_trial.node_count")) {
                    this.buf.append(" order by 1, 2, 3, 4 ");
                } else {
                    this.buf.append(" order by 1, 2 ");
                }
            } else {
                this.buf.append("group by series_name, xaxis_value ");
                this.buf.append("order by 1, 2 ");
            }
            object5 = dB.prepareStatement(this.buf.toString());
            object = object5.executeQuery();
            while (object.next()) {
                if (dB.getDBType().compareTo("derby") == 0) {
                    if (((String)object4).startsWith("temp_trial.node_count")) {
                        this.addRow(Integer.toString(object.getInt(1) * object.getInt(2) * object.getInt(3)), object.getString(4), object.getDouble(5));
                        continue;
                    }
                    if (string.startsWith("temp_trial.node_count")) {
                        this.addRow(object.getString(1), Integer.toString(object.getInt(2) * object.getInt(3) * object.getInt(4)), object.getDouble(5));
                        continue;
                    }
                    this.addRow(object.getString(1), object.getString(2), object.getDouble(3));
                    continue;
                }
                this.addRow(object.getString(1), object.getString(2), object.getDouble(3));
            }
            object.close();
            object5.close();
            Object var23_44 = null;
            try {
                dB.setAutoCommit(true);
                GeneralChartData.dropTable(dB, "temp_event");
                GeneralChartData.dropTable(dB, "temp_metric");
                GeneralChartData.dropTable(dB, "temp_xml_metadata");
                GeneralChartData.dropTable(dB, "temp_trial");
            }
            catch (Exception exception) {}
            break block93;
            {
                catch (Exception exception) {
                    if (object5 != null) {
                        PerfExplorerOutput.println(object5.toString());
                    } else {
                        PerfExplorerOutput.println(this.buf.toString());
                    }
                    System.err.println(exception.getMessage());
                    exception.printStackTrace();
                    Object var23_45 = null;
                    try {
                        dB.setAutoCommit(true);
                        GeneralChartData.dropTable(dB, "temp_event");
                        GeneralChartData.dropTable(dB, "temp_metric");
                        GeneralChartData.dropTable(dB, "temp_xml_metadata");
                        GeneralChartData.dropTable(dB, "temp_trial");
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var23_46 = null;
                try {
                    dB.setAutoCommit(true);
                    GeneralChartData.dropTable(dB, "temp_event");
                    GeneralChartData.dropTable(dB, "temp_metric");
                    GeneralChartData.dropTable(dB, "temp_xml_metadata");
                    GeneralChartData.dropTable(dB, "temp_trial");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static StringBuffer buildCreateTableStatement(String string, String string2, DB dB, boolean bl) {
        GeneralChartData.dropTable(dB, string2);
        StringBuffer stringBuffer = new StringBuffer();
        if (dB.getDBType().equalsIgnoreCase("oracle")) {
            stringBuffer.append("create global temporary table ");
        } else if (dB.getDBType().equalsIgnoreCase("derby") || dB.getDBType().equalsIgnoreCase("db2")) {
            stringBuffer.append("create table ");
        } else {
            stringBuffer.append("create temporary table ");
        }
        stringBuffer.append(string2 + " ");
        if (bl) {
            if (dB.getDBType().equalsIgnoreCase("derby")) {
                String[] stringArray = null;
                String[] stringArray2 = null;
                if (string.equalsIgnoreCase("trial")) {
                    Trial.getMetaData((DB)dB, (boolean)true);
                    stringArray = dB.getDatabase().getTrialFieldNames();
                    stringArray2 = dB.getDatabase().getTrialFieldTypeNames();
                    Trial.getMetaData((DB)dB, (boolean)false);
                } else if (string.equalsIgnoreCase("metric")) {
                    Metric.getMetaData((DB)dB);
                    stringArray = dB.getDatabase().getMetricFieldNames();
                    stringArray2 = dB.getDatabase().getMetricFieldTypeNames();
                } else if (string.equalsIgnoreCase("event")) {
                    IntervalEvent.getMetaData((DB)dB);
                    stringArray = dB.getDatabase().getIntervalEventFieldNames();
                    stringArray2 = dB.getDatabase().getIntervalEventFieldTypeNames();
                }
                stringBuffer.append(" (");
                for (int i = 0; i < Array.getLength(stringArray); ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(stringArray[i] + " " + stringArray2[i]);
                }
                stringBuffer.append(") ");
                try {
                    PreparedStatement preparedStatement = dB.prepareStatement(stringBuffer.toString());
                    preparedStatement.execute();
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    System.err.println(stringBuffer.toString());
                    System.err.println(sQLException.getMessage());
                    sQLException.printStackTrace(System.err);
                }
                stringBuffer = new StringBuffer();
                stringBuffer.append(" insert into " + string2 + " ");
            } else {
                stringBuffer.append("as ");
            }
        }
        return stringBuffer;
    }

    private String fixClause(String string, DB dB) {
        String string2 = string.replaceAll("trial.", "temp_trial.").replaceAll("metric.", "temp_metric.").replaceAll("interval_event.", "temp_event.");
        if (dB.getDBType().equalsIgnoreCase("oracle")) {
            string2 = string2.replaceAll("exclusive", "exec");
        }
        if (dB.getDBType().equalsIgnoreCase("derby")) {
            string2 = string2.replaceAll("call", "num_calls");
            string2 = string2.replaceAll(" \\* ", ", ");
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static List getXMLFields(RMIPerfExplorerModel rMIPerfExplorerModel) {
        ArrayList arrayList;
        HashSet<String> hashSet;
        block46: {
            DB dB;
            Statement statement;
            block45: {
                Object object;
                Object object2;
                boolean bl;
                StringBuffer stringBuffer;
                block43: {
                    ArrayList arrayList2;
                    block44: {
                        stringBuffer = null;
                        statement = null;
                        hashSet = new HashSet<String>();
                        dB = null;
                        dB = PerfExplorerServer.getServer().getDB();
                        arrayList = rMIPerfExplorerModel.getCurrentSelection();
                        Trial.getMetaData((DB)dB, (boolean)true);
                        String[] stringArray = dB.getDatabase().getTrialFieldNames();
                        boolean bl2 = false;
                        bl = false;
                        for (int i = 0; i < Array.getLength(stringArray); ++i) {
                            if (stringArray[i].equalsIgnoreCase("XML_METADATA")) {
                                bl2 = true;
                                continue;
                            }
                            if (!stringArray[i].equalsIgnoreCase("XML_METADATA_GZ")) continue;
                            bl = true;
                        }
                        if (bl2) break block43;
                        arrayList2 = new ArrayList();
                        Object var23_13 = null;
                        if (statement == null) break block44;
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    GeneralChartData.dropTable(dB, "temp_trial");
                    return arrayList2;
                }
                stringBuffer = GeneralChartData.buildCreateTableStatement("trial", "temp_trial", dB, true);
                stringBuffer.append("(select trial.* from trial ");
                stringBuffer.append("inner join experiment ");
                stringBuffer.append("on trial.experiment = experiment.id ");
                stringBuffer.append("inner join application ");
                stringBuffer.append("on experiment.application = application.id ");
                stringBuffer.append("where ");
                List list = rMIPerfExplorerModel.getMultiSelection();
                if (list == null) {
                    object2 = rMIPerfExplorerModel.getCurrentSelection();
                    if (object2 instanceof Application) {
                        stringBuffer.append("application.id = " + rMIPerfExplorerModel.getApplication().getID());
                    } else if (object2 instanceof Experiment) {
                        stringBuffer.append("experiment.id = " + rMIPerfExplorerModel.getExperiment().getID());
                    } else if (object2 instanceof Trial) {
                        stringBuffer.append("trial.id = " + rMIPerfExplorerModel.getTrial().getID());
                    }
                } else {
                    int n;
                    int n2;
                    boolean bl3 = false;
                    for (n2 = 0; n2 < list.size(); ++n2) {
                        if (!(list.get(n2) instanceof Application)) continue;
                        Application application = (Application)list.get(n2);
                        if (!bl3) {
                            stringBuffer.append("application.id in (");
                            bl3 = true;
                        } else {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(application.getID());
                    }
                    if (bl3) {
                        stringBuffer.append(") ");
                    }
                    n2 = 0;
                    for (n = 0; n < list.size(); ++n) {
                        if (!(list.get(n) instanceof Experiment)) continue;
                        Experiment experiment = (Experiment)list.get(n);
                        if (n2 == 0) {
                            if (bl3) {
                                stringBuffer.append(" and ");
                            }
                            stringBuffer.append("experiment.id in (");
                            n2 = 1;
                        } else {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(experiment.getID());
                    }
                    if (n2 != 0) {
                        stringBuffer.append(") ");
                    }
                    n = 0;
                    for (int i = 0; i < list.size(); ++i) {
                        if (!(list.get(i) instanceof Trial)) continue;
                        object = (Trial)list.get(i);
                        if (n == 0) {
                            if (bl3 || n2 != 0) {
                                stringBuffer.append(" and ");
                            }
                            stringBuffer.append("trial.id in (");
                            n = 1;
                        } else {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(object.getID());
                    }
                    if (n != 0) {
                        stringBuffer.append(") ");
                    }
                }
                stringBuffer.append(") ");
                statement = dB.prepareStatement(stringBuffer.toString());
                statement.execute();
                statement.close();
                statement = null;
                statement = bl ? dB.prepareStatement("select id, XML_METADATA, XML_METADATA_GZ from temp_trial ") : dB.prepareStatement("select id, XML_METADATA from temp_trial ");
                object2 = statement.executeQuery();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                while (object2.next()) {
                    Object object3;
                    String string = object2.getString(2);
                    if (bl && (string == null || string.length() == 0)) {
                        object = object2.getBinaryStream(3);
                        string = Gzip.decompress((InputStream)object);
                    }
                    object = new StringReader(string);
                    InputSource inputSource = new InputSource((Reader)object);
                    Document document = documentBuilder.parse(inputSource);
                    NodeList nodeList = null;
                    try {
                        int n;
                        nodeList = XPathAPI.selectNodeList((Node)document, (String)"/metadata/CommonProfileAttributes/attribute/name");
                        for (n = 0; n < nodeList.getLength(); ++n) {
                            object3 = nodeList.item(n).getFirstChild();
                            hashSet.add(object3.getNodeValue());
                        }
                        nodeList = XPathAPI.selectNodeList((Node)document, (String)"/metadata/ProfileAttributes/attribute/name");
                        for (n = 0; n < nodeList.getLength(); ++n) {
                            object3 = nodeList.item(n).getFirstChild();
                            hashSet.add(object3.getNodeValue());
                        }
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        Node node;
                        int n;
                        object3 = XPathFactory.newInstance().newXPath();
                        object3.setNamespaceContext(new TauNamespaceContext());
                        nodeList = (NodeList)object3.evaluate("/metadata/CommonProfileAttributes/attribute/name", document, XPathConstants.NODESET);
                        for (n = 0; n < nodeList.getLength(); ++n) {
                            node = nodeList.item(n).getFirstChild();
                            hashSet.add(node.getNodeValue());
                        }
                        nodeList = (NodeList)object3.evaluate("/metadata/CommonProfileAttributes/attribute/name", document, XPathConstants.NODESET);
                        for (n = 0; n < nodeList.getLength(); ++n) {
                            node = nodeList.item(n).getFirstChild();
                            hashSet.add(node.getNodeValue());
                        }
                    }
                }
                object2.close();
                statement.close();
                statement = null;
                Object var23_14 = null;
                if (statement == null) break block45;
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            GeneralChartData.dropTable(dB, "temp_trial");
            {
                break block46;
                catch (Exception exception) {
                    Object var23_15 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    GeneralChartData.dropTable(dB, "temp_trial");
                }
            }
            catch (Throwable throwable) {
                Object var23_16 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                GeneralChartData.dropTable(dB, "temp_trial");
                throw throwable;
            }
        }
        arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dropTable(DB dB, String string) {
        Statement statement = null;
        try {
            if (dB.getDBType().compareTo("oracle") == 0) {
                statement = dB.prepareStatement("truncate table " + string);
                statement.execute();
                statement.close();
            }
            statement = dB.prepareStatement("drop table " + string);
            statement.execute();
            statement.close();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }
}

