/*
 * Decompiled with CFR 0.152.
 */
package server;

import clustering.KMeansClusterInterface;
import common.RMIPerfExplorerModel;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import server.PEChartColor;

public class VirtualTopology
extends JPanel {
    RMIPerfExplorerModel modelData = null;
    KMeansClusterInterface clusterer = null;
    int[] pixels = null;
    BufferedImage img = null;
    StringBuffer description = null;
    private static final int idealSize = 128;
    private static final Color[] colors = PEChartColor.createDefaultColorArray();

    public VirtualTopology(RMIPerfExplorerModel rMIPerfExplorerModel, KMeansClusterInterface kMeansClusterInterface) {
        int n;
        this.modelData = rMIPerfExplorerModel;
        this.clusterer = kMeansClusterInterface;
        this.description = new StringBuffer();
        this.description.append(rMIPerfExplorerModel.toShortString() + ".");
        this.description.append(kMeansClusterInterface.getK() + "_clusters");
        this.pixels = new int[kMeansClusterInterface.getNumInstances()];
        int n2 = 1;
        for (n = kMeansClusterInterface.getNumInstances(); n2 < n; n /= 2, n2 *= 2) {
        }
        if (128 <= n2 || 128 <= n) {
            this.img = new BufferedImage(n2, n, 1);
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.img.setRGB(i, j, colors[kMeansClusterInterface.clusterInstance(n3)].getRGB());
                    ++n3;
                }
            }
        } else {
            this.img = new BufferedImage(128, 128, 1);
            int n4 = 128 / n2;
            int n5 = 128 / n;
            int n6 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    for (int k = i * n4; k < (i + 1) * n4; ++k) {
                        for (int i2 = j * n5; i2 < (j + 1) * n5; ++i2) {
                            this.img.setRGB(k, i2, colors[kMeansClusterInterface.clusterInstance(n6)].getRGB());
                        }
                    }
                    ++n6;
                }
            }
        }
    }

    public String getImage() {
        String string = "/tmp/clusterImage." + this.description + ".png";
        File file = new File(string);
        try {
            ImageIO.write((RenderedImage)this.img, "PNG", file);
        }
        catch (IOException iOException) {
            String string2 = "ERROR: Couldn't write the virtual topology image!";
            System.err.println(string2);
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        return string;
    }

    public String getThumbnail() {
        String string = "/tmp/clusterImage.thumb." + this.description + ".png";
        return string;
    }
}

