/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class DataSourceExport {
    private static int findGroupID(Group[] groupArray, Group group) {
        for (int i = 0; i < groupArray.length; ++i) {
            if (groupArray[i] != group) continue;
            return i;
        }
        throw new RuntimeException("Couldn't find group: " + group.getName());
    }

    public static void writeDelimited(DataSource dataSource, File file) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        DataSourceExport.writeDelimited(dataSource, fileOutputStream);
    }

    public static void writeDelimited(DataSource dataSource, OutputStream outputStream) throws IOException {
        Object object;
        Iterator iterator;
        Object object2;
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        int n = dataSource.getNumberOfMetrics();
        bufferedWriter.write("Node\tContext\tThread\tFunction\tNumCalls\tNumSubr");
        for (int i = 0; i < n; ++i) {
            object2 = dataSource.getMetricName(i);
            bufferedWriter.write("\tInclusive " + (String)object2);
            bufferedWriter.write("\tExclusive " + (String)object2);
        }
        bufferedWriter.write("\tGroup");
        bufferedWriter.write("\n");
        Iterator iterator2 = dataSource.getAllThreads().iterator();
        while (iterator2.hasNext()) {
            object2 = (Thread)iterator2.next();
            iterator = ((Thread)object2).getFunctionProfileIterator();
            while (iterator.hasNext()) {
                object = (FunctionProfile)iterator.next();
                if (object == null) continue;
                bufferedWriter.write(((Thread)object2).getNodeID() + "\t" + ((Thread)object2).getContextID() + "\t" + ((Thread)object2).getThreadID() + "\t");
                bufferedWriter.write(((FunctionProfile)object).getName() + "\t");
                bufferedWriter.write(((FunctionProfile)object).getNumCalls() + "\t");
                bufferedWriter.write(((FunctionProfile)object).getNumSubr() + "");
                for (int i = 0; i < n; ++i) {
                    bufferedWriter.write("\t" + ((FunctionProfile)object).getInclusive(i));
                    bufferedWriter.write("\t" + ((FunctionProfile)object).getExclusive(i));
                }
                bufferedWriter.write("\t" + ((FunctionProfile)object).getFunction().getGroupString());
                bufferedWriter.write("\n");
            }
            bufferedWriter.write("\n");
        }
        bufferedWriter.write("Node\tContext\tThread\tUser Event\tNumSamples\tMin\tMax\tMean\tStdDev\n");
        iterator2 = dataSource.getAllThreads().iterator();
        while (iterator2.hasNext()) {
            object2 = (Thread)iterator2.next();
            iterator = ((Thread)object2).getUserEventProfiles().iterator();
            while (iterator.hasNext()) {
                object = (UserEventProfile)iterator.next();
                if (object == null) continue;
                bufferedWriter.write(((Thread)object2).getNodeID() + "\t" + ((Thread)object2).getContextID() + "\t" + ((Thread)object2).getThreadID());
                bufferedWriter.write("\t" + ((UserEventProfile)object).getUserEvent().getName());
                bufferedWriter.write("\t" + ((UserEventProfile)object).getNumSamples());
                bufferedWriter.write("\t" + ((UserEventProfile)object).getMinValue());
                bufferedWriter.write("\t" + ((UserEventProfile)object).getMaxValue());
                bufferedWriter.write("\t" + ((UserEventProfile)object).getMeanValue());
                bufferedWriter.write("\t" + ((UserEventProfile)object).getStdDev());
                bufferedWriter.write("\n");
            }
            bufferedWriter.write("\n");
        }
        bufferedWriter.close();
        outputStreamWriter.close();
        outputStream.close();
    }

    public static void writePacked(DataSource dataSource, File file) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        DataSourceExport.writePacked(dataSource, fileOutputStream);
    }

    public static void writePacked(DataSource dataSource, OutputStream outputStream) throws IOException {
        int n;
        Object object;
        Object object2;
        UserEvent[] userEventArray;
        Function[] functionArray;
        Object object3;
        Object object4;
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(gZIPOutputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        Group group = dataSource.getGroup("TAU_CALLPATH_DERIVED");
        int n2 = 0;
        Iterator iterator = dataSource.getFunctions();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            if (function.isGroupMember(group)) continue;
            ++n2;
        }
        int n3 = dataSource.getNumberOfMetrics();
        int n4 = dataSource.getNumUserEvents();
        int n5 = dataSource.getNumGroups();
        dataOutputStream.writeChar(80);
        dataOutputStream.writeChar(80);
        dataOutputStream.writeChar(75);
        dataOutputStream.writeInt(2);
        dataOutputStream.writeInt(1);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.writeInt(0);
        if (dataSource.getMetaData() != null) {
            object4 = dataSource.getMetaData();
            dataOutputStream2.writeInt(object4.size());
            object3 = object4.keySet().iterator();
            while (object3.hasNext()) {
                functionArray = (String)object3.next();
                userEventArray = (String)object4.get(functionArray);
                dataOutputStream2.writeUTF((String)functionArray);
                dataOutputStream2.writeUTF((String)userEventArray);
            }
        } else {
            dataOutputStream2.writeInt(0);
        }
        dataOutputStream2.writeInt(dataSource.getAllThreads().size());
        object4 = dataSource.getAllThreads().iterator();
        while (object4.hasNext()) {
            object3 = (Thread)object4.next();
            functionArray = ((Thread)object3).getMetaData();
            dataOutputStream2.writeInt(((Thread)object3).getNodeID());
            dataOutputStream2.writeInt(((Thread)object3).getContextID());
            dataOutputStream2.writeInt(((Thread)object3).getThreadID());
            dataOutputStream2.writeInt(functionArray.size());
            userEventArray = functionArray.keySet().iterator();
            while (userEventArray.hasNext()) {
                object2 = (String)userEventArray.next();
                object = (String)functionArray.get(object2);
                dataOutputStream2.writeUTF((String)object2);
                dataOutputStream2.writeUTF((String)object);
            }
        }
        dataOutputStream2.close();
        dataOutputStream.writeInt(dataOutputStream2.size());
        dataOutputStream.write(byteArrayOutputStream.toByteArray());
        dataOutputStream.writeInt(n3);
        for (int i = 0; i < n3; ++i) {
            object3 = dataSource.getMetricName(i);
            dataOutputStream.writeUTF((String)object3);
        }
        dataOutputStream.writeInt(n5);
        Group[] groupArray = new Group[n5];
        int n6 = 0;
        functionArray = dataSource.getGroups();
        while (functionArray.hasNext()) {
            userEventArray = (Group)functionArray.next();
            object2 = userEventArray.getName();
            dataOutputStream.writeUTF((String)object2);
            groupArray[n6++] = userEventArray;
        }
        functionArray = new Function[n2];
        n6 = 0;
        dataOutputStream.writeInt(n2);
        userEventArray = dataSource.getFunctions();
        while (userEventArray.hasNext()) {
            object2 = (Function)userEventArray.next();
            if (((Function)object2).isGroupMember(group)) continue;
            functionArray[n6++] = object2;
            dataOutputStream.writeUTF(((Function)object2).getName());
            object = ((Function)object2).getGroups();
            if (object == null) {
                dataOutputStream.writeInt(0);
                continue;
            }
            dataOutputStream.writeInt(object.size());
            for (n = 0; n < object.size(); ++n) {
                Group group2 = (Group)object.get(n);
                dataOutputStream.writeInt(DataSourceExport.findGroupID(groupArray, group2));
            }
        }
        userEventArray = new UserEvent[n4];
        n6 = 0;
        dataOutputStream.writeInt(n4);
        object2 = dataSource.getUserEvents();
        while (object2.hasNext()) {
            object = (UserEvent)object2.next();
            userEventArray[n6++] = object;
            dataOutputStream.writeUTF(((UserEvent)object).getName());
        }
        dataOutputStream.writeInt(dataSource.getAllThreads().size());
        object2 = dataSource.getAllThreads().iterator();
        while (object2.hasNext()) {
            Object object5;
            int n7;
            object = (Thread)object2.next();
            dataOutputStream.writeInt(((Thread)object).getNodeID());
            dataOutputStream.writeInt(((Thread)object).getContextID());
            dataOutputStream.writeInt(((Thread)object).getThreadID());
            n = 0;
            for (n7 = 0; n7 < n2; ++n7) {
                object5 = ((Thread)object).getFunctionProfile(functionArray[n7]);
                if (object5 == null) continue;
                ++n;
            }
            dataOutputStream.writeInt(n);
            for (n7 = 0; n7 < n2; ++n7) {
                object5 = ((Thread)object).getFunctionProfile(functionArray[n7]);
                if (object5 == null) continue;
                dataOutputStream.writeInt(n7);
                dataOutputStream.writeDouble(((FunctionProfile)object5).getNumCalls());
                dataOutputStream.writeDouble(((FunctionProfile)object5).getNumSubr());
                for (int i = 0; i < n3; ++i) {
                    dataOutputStream.writeDouble(((FunctionProfile)object5).getExclusive(i));
                    dataOutputStream.writeDouble(((FunctionProfile)object5).getInclusive(i));
                }
            }
            n = 0;
            for (n7 = 0; n7 < n4; ++n7) {
                object5 = ((Thread)object).getUserEventProfile(userEventArray[n7]);
                if (object5 == null) continue;
                ++n;
            }
            dataOutputStream.writeInt(n);
            for (n7 = 0; n7 < n4; ++n7) {
                object5 = ((Thread)object).getUserEventProfile(userEventArray[n7]);
                if (object5 == null) continue;
                dataOutputStream.writeInt(n7);
                dataOutputStream.writeInt((int)((UserEventProfile)object5).getNumSamples());
                dataOutputStream.writeDouble(((UserEventProfile)object5).getMinValue());
                dataOutputStream.writeDouble(((UserEventProfile)object5).getMaxValue());
                dataOutputStream.writeDouble(((UserEventProfile)object5).getMeanValue());
                dataOutputStream.writeDouble(((UserEventProfile)object5).getSumSquared());
            }
        }
        dataOutputStream.close();
        gZIPOutputStream.close();
        outputStream.close();
    }

    private static String xmlFixUp(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll("\n", "&#xa;");
        return string;
    }

    private static void writeXMLSnippet(BufferedWriter bufferedWriter, Map map) throws IOException {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            bufferedWriter.write("<attribute><name>" + DataSourceExport.xmlFixUp(string) + "</name><value>" + DataSourceExport.xmlFixUp(string2) + "</value></attribute>");
        }
    }

    private static void writeMetric(File file, DataSource dataSource, int n, Function[] functionArray, String[] stringArray, UserEvent[] userEventArray) throws IOException {
        int n2 = dataSource.getNumberOfMetrics();
        int n3 = dataSource.getNumUserEvents();
        int n4 = dataSource.getNumGroups();
        Iterator iterator = dataSource.getAllThreads().iterator();
        while (iterator.hasNext()) {
            Object object;
            int n5;
            Thread thread = (Thread)iterator.next();
            File file2 = new File(file + "/profile." + thread.getNodeID() + "." + thread.getContextID() + "." + thread.getThreadID());
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            int n6 = 0;
            for (n5 = 0; n5 < functionArray.length; ++n5) {
                object = thread.getFunctionProfile(functionArray[n5]);
                if (object == null) continue;
                ++n6;
            }
            if (dataSource.getNumberOfMetrics() == 1 && dataSource.getMetricName(n).equals("Time")) {
                bufferedWriter.write(n6 + " templated_functions\n");
            } else {
                bufferedWriter.write(n6 + " templated_functions_MULTI_" + dataSource.getMetricName(n) + "\n");
            }
            if (dataSource.getMetaData() != null) {
                bufferedWriter.write("# Name Calls Subrs Excl Incl ProfileCalls<metadata>");
                DataSourceExport.writeXMLSnippet(bufferedWriter, dataSource.getMetaData());
                DataSourceExport.writeXMLSnippet(bufferedWriter, thread.getMetaData());
                bufferedWriter.write("</metadata>\n");
            } else {
                bufferedWriter.write("# Name Calls Subrs Excl Incl ProfileCalls\n");
            }
            for (n5 = 0; n5 < functionArray.length; ++n5) {
                object = thread.getFunctionProfile(functionArray[n5]);
                if (object == null) continue;
                bufferedWriter.write('\"' + functionArray[n5].getName() + "\" ");
                bufferedWriter.write((int)((FunctionProfile)object).getNumCalls() + " ");
                bufferedWriter.write((int)((FunctionProfile)object).getNumSubr() + " ");
                bufferedWriter.write(((FunctionProfile)object).getExclusive(n) + " ");
                bufferedWriter.write(((FunctionProfile)object).getInclusive(n) + " ");
                bufferedWriter.write("0 GROUP=\"" + stringArray[n5] + "\"\n");
            }
            bufferedWriter.write("0 aggregates\n");
            n6 = 0;
            for (n5 = 0; n5 < n3; ++n5) {
                object = thread.getUserEventProfile(userEventArray[n5]);
                if (object == null) continue;
                ++n6;
            }
            if (n6 > 0) {
                bufferedWriter.write(n6 + " userevents\n");
                bufferedWriter.write("# eventname numevents max min mean sumsqr\n");
                for (n5 = 0; n5 < n3; ++n5) {
                    object = thread.getUserEventProfile(userEventArray[n5]);
                    if (object == null) continue;
                    bufferedWriter.write('\"' + userEventArray[n5].getName() + "\" ");
                    bufferedWriter.write(((UserEventProfile)object).getNumSamples() + " ");
                    bufferedWriter.write(((UserEventProfile)object).getMaxValue() + " ");
                    bufferedWriter.write(((UserEventProfile)object).getMinValue() + " ");
                    bufferedWriter.write(((UserEventProfile)object).getMeanValue() + " ");
                    bufferedWriter.write(((UserEventProfile)object).getSumSquared() + "\n");
                }
            }
            bufferedWriter.close();
            outputStreamWriter.close();
            fileOutputStream.close();
        }
    }

    public static String createSafeMetricName(String string) {
        String string2 = string.replace('/', '\\');
        return string2;
    }

    public static void writeProfiles(DataSource dataSource, File file) throws IOException {
        int n;
        Object object;
        Object object2;
        UserEvent[] userEventArray;
        String[] stringArray;
        Object object3;
        int n2 = dataSource.getNumberOfMetrics();
        int n3 = dataSource.getNumUserEvents();
        int n4 = dataSource.getNumGroups();
        int n5 = 0;
        Group group = dataSource.getGroup("TAU_CALLPATH_DERIVED");
        int n6 = 0;
        Group[] groupArray = dataSource.getFunctions();
        while (groupArray.hasNext()) {
            object3 = (Function)groupArray.next();
            if (object3.isGroupMember(group)) continue;
            ++n6;
        }
        groupArray = new Group[n4];
        object3 = dataSource.getGroups();
        while (object3.hasNext()) {
            stringArray = (String[])object3.next();
            userEventArray = stringArray.getName();
            groupArray[n5++] = stringArray;
        }
        object3 = new Function[n6];
        stringArray = new String[n6];
        n5 = 0;
        userEventArray = dataSource.getFunctions();
        while (userEventArray.hasNext()) {
            object2 = (Function)userEventArray.next();
            if (((Function)object2).isGroupMember(group)) continue;
            object3[n5] = object2;
            object = ((Function)object2).getGroups();
            if (object == null) {
                stringArray[n5] = "";
            } else {
                stringArray[n5] = "";
                for (n = 0; n < object.size(); ++n) {
                    Group group2 = (Group)object.get(n);
                    stringArray[n5] = n == 0 ? group2.getName() : stringArray[n5] + " | " + group2.getName();
                }
                stringArray[n5] = stringArray[n5].trim();
            }
            ++n5;
        }
        userEventArray = new UserEvent[n3];
        n5 = 0;
        object2 = dataSource.getUserEvents();
        while (object2.hasNext()) {
            object = (UserEvent)object2.next();
            userEventArray[n5++] = object;
        }
        if (n2 == 1) {
            DataSourceExport.writeMetric(file, dataSource, 0, object3, stringArray, userEventArray);
        } else {
            for (int i = 0; i < n2; ++i) {
                object = "MULTI__" + DataSourceExport.createSafeMetricName(dataSource.getMetricName(i));
                n = new File((String)object).mkdir() ? 1 : 0;
                if (n == 0) {
                    System.err.println("Failed to create directory: " + (String)object);
                    continue;
                }
                DataSourceExport.writeMetric(new File(file + "/" + (String)object), dataSource, i, object3, stringArray, userEventArray);
            }
        }
    }
}

