/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.loader;

import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.UtilFncs;
import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class LoadTrial {
    private String[] sourceFiles;
    private String metadataFile;
    private Experiment exp;
    private boolean fixNames;
    private boolean summaryOnly;
    private int expID;
    public int trialID;
    private DataSource dataSource;
    public String trialName;
    public String problemFile;
    public String configuration;
    private DatabaseAPI databaseAPI;
    private Trial trial;

    public static void usage() {
        System.err.println("Usage: perfdmf_loadtrial -a <appName> -x <expName> -n <name> [options] <files>\n\ntry `perfdmf_loadtrial --help' for more information");
    }

    public static void outputHelp() {
        System.err.println("Usage: perfdmf_loadtrial -a <appName> -x <expName> -n <name> [options] <files>\n\nRequired Arguments:\n\n  -n, --name <text>               Specify the name of the trial\n  -a, --applicationname <string>  Specify associated application name\n                                    for this trial\n  -x, --experimentname <string>   Specify associated experiment name\n                                    for this trial\n               ...or...\n\n  -n, --name <text>               Specify the name of the trial\n  -e, --experimentid <number>     Specify associated experiment ID\n                                    for this trial\n\nOptional Arguments:\n\n  -c, --config <name>             Specify the name of the configuration to use\n  -g, --configFile <file>         Specify the configuration file to use\n                                    (overrides -c)\n  -f, --filetype <filetype>       Specify type of performance data, options are:\n                                    profiles (default), pprof, dynaprof, mpip,\n                                    gprof, psrun, hpm, packed, cube, hpc, ompp,\n                                    snap, perixml\n  -t, --trialid <number>          Specify trial ID\n  -i, --fixnames                  Use the fixnames option for gprof\n  -m, --metadata <filename>       XML metadata for the trial\n\nNotes:\n  For the TAU profiles type, you can specify either a specific set of profile\nfiles on the commandline, or you can specify a directory (by default the current\ndirectory).  The specified directory will be searched for profile.*.*.* files,\nor, in the case of multiple counters, directories named MULTI_* containing\nprofile data.\n\nExamples:\n\n  perfdmf_loadtrial -e 12 -n \"Batch 001\"\n    This will load profile.* (or multiple counters directories MULTI_*) into\n    experiment 12 and give the trial the name \"Batch 001\"\n\n  perfdmf_loadtrial -e 12 -n \"HPM data 01\" -f hpm perfhpm*\n    This will load perfhpm* files of type HPMToolkit into experiment 12 and give\n    the trial the name \"HPM data 01\"\n\n  perfdmf_loadtrial -a \"NPB2.3\" -x \"parametric\" -n \"64\" par64.ppk\n    This will load packed profile par64.ppk into the experiment named\n    \"parametric\" under the application named \"NPB2.3\" and give the trial\n    the name \"64\".  The application and experiment will be created if not found.\n");
    }

    public LoadTrial(String string, String[] stringArray) {
        this.sourceFiles = stringArray;
        this.databaseAPI = new DatabaseAPI();
        try {
            this.databaseAPI.initialize(string, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public boolean checkForExp(String string, String string2, String string3) {
        if (string != null) {
            this.expID = Integer.parseInt(string);
            try {
                this.exp = this.databaseAPI.setExperiment(this.expID);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.exp == null) {
                System.err.println("Experiment id " + string + " not found,  please enter a valid experiment ID.");
                System.exit(-1);
                return false;
            }
            return true;
        }
        Experiment experiment = this.databaseAPI.getExperiment(string2, string3, true);
        this.expID = experiment.getID();
        return true;
    }

    public boolean checkForTrial(String string) {
        Trial trial = this.databaseAPI.setTrial(Integer.parseInt(string));
        return trial != null;
    }

    public void loadTrial(int n) {
        File[] fileArray = new File[this.sourceFiles.length];
        for (int i = 0; i < this.sourceFiles.length; ++i) {
            fileArray[i] = new File(this.sourceFiles[i]);
        }
        try {
            this.dataSource = UtilFncs.initializeDataSource(fileArray, n, this.fixNames);
        }
        catch (DataSourceException dataSourceException) {
            if (fileArray == null || fileArray.length != 0) {
                dataSourceException.printStackTrace();
            }
            return;
        }
        this.trial = new Trial();
        this.trial.setDataSource(this.dataSource);
        try {
            if (this.metadataFile != null) {
                this.dataSource.setMetadataFile(this.metadataFile);
            }
        }
        catch (Exception exception) {
            System.err.println("Error Loading metadata:");
            exception.printStackTrace();
            System.exit(1);
        }
        try {
            this.dataSource.load();
        }
        catch (Exception exception) {
            System.err.println("Error Loading Trial:");
            exception.printStackTrace();
        }
        this.trial.setMetaData(this.dataSource.getMetaData());
        if (this.trialID == 0) {
            this.saveTrial();
        } else {
            this.appendToTrial();
        }
    }

    public void saveTrial() {
        this.trial.setName(this.trialName);
        System.err.println("TrialName: " + this.trialName);
        this.trial.setExperimentID(this.expID);
        try {
            this.databaseAPI.uploadTrial(this.trial, this.summaryOnly);
        }
        catch (DatabaseException databaseException) {
            databaseException.printStackTrace();
            Exception exception = databaseException.getException();
            System.err.println("from: ");
            exception.printStackTrace();
            System.exit(-1);
        }
        System.err.println("Done saving trial!");
    }

    public void appendToTrial() {
        this.trial.setID(this.trialID);
        try {
            this.databaseAPI.saveTrial(this.trial, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        System.err.println("Done adding metric to trial!");
    }

    public String getProblemString() {
        if (this.problemFile == null) {
            return new String("");
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.problemFile));
        }
        catch (Exception exception) {
            System.err.println("Problem file not found!  Exiting...");
            System.exit(0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            String string;
            try {
                string = bufferedReader.readLine();
            }
            catch (Exception exception) {
                string = null;
            }
            if (string == null) break;
            stringBuffer.append(string.replaceAll("'", "'"));
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Object object;
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addBooleanOption('h', "help");
        CmdLineParser.Option option2 = cmdLineParser.addStringOption('e', "experimentid");
        CmdLineParser.Option option3 = cmdLineParser.addStringOption('n', "name");
        CmdLineParser.Option option4 = cmdLineParser.addStringOption('c', "config");
        CmdLineParser.Option option5 = cmdLineParser.addStringOption('g', "configFile");
        CmdLineParser.Option option6 = cmdLineParser.addStringOption('t', "trialid");
        CmdLineParser.Option option7 = cmdLineParser.addStringOption('f', "filetype");
        CmdLineParser.Option option8 = cmdLineParser.addBooleanOption('i', "fixnames");
        CmdLineParser.Option option9 = cmdLineParser.addStringOption('m', "metadata");
        CmdLineParser.Option option10 = cmdLineParser.addStringOption('a', "applicationname");
        CmdLineParser.Option option11 = cmdLineParser.addStringOption('x', "experimentname");
        CmdLineParser.Option option12 = cmdLineParser.addBooleanOption('s', "summaryonly");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println(optionException.getMessage());
            LoadTrial.usage();
            System.exit(-1);
        }
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option);
        String string = (String)cmdLineParser.getOptionValue(option4);
        String string2 = (String)cmdLineParser.getOptionValue(option5);
        String string3 = (String)cmdLineParser.getOptionValue(option2);
        String string4 = (String)cmdLineParser.getOptionValue(option3);
        String string5 = (String)cmdLineParser.getOptionValue(option10);
        String string6 = (String)cmdLineParser.getOptionValue(option11);
        String string7 = (String)cmdLineParser.getOptionValue(option6);
        String string8 = (String)cmdLineParser.getOptionValue(option7);
        Boolean bl2 = (Boolean)cmdLineParser.getOptionValue(option8);
        String string9 = (String)cmdLineParser.getOptionValue(option9);
        Boolean bl3 = (Boolean)cmdLineParser.getOptionValue(option12);
        if (bl != null && bl.booleanValue()) {
            LoadTrial.outputHelp();
            System.exit(-1);
        }
        if (string2 == null) {
            string2 = string == null ? System.getProperty("user.home") + "/.ParaProf/perfdmf.cfg" : System.getProperty("user.home") + "/.ParaProf/perfdmf.cfg." + string;
        }
        if (string4 == null) {
            System.err.println("Error: Missing trial name\n");
            LoadTrial.usage();
            System.exit(-1);
        } else if (string3 == null && string6 == null) {
            System.err.println("Error: Missing experiment id or name\n");
            LoadTrial.usage();
            System.exit(-1);
        } else if (string6 != null && string5 == null) {
            System.err.println("Error: Missing application name\n");
            LoadTrial.usage();
            System.exit(-1);
        }
        String[] stringArray2 = cmdLineParser.getRemainingArgs();
        int n = 0;
        if (string8 != null) {
            if (string8.equals("profiles")) {
                n = 0;
            } else if (string8.equals("pprof")) {
                n = 1;
            } else if (string8.equals("dynaprof")) {
                n = 2;
            } else if (string8.equals("mpip")) {
                n = 3;
            } else if (string8.equals("hpm")) {
                n = 4;
            } else if (string8.equals("gprof")) {
                n = 5;
            } else if (string8.equals("psrun")) {
                n = 6;
            } else if (string8.equals("packed")) {
                n = 7;
            } else if (string8.equals("cube")) {
                n = 8;
            } else if (string8.equals("hpc")) {
                n = 9;
            } else if (string8.equals("gyro")) {
                n = 100;
            } else if (string8.equals("ompp")) {
                n = 11;
            } else if (string8.equals("snap")) {
                n = 10;
            } else if (string8.equals("perixml")) {
                n = 12;
            } else {
                System.err.println("Please enter a valid file type.");
                LoadTrial.usage();
                System.exit(-1);
            }
        } else if (stringArray2.length == 1) {
            object = stringArray2[0];
            if (((String)object).toLowerCase().endsWith(".ppk")) {
                n = 7;
            }
            if (((String)object).toLowerCase().endsWith(".cube")) {
                n = 8;
            }
            if (((String)object).toLowerCase().endsWith(".mpip")) {
                n = 3;
            }
        }
        if (string4 == null) {
            string4 = "";
        }
        if (bl2 == null) {
            bl2 = new Boolean(false);
        }
        if (bl3 == null) {
            bl3 = new Boolean(false);
        }
        object = new LoadTrial(string2, stringArray2);
        ((LoadTrial)object).checkForExp(string3, string5, string6);
        if (string7 != null) {
            ((LoadTrial)object).checkForTrial(string7);
            ((LoadTrial)object).trialID = Integer.parseInt(string7);
        }
        ((LoadTrial)object).trialName = string4;
        ((LoadTrial)object).fixNames = bl2;
        ((LoadTrial)object).metadataFile = string9;
        ((LoadTrial)object).summaryOnly = bl3;
        ((LoadTrial)object).loadTrial(n);
    }
}

