/****************************************************************************
 *			Tuning and Analysis Utilities
 *			http://www.cs.uoregon.edu/research/paracomp/tau
 ****************************************************************************
 * Copyright (c) 1997-2006
 *    Department of Computer and Information Science, University of Oregon
 *    Advanced Computing Laboratory, Los Alamos National Laboratory
 *    Research Center Juelich, ZAM Germany	
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Wyatt Spear - initial API and implementation
 ****************************************************************************/
package org.eclipse.ptp.tau.performance.internal;

public interface IPerformanceLaunchConfigurationConstants {

	public static final String ATTR_PERFORMANCEBUILD_CONFIGURATION_NAME = "ATTR_PERFORMANCEBUILD_CONFIGURATION_NAME";
	
	public static final String BUILDONLY = "build_but_do_not_run_instrumented_executable";
	public static final boolean BUILDONLY_DEF = false;

	/**
	 * ID for boolean: true = keep instrumented executable
	 */
	public static final String NOCLEAN = "keep_instrumented_executable";
	public static final boolean NOCLEAN_DEF = false;
	
	/**
	 * The name appended to new build configurations designated by performance tool recompilation
	 */
	public static final String PERF_RECOMPILE="true_if_recompiling_for_analysis";
	public static final String TOOLCONFNAME="performance_tool_build_configuration_name_modifier";
	public static final String DEFAULT_TOOLCONFNAME="PerformanceAnalysis";
	
	public static final String SELECTED_TOOL="selected_performance_tool";
	
//	public static final String COMPILER_REPLACE="totally_replace_default_compiler";
//	public static final boolean COMPILER_REPLACE_DEF=false;
//	
//	public static final String CC_COMPILER="performance_tool_cc_compiler";
//	public static final String CXX_COMPILER="performance_tool_cxx_compiler";
//	public static final String F90_COMPILER="performance_tool_f90_compiler";
	public static final String EMPTY_STRING="";
	
	
	/**
	 * ID for the application prepended to the execution command
	 */
//	public static final String EXEC_UTIL_LIST="list_of_performance_analysis_execution_utilities";
//	public static final String DEF_EXEC_UTIL=null;
//	
	public static final String USE_EXEC_UTIL="true_if_using_performance_analysis_execution_utility";
//	
//	public static final String EXEC_UTIL_ARGS="ID_for_list_of_arguments_to_the_execution_utilities";
//	public static final String DEF_EXEC_UTIL_ARGS=EMPTY_STRING;
	
	//public static final String SAVE_PROGRAM="origional_program_being_exicuted";
	//public static final String SAVE_ARGS="origional_args_being_passed";
	
	
	/**
	 * ID for List of post-launch performance analysis commands
	 * TODO: This needs to be made more featureful/general
	 */
//	public static final String TOOL_LIST="performance_analysis_tool_and_argument_list";
//	public static final String TOOL_ARGS="arguments_to_tools_in_TOOL_LIST";
	
	/**
	 * ID for String: location of the xml file defining tools
	 */
	public static final String XMLLOCID="tool_def_xml_location";
	
	/**
	 * ID for boolean: true = use TAU launch system rather than xml-driven toolset
	 */
	public static final String TAULAUNCH="use_tau_launch_system";//TODO:  This is a stop-gap until TAU support is made fully modular
	public static final boolean TAULAUNCH_DEF=false;

	/**
	 * This string will be swapped out for a stored project location if possible if found in an argument string.  Used primarily for indicating location of 
	 * selective instrumentation files generated by other plugins
	 */
	public static final String PROJECT_LOCATION="replace_this_string_with_the_project_path";
	
	/**
	 * This string plus the tool ID is the string associated with tool's bin path in the workspace preferences
	 */
	public static final String TOOL_BIN_ID="performance_tool_bin_directory";
}
