/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerChart;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerClient;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerConnection;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerWindowUtility;
import edu.uoregon.tau.perfexplorer.common.RMIView;
import edu.uoregon.tau.perfexplorer.common.TransformationType;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jfree.data.general.SeriesException;

public class ChartGUI
extends JFrame
implements ActionListener {
    private ActionListener listener = null;
    private JPanel panel = null;
    private final int windowWidth = 480;
    private final int windowHeight = 400;
    private final JLabel chartLabel = new JLabel("Chart Type");
    private final JLabel metricLabel = new JLabel("Set Metric of Interest");
    private final JLabel groupLabel = new JLabel("Set Group Name");
    private final JLabel eventLabel = new JLabel("Set Event of Interest");
    private final JLabel scalingLabel = new JLabel("Set Problem Size (Scaling)");
    private final JLabel timestepsLabel = new JLabel("Set Total Number of Timesteps");
    private final JLabel reductionMethodLabel = new JLabel("Select Dimension Reduction");
    private final JLabel reductionThresholdLabel = new JLabel("Reduction Threshold");
    private JComboBox chart = new JComboBox();
    private JComboBox metric = new JComboBox();
    private JComboBox group = new JComboBox();
    private JComboBox event = new JComboBox();
    private JComboBox scaling = new JComboBox();
    private JComboBox reductionMethod = new JComboBox();
    private JTextField timesteps = new JTextField("100");
    private JTextField reductionThreshold = new JTextField("2.0");
    private JButton goButton = new JButton("Create Chart");
    private PerfExplorerConnection server = PerfExplorerConnection.getConnection();
    private PerfExplorerModel theModel = null;
    private static ChartGUI theInstance = null;
    private static boolean averageWarning = false;

    private ChartGUI(String string, ActionListener actionListener) throws HeadlessException {
        super(string);
        this.listener = actionListener;
        this.setListeners();
        this.panel = new JPanel(new GridBagLayout());
        this.getContentPane().add(this.panel);
        PerfExplorerWindowUtility.centerWindow(this, 480, 400, -200, -200, true);
        URL uRL = Utility.getResource((String)"tau32x32.gif");
        if (uRL != null) {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                theInstance = null;
            }
        });
        this.addComponents();
        this.refreshStatic();
        this.refreshDynamic();
        this.doEnableDisable();
        this.setResizable(false);
        this.pack();
        this.setVisible(true);
        this.toFront();
    }

    public static ChartGUI getInstance(boolean bl) {
        if (theInstance == null && bl) {
            theInstance = new ChartGUI("Scalabilty Chart Control Center", PerfExplorerClient.getMainFrame().getListener());
        }
        return theInstance;
    }

    private void setListeners() {
        this.chart.addActionListener(this);
        this.metric.addActionListener(this);
        this.group.addActionListener(this);
        this.scaling.addActionListener(this);
        this.timesteps.addActionListener(this);
        this.goButton.addActionListener(this);
    }

    private void doEnableDisable() {
        ChartType chartType = (ChartType)this.chart.getSelectedItem();
        this.eventLabel.setEnabled(false);
        this.groupLabel.setEnabled(false);
        this.timestepsLabel.setEnabled(false);
        this.scalingLabel.setEnabled(false);
        this.reductionMethodLabel.setEnabled(false);
        this.reductionThresholdLabel.setEnabled(false);
        this.event.setEnabled(false);
        this.group.setEnabled(false);
        this.timesteps.setEnabled(false);
        this.scaling.setEnabled(false);
        this.reductionMethod.setEnabled(false);
        this.reductionThreshold.setEnabled(false);
        switch (chartType.index) {
            case 0: {
                this.timesteps.setEnabled(true);
                break;
            }
            case 3: 
            case 7: {
                this.enableReduction();
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: {
                this.scalingLabel.setEnabled(true);
                this.scaling.setEnabled(true);
                break;
            }
            case 4: 
            case 8: {
                this.scalingLabel.setEnabled(true);
                this.scaling.setEnabled(true);
                this.eventLabel.setEnabled(true);
                this.event.setEnabled(true);
                break;
            }
            case 10: {
                this.groupLabel.setEnabled(true);
                this.group.setEnabled(true);
                break;
            }
            case 12: {
                this.scalingLabel.setEnabled(true);
                this.scaling.setEnabled(true);
            }
            case 11: {
                this.enableReduction();
                break;
            }
            case 14: {
                this.enableReduction();
                break;
            }
            case 15: {
                this.enableReduction();
            }
        }
    }

    private void enableReduction() {
        this.reductionMethodLabel.setEnabled(true);
        this.reductionMethod.setEnabled(true);
        this.reductionThresholdLabel.setEnabled(true);
        this.reductionThreshold.setEnabled(true);
    }

    private void addComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.theModel = PerfExplorerModel.getModel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.panel.add((Component)this.chartLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panel.add((Component)this.chart, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panel.add((Component)this.metricLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panel.add((Component)this.metric, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panel.add((Component)this.groupLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panel.add((Component)this.group, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panel.add((Component)this.eventLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panel.add((Component)this.event, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panel.add((Component)this.reductionMethodLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panel.add((Component)this.reductionMethod, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panel.add((Component)this.reductionThresholdLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panel.add((Component)this.reductionThreshold, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panel.add((Component)this.timestepsLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panel.add((Component)this.timesteps, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panel.add((Component)this.scalingLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.panel.add((Component)this.scaling, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        this.panel.add((Component)this.goButton, gridBagConstraints);
    }

    private void refreshStatic() {
        this.chart.removeAllItems();
        this.chart.addItem(new ChartType("Aligned Stacked Bar Chart", 15));
        this.chart.addItem(new ChartType("Stacked Bar Chart", 14));
        this.chart.addItem(new ChartType("Total Execution Time", 1));
        this.chart.addItem(new ChartType("Timesteps Per Second", 0));
        this.chart.addItem(new ChartType("Relative Efficiency", 2));
        this.chart.addItem(new ChartType("Relative Efficiency by Event", 3));
        this.chart.addItem(new ChartType("Relative Efficiency for One Event", 4));
        this.chart.addItem(new ChartType("Relative Efficiency per Phase", 5));
        this.chart.addItem(new ChartType("Relative Speedup", 6));
        this.chart.addItem(new ChartType("Relative Speedup by Event", 7));
        this.chart.addItem(new ChartType("Relative Speedup for One Event", 8));
        this.chart.addItem(new ChartType("Relative Speedup per Phase", 9));
        this.chart.addItem(new ChartType("Group % of Total Runtime", 10));
        this.chart.addItem(new ChartType("Runtime Breakdown", 11));
        this.chart.addItem(new ChartType("Correlate Events with Total Runtime", 12));
        this.chart.addItem(new ChartType("Phase Fraction of Total Runtime", 13));
        this.scaling.removeAllItems();
        this.scaling.addItem("The problem size remains constant. (strong scaling)");
        this.scaling.addItem("The problem size increases as the processor count increases. (weak scaling)");
        this.reductionMethod.removeAllItems();
        this.reductionMethod.addItem("None");
        this.reductionMethod.addItem("Minimum Percentage");
        this.reductionMethod.setSelectedIndex(1);
    }

    public void refresh() {
        this.refreshDynamic();
    }

    private void refreshDynamic() {
        if (this.theModel.getApplication() == null) {
            return;
        }
        if (this.metric.isEnabled()) {
            this.getMetrics();
        }
        if (this.group.isEnabled()) {
            this.getGroups();
        }
        if (this.event.isEnabled()) {
            this.getEvents();
        }
    }

    private void getMetrics() {
        Object object = this.metric.getSelectedItem();
        String string = "";
        if (object != null) {
            string = (String)object;
        }
        this.metric.removeAllItems();
        List<String> list = this.server.getPotentialMetrics(this.theModel);
        boolean bl = false;
        for (String string2 : list) {
            if (string2.toUpperCase().indexOf("TIME") > 0) {
                bl = true;
            }
            this.metric.addItem(string2);
            if (!string.equals(string2)) continue;
            this.metric.setSelectedItem(string2);
        }
        if (bl) {
            this.metric.addItem("TIME");
            if (string.equals("TIME")) {
                this.metric.setSelectedItem("TIME");
            }
        }
    }

    private void getEvents() {
        Object object = this.event.getSelectedItem();
        String string = "";
        if (object != null) {
            string = (String)object;
        }
        this.event.removeAllItems();
        List<String> list = this.server.getPotentialEvents(this.theModel);
        for (String string2 : list) {
            this.event.addItem(string2);
            if (!string.equals(string2)) continue;
            this.event.setSelectedItem(string2);
        }
    }

    private void getGroups() {
        Object object = this.group.getSelectedItem();
        String string = "";
        if (object != null) {
            string = (String)object;
        }
        this.group.removeAllItems();
        List<String> list = this.server.getPotentialGroups(this.theModel);
        for (String string2 : list) {
            this.group.addItem(string2);
            if (!string.equals(string2)) continue;
            this.group.setSelectedItem(string2);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object.equals(this.chart)) {
                this.refreshDynamic();
                this.doEnableDisable();
            } else if (object.equals(this.goButton)) {
                PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
                Object object2 = perfExplorerModel.getCurrentSelection();
                if (!(object2 instanceof Experiment) && !(object2 instanceof RMIView)) {
                    JOptionPane.showMessageDialog(PerfExplorerClient.getMainFrame(), "Please select one or more Experiments or one View.", "Selection Error", 0);
                    return;
                }
                String string = (String)this.metric.getSelectedItem();
                String string2 = (String)this.event.getSelectedItem();
                String string3 = (String)this.group.getSelectedItem();
                String string4 = this.timesteps.getText();
                String string5 = (String)this.scaling.getSelectedItem();
                String string6 = (String)this.reductionMethod.getSelectedItem();
                String string7 = this.reductionThreshold.getText();
                perfExplorerModel.setMetricName(string);
                perfExplorerModel.setEventName(string2);
                perfExplorerModel.setGroupName(string3);
                perfExplorerModel.setTotalTimesteps(string4);
                perfExplorerModel.setConstantProblem(string5.startsWith("The problem size remains"));
                if (string6.equals("None")) {
                    perfExplorerModel.setDimensionReduction(TransformationType.NONE);
                } else {
                    perfExplorerModel.setDimensionReduction(TransformationType.OVER_X_PERCENT);
                    perfExplorerModel.setXPercent(string7);
                }
                ChartGUI.checkScaling();
                ChartType chartType = (ChartType)this.chart.getSelectedItem();
                switch (chartType.index) {
                    case 0: {
                        PerfExplorerChart.doTimestepsChart();
                        break;
                    }
                    case 1: {
                        PerfExplorerChart.doTotalTimeChart();
                        break;
                    }
                    case 2: {
                        PerfExplorerChart.doEfficiencyChart();
                        break;
                    }
                    case 3: {
                        PerfExplorerChart.doEfficiencyEventsChart();
                        break;
                    }
                    case 4: {
                        PerfExplorerChart.doEfficiencyOneEventChart();
                        break;
                    }
                    case 5: {
                        PerfExplorerChart.doEfficiencyPhasesChart();
                        break;
                    }
                    case 6: {
                        PerfExplorerChart.doSpeedupChart();
                        break;
                    }
                    case 7: {
                        PerfExplorerChart.doSpeedupEventsChart();
                        break;
                    }
                    case 8: {
                        PerfExplorerChart.doSpeedupOneEventChart();
                        break;
                    }
                    case 9: {
                        PerfExplorerChart.doSpeedupPhasesChart();
                        break;
                    }
                    case 10: {
                        PerfExplorerChart.doCommunicationChart();
                        break;
                    }
                    case 11: {
                        PerfExplorerChart.doFractionChart();
                        break;
                    }
                    case 12: {
                        PerfExplorerChart.doCorrelationChart();
                        break;
                    }
                    case 13: {
                        PerfExplorerChart.doFractionPhasesChart();
                        break;
                    }
                    case 14: {
                        PerfExplorerChart.doStackedBarChart();
                        break;
                    }
                    case 15: {
                        PerfExplorerChart.doAlignedStackedBarChart();
                    }
                }
            }
        }
        catch (SeriesException seriesException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Two or more trials in this selection have the same total number of threads of execution, and an error occurred.\n");
            stringBuilder.append("To create a scalability chart, please ensure the trials selected have different numbers of threads.\n");
            stringBuilder.append("To create a different parametric chart, please use the custom chart interface.");
            JOptionPane.showMessageDialog(PerfExplorerClient.getMainFrame(), stringBuilder.toString(), "Selection Warning", 0);
        }
        catch (Exception exception) {
            System.err.println("actionPerformed Exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static void checkScaling() {
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Map<String, Integer> map = PerfExplorerConnection.getConnection().checkScalabilityChartData(perfExplorerModel);
        for (String string : map.keySet()) {
            Integer n = map.get(string);
            if (n <= 1 || averageWarning) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Two or more trials in this selection are in the same experiment and have the same total number of threads of execution.\n");
            stringBuilder.append("Trials with the same numbers of threads will have their measurements averaged.\n");
            stringBuilder.append("To create a different parametric chart, please use the custom chart interface.");
            JOptionPane.showMessageDialog(PerfExplorerClient.getMainFrame(), stringBuilder.toString(), "Selection Warning", 2);
            averageWarning = true;
        }
    }

    private class ChartType {
        int index = 0;
        String name = "";

        public ChartType(String string, int n) {
            this.name = string;
            this.index = n;
        }

        public String toString() {
            return this.name;
        }
    }
}

