/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.perfexplorer.client.PerfExplorerChart;
import edu.uoregon.tau.perfexplorer.common.RMIChartData;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.List;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.XYDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationPlotDataset
extends AbstractXYDataset
implements XYDataset {
    private static final long serialVersionUID = 2371762530237884209L;
    private RMIChartData data = null;
    private List<String> seriesNames = null;
    private int x = 0;
    private int y = 1;
    private boolean main = false;
    private int maxLabels = 0;

    public CorrelationPlotDataset(RMIChartData rMIChartData, boolean bl) {
        this.data = rMIChartData;
        this.seriesNames = rMIChartData.getRowLabels();
        this.main = bl;
    }

    public int getSeriesCount() {
        if (this.main) {
            return 1;
        }
        return this.data.getRows() - 1;
    }

    public Comparable<String> getSeriesKey(int n) {
        if (this.main) {
            return PerfExplorerChart.shortName(this.seriesNames.get(n));
        }
        String string = PerfExplorerChart.shortName(this.seriesNames.get(n + 1));
        return string + ", r = " + this.getCorrelation(0, n + 1);
    }

    public int getItemCount(int n) {
        return this.data.getRowData(n).size();
    }

    public Number getX(int n, int n2) {
        if (!this.main) {
            ++n;
        }
        List<double[]> list = this.data.getRowData(n);
        try {
            double[] dArray = list.get(n2);
            this.maxLabels = dArray.length;
            return new Double(dArray[this.x]);
        }
        catch (Exception exception) {
            return new Double(0.0);
        }
    }

    public Number getY(int n, int n2) {
        if (!this.main) {
            ++n;
        }
        List<double[]> list = this.data.getRowData(n);
        try {
            double[] dArray = list.get(n2);
            return new Double(dArray[this.y]);
        }
        catch (Exception exception) {
            return new Double(0.0);
        }
    }

    public String getCorrelation(int n, int n2) {
        Object object;
        double[] dArray;
        int n3;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        List<double[]> list = this.data.getRowData(n);
        List<double[]> list2 = this.data.getRowData(n2);
        for (n3 = 0; n3 < list.size() && n3 < list2.size(); ++n3) {
            dArray = list.get(n3);
            d2 += dArray[1];
            dArray = list2.get(n3);
            d3 += dArray[1];
        }
        d2 /= (double)list.size();
        d3 /= (double)list2.size();
        for (n3 = 0; n3 < list.size() && n3 < list2.size(); ++n3) {
            dArray = list.get(n3);
            d4 += (dArray[1] - d2) * (dArray[1] - d2);
            dArray = list2.get(n3);
            d5 += (dArray[1] - d3) * (dArray[1] - d3);
        }
        d4 /= (double)(list.size() - 1);
        d4 = Math.sqrt(d4);
        d5 /= (double)(list2.size() - 1);
        d5 = Math.sqrt(d5);
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < list.size() && i < list2.size(); ++i) {
            object = list.get(i);
            d6 = (object[1] - d2) / d4;
            object = list2.get(i);
            d7 = (object[1] - d3) / d5;
            d += d6 * d7;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        object = new FieldPosition(0);
        StringBuffer stringBuffer = new StringBuffer();
        decimalFormat.format(new Double(d /= (double)(list.size() - 1)), stringBuffer, (FieldPosition)object);
        return stringBuffer.toString();
    }
}

