/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfexplorer.client.Expression;
import edu.uoregon.tau.perfexplorer.client.ParsingException;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import java.io.FileNotFoundException;
import java.util.List;

public class PerfExplorerExpression
extends Expression {
    private static String spaces = "  ";
    private String script = "";

    public static void main(String[] stringArray) {
        PerfExplorerExpression perfExplorerExpression = new PerfExplorerExpression();
        try {
            System.out.println(perfExplorerExpression.getScriptFromExpressions("a", "b-c", null, "a+B"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getScriptFromExpressions(String string, String string2, String string3, String string4) throws ParsingException {
        this.script = "";
        String string5 = PerfExplorerExpression.initScript();
        super.parseExpressions(string4);
        string5 = string5 + this.script;
        string5 = string5 + this.finalizeScript(string, string2, string3);
        return string5;
    }

    public String getScriptFromFile(String string, String string2, String string3, String string4) throws ParsingException, FileNotFoundException {
        this.script = "";
        String string5 = PerfExplorerExpression.initScript();
        super.parseFile(string4);
        string5 = string5 + this.script;
        string5 = string5 + this.finalizeScript(string, string2, string3);
        return string5;
    }

    private String finalizeScript(String string, String string2, String string3) {
        if (string == null) {
            return PerfExplorerExpression.endOfScript();
        }
        String string4 = "";
        string4 = string4 + spaces + "saver = SaveResultOperation(result)\n";
        string4 = string4 + spaces + "saver.processData()\n";
        string4 = string4 + spaces + "return\n";
        string4 = string4 + "print \"--------------- JPython test script start ------------\"\n";
        if (string2 == null) {
            string4 = string4 + "inExp = Utilities.getExperimentsForApplication(\"" + string + "\")\n";
            string4 = string4 + "for exp in inExp:\n";
            string4 = string4 + "  trials = Utilities.getTrialsForExperiment(\"" + string + "\", exp.getName())\n";
            string4 = string4 + "  for trial in trials:\n";
            string4 = string4 + "     result = load(\"" + string + "\",exp.getName(),trial.getName())\n";
            string4 = string4 + "     computeDerived(result)\n";
            string4 = string4 + "\n";
            string4 = string4 + "print \"---------------- JPython test script end -------------\"\n";
            return string4;
        }
        if (string3 == null) {
            string4 = string4 + "trials = Utilities.getTrialsForExperiment(\"" + string + "\", \"" + string2 + "\")\n";
            string4 = string4 + "for trial in trials:\n";
            string4 = string4 + "   result = load(\"" + string + "\",\"" + string2 + "\", trial.getName())\n";
            string4 = string4 + "   computeDerived(result)\n";
            string4 = string4 + "\n";
            string4 = string4 + "print \"---------------- JPython test script end -------------\"\n";
            return string4;
        }
        string4 = string4 + "result = load(\"" + string + "\",\"" + string2 + "\",\"" + string3 + "\")\n";
        string4 = string4 + "computeDerived(result)\n";
        string4 = string4 + "print \"---------------- JPython test script end -------------\"\n";
        return string4;
    }

    private String getDeriveOper(char c) {
        switch (c) {
            case '+': {
                return "DeriveMetricOperation.ADD";
            }
            case '-': {
                return "DeriveMetricOperation.SUBTRACT";
            }
            case '*': {
                return "DeriveMetricOperation.MULTIPLY";
            }
            case '/': {
                return "DeriveMetricOperation.DIVIDE";
            }
        }
        return null;
    }

    private static String endOfScript() {
        String string = spaces + "saver = SaveResultOperation(result)\n";
        string = string + spaces + "saver.setForceOverwrite(True)\n";
        string = string + spaces + "saver.processData()\n";
        string = string + spaces + "return\n";
        string = string + "print \"--------------- JPython test script start ------------\"\n";
        string = string + PerfExplorerExpression.addApplicaitons();
        string = string + "for app in apps:\n";
        string = string + " inExp = Utilities.getExperimentsForApplication(app)\n";
        string = string + " for exp in inExp:\n";
        string = string + "   trials = Utilities.getTrialsForExperiment(app, exp.getName())\n";
        string = string + "   for trial in trials:\n";
        string = string + "      result = load(app,exp.getName(),trial.getName())\n";
        string = string + "      computeDerived(result)\n";
        string = string + "\n";
        string = string + "print \"---------------- JPython test script end -------------\"\n";
        return string;
    }

    private static String initScript() {
        String string = "from edu.uoregon.tau.perfexplorer.glue import *\n";
        string = string + PerfExplorerExpression.loadMethod();
        string = string + PerfExplorerExpression.addDerivedOperation();
        string = string + PerfExplorerExpression.addScaledOperation();
        string = string + PerfExplorerExpression.computeDerived();
        return string;
    }

    private static String loadMethod() {
        String string = "\n";
        string = string + "def load(inApp, inExp, inTrial):\n";
        string = string + spaces + "trial1 = Utilities.getTrial(inApp, inExp, inTrial)\n";
        string = string + spaces + "result1 = TrialResult(trial1)\n";
        string = string + spaces + "return result1\n";
        string = string + "\n";
        return string;
    }

    private static final String addDerivedOperation() {
        String string = "";
        string = string + "def addDerivedOperation(result, metric1, metric2, op, newName=\"\"):\n";
        string = string + spaces + "# derive the metric\n";
        string = string + spaces + "derivor = DeriveMetricOperation(result, metric1, metric2, op)\n";
        string = string + spaces + "if newName:\n";
        string = string + spaces + "      derivor.setNewName(newName)\n";
        string = string + spaces + "\n";
        string = string + spaces + "derived = derivor.processData().get(0)\n";
        string = string + spaces + "newName = derived.getMetrics().toArray()[0]\n";
        string = string + spaces + "merger = MergeTrialsOperation(result)\n";
        string = string + spaces + "merger.addInput(derived)\n";
        string = string + spaces + "derived = merger.processData().get(0)\n";
        string = string + spaces + "return derived, newName\n";
        string = string + "\n";
        return string;
    }

    private static final String addScaledOperation() {
        String string = "def addScaledOperation(result, metric1, scale, op, newName=\"\"):\n";
        string = string + spaces + "# derive the metric\n";
        string = string + spaces + "scaled = ScaleMetricOperation(result, metric1, scale, op)\n";
        string = string + spaces + "if newName:\n";
        string = string + spaces + "        scaled.setNewName(newName)\n";
        string = string + spaces + "scaled = scaled.processData().get(0)\n";
        string = string + spaces + "newName = scaled.getMetrics().toArray()[0]\n";
        string = string + "\n";
        string = string + spaces + "merger = MergeTrialsOperation(result)\n";
        string = string + spaces + "merger.addInput(scaled)\n";
        string = string + spaces + "scaled = merger.processData().get(0)\n";
        string = string + spaces + "return scaled, newName\n";
        string = string + "\n";
        return string;
    }

    private static final String computeDerived() {
        return "def computeDerived(result):\n";
    }

    private static String addApplicaitons() {
        String string = "apps = [";
        PerfExplorerServer perfExplorerServer = PerfExplorerServer.getServer();
        List<Application> list = perfExplorerServer.getApplicationList();
        for (Application application : list) {
            string = string + "'" + application.getName() + "'";
        }
        if (string.charAt(string.length() - 1) == ',') {
            string = string.substring(0, string.length() - 1);
        }
        return string + "]\n";
    }

    protected String applyOperation(String string, String string2, char c) {
        this.script = this.script + spaces + "result, newName = addDerivedOperation( result,";
        this.script = this.script + "\"" + string + "\"" + "," + "\"" + string2 + "\"" + ", " + this.getDeriveOper(c) + ")\n";
        return "(" + string + c + string2 + ")";
    }

    protected String applyOperation(String string, double d, char c) {
        this.script = this.script + spaces + "result, newName = addScaledOperation( result,";
        this.script = this.script + "\"" + string + "\"" + "," + d + ", " + this.getDeriveOper(c) + ")\n";
        return "(" + string + c + d + ")";
    }

    protected String applyOperation(double d, String string, char c) {
        this.script = this.script + spaces + "result, newName = addScaledOperation( result,";
        this.script = this.script + "\"" + d + "\"" + "," + "\"" + string + "\"" + ", " + this.getDeriveOper(c) + ")\n";
        return "(" + d + c + string + ")";
    }

    protected String applyOperation(String string, String string2, char c, String string3) {
        this.script = this.script + spaces + "result, newName = addDerivedOperation( result,";
        this.script = this.script + "\"" + string + "\"" + "," + "\"" + string2 + "\"" + ", " + this.getDeriveOper(c) + ",\"" + string3.trim() + "\"" + ")\n";
        return "(" + string + c + string2 + ")";
    }

    protected String applyOperation(String string, double d, char c, String string2) {
        this.script = this.script + spaces + "result, newName = addScaledOperation( result,";
        this.script = this.script + "\"" + string + "\"" + "," + d + ", " + this.getDeriveOper(c) + ",\"" + string2 + "\"" + ")\n";
        return "(" + string + c + d + ")";
    }

    protected String applyOperation(double d, String string, char c, String string2) {
        this.script = this.script + spaces + "result, newName = addScaledOperation( result,";
        this.script = this.script + d + "," + "\"" + string + "\"" + ", " + this.getDeriveOper(c) + ",\"" + string2 + "\"" + ")\n";
        return "(" + d + c + string + ")";
    }

    protected String rename(String string, String string2) {
        return this.applyOperation(0.0, string2, '+', string);
    }
}

