/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.client;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerChartWindow;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerConnection;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.perfexplorer.common.ChartDataType;
import edu.uoregon.tau.perfexplorer.common.RMIChartData;
import edu.uoregon.tau.perfexplorer.common.RMISortableIntervalEvent;
import java.awt.Toolkit;
import java.net.URL;
import java.util.List;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class PerfExplorerHistogramChart
extends PerfExplorerChartWindow {
    private static final long serialVersionUID = -6247716923954756815L;

    public PerfExplorerHistogramChart(JFreeChart jFreeChart, String string) {
        super(jFreeChart, string);
    }

    public static JFrame doHistogram() {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        Object object = perfExplorerModel.getCurrentSelection();
        RMIChartData rMIChartData = null;
        rMIChartData = object instanceof RMISortableIntervalEvent ? perfExplorerConnection.requestChartData(perfExplorerModel, ChartDataType.DISTRIBUTION_DATA) : perfExplorerConnection.requestChartData(perfExplorerModel, ChartDataType.IQR_DATA);
        IntervalXYDataset intervalXYDataset = PerfExplorerHistogramChart.createDataset(rMIChartData);
        JFreeChart jFreeChart = PerfExplorerHistogramChart.createChart(intervalXYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setDisplayToolTips(true);
        XYItemRenderer xYItemRenderer = jFreeChart.getXYPlot().getRenderer();
        xYItemRenderer.setBaseToolTipGenerator(new XYToolTipGenerator(){

            public String generateToolTip(XYDataset xYDataset, int n, int n2) {
                return "<html>Event: " + xYDataset.getSeriesKey(n) + "<BR>Count: " + xYDataset.getYValue(n, n2) + "</html>";
            }
        });
        PerfExplorerHistogramChart perfExplorerHistogramChart = new PerfExplorerHistogramChart(jFreeChart, "Distributions of Significant Events");
        URL uRL = Utility.getResource((String)"tau32x32.gif");
        if (uRL != null) {
            perfExplorerHistogramChart.setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
        }
        return perfExplorerHistogramChart;
    }

    public static JFrame doHistogram(RMIChartData rMIChartData, String string) {
        IntervalXYDataset intervalXYDataset = PerfExplorerHistogramChart.createDataset(rMIChartData);
        JFreeChart jFreeChart = PerfExplorerHistogramChart.createChart(intervalXYDataset, string);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setDisplayToolTips(true);
        XYItemRenderer xYItemRenderer = jFreeChart.getXYPlot().getRenderer();
        xYItemRenderer.setBaseToolTipGenerator(new XYToolTipGenerator(){

            public String generateToolTip(XYDataset xYDataset, int n, int n2) {
                return "<html>Value: " + xYDataset.getSeriesKey(n) + "<BR>Count: " + xYDataset.getYValue(n, n2) + "</html>";
            }
        });
        PerfExplorerHistogramChart perfExplorerHistogramChart = new PerfExplorerHistogramChart(jFreeChart, "Distributions");
        URL uRL = Utility.getResource((String)"tau32x32.gif");
        if (uRL != null) {
            perfExplorerHistogramChart.setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
        }
        return perfExplorerHistogramChart;
    }

    private static IntervalXYDataset createDataset(RMIChartData rMIChartData) {
        HistogramDataset histogramDataset = new HistogramDataset();
        List<String> list = rMIChartData.getRowLabels();
        double[] dArray = null;
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            int n;
            double d;
            List<double[]> list2 = rMIChartData.getRowData(i);
            dArray = new double[list2.size()];
            double d2 = d = list2.get(0)[1];
            for (int j = 1; j < list2.size(); ++j) {
                if (d > list2.get(j)[1]) {
                    d = list2.get(j)[1];
                }
                if (!(d2 < list2.get(j)[1])) continue;
                d2 = list2.get(j)[1];
            }
            double d3 = d2 - d;
            for (n = 0; n < list2.size(); ++n) {
                dArray[n] = list2.get(n)[1];
            }
            n = 10;
            if (list2.size() >= 2098) {
                n = 200;
            } else if (list2.size() >= 256) {
                n = 50;
            } else if (list2.size() >= 16) {
                n = 20;
            }
            histogramDataset.addSeries((Comparable)((Object)list.get(i)), dArray, n);
        }
        return histogramDataset;
    }

    private static IntervalXYDataset createDataset() {
        HistogramDataset histogramDataset = new HistogramDataset();
        double[] dArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        histogramDataset.addSeries((Comparable)((Object)"H1"), dArray, 10, 0.0, 10.0);
        return histogramDataset;
    }

    private static JFreeChart createChart(IntervalXYDataset intervalXYDataset) {
        JFreeChart jFreeChart = ChartFactory.createHistogram((String)"TAU/PerfExplorer: Significant (>2.0% of runtime) Event Histograms", (String)"Percentiles", (String)"Count", (IntervalXYDataset)intervalXYDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        NumberAxis numberAxis = new NumberAxis("Percentiles");
        numberAxis.setRange(new Range(0.0, 1.0));
        jFreeChart.getXYPlot().setDomainAxis(0, (ValueAxis)numberAxis);
        jFreeChart.getXYPlot().setForegroundAlpha(0.75f);
        return jFreeChart;
    }

    private static JFreeChart createChart(IntervalXYDataset intervalXYDataset, String string) {
        JFreeChart jFreeChart = ChartFactory.createHistogram((String)string, (String)"Size", (String)"Count", (IntervalXYDataset)intervalXYDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        return jFreeChart;
    }
}

