/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.clustering.weka;

import edu.uoregon.tau.perfexplorer.clustering.ClusterDescription;
import edu.uoregon.tau.perfexplorer.clustering.ClusterException;
import edu.uoregon.tau.perfexplorer.clustering.DendrogramTree;
import edu.uoregon.tau.perfexplorer.clustering.DistanceMatrix;
import edu.uoregon.tau.perfexplorer.clustering.HierarchicalCluster;
import edu.uoregon.tau.perfexplorer.clustering.RawDataInterface;
import edu.uoregon.tau.perfexplorer.clustering.weka.WekaRawData;
import edu.uoregon.tau.perfexplorer.common.PerfExplorerOutput;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import weka.core.Instance;
import weka.core.Instances;

public class JavaHierarchicalCluster
implements HierarchicalCluster {
    private DistanceMatrix distances = null;
    private int dimension = 0;
    private LinkedHashSet<Integer> remainingIndices = null;
    private DendrogramTree[] trees = null;
    private DendrogramTree root = null;
    private DendrogramTree[] clusters = null;
    private List<Integer>[] clusterIndexes = null;
    private int k = 0;
    private Instances instances = null;
    private Instances clusterCentroids = null;
    private Instances clusterMaximums = null;
    private Instances clusterMinimums = null;
    private Instances clusterStandardDeviations = null;
    private int[] clusterSizes = null;
    private RawDataInterface inputData = null;

    JavaHierarchicalCluster(DistanceMatrix distanceMatrix) {
        this.distances = new DistanceMatrix(distanceMatrix);
    }

    public JavaHierarchicalCluster() {
    }

    public DendrogramTree buildDendrogramTree() {
        if (this.distances == null) {
            this.distances = new DistanceMatrix(this.inputData.numVectors());
            this.distances.solveCartesianDistances(this.inputData);
        }
        this.dimension = this.distances.getDimension();
        this.remainingIndices = new LinkedHashSet(this.dimension);
        this.trees = new DendrogramTree[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            this.remainingIndices.add(new Integer(i));
            this.trees[i] = new DendrogramTree(-1 - i, 0.0);
        }
        DendrogramTree dendrogramTree = null;
        boolean bl = false;
        while (this.remainingIndices.size() > 1) {
            boolean bl2 = true;
            double d = 0.0;
            int[] nArray = new int[]{0, 0};
            for (int i = 0; i < this.dimension; ++i) {
                if (!this.remainingIndices.contains(new Integer(i))) continue;
                for (int j = 0; j < i; ++j) {
                    if (!this.remainingIndices.contains(new Integer(j))) continue;
                    if (bl2) {
                        bl2 = false;
                        d = this.distances.elementAt(i, j);
                        nArray[0] = i;
                        nArray[1] = j;
                        continue;
                    }
                    if (!(d > this.distances.elementAt(i, j))) continue;
                    d = this.distances.elementAt(i, j);
                    nArray[0] = i;
                    nArray[1] = j;
                }
            }
            this.remainingIndices.remove(new Integer(nArray[0]));
            dendrogramTree = new DendrogramTree(nArray[1], d);
            dendrogramTree.setLeftAndRight(this.trees[nArray[1]], this.trees[nArray[0]]);
            this.trees[nArray[1]] = dendrogramTree;
            this.distances.mergeDistances(nArray[1], nArray[0]);
        }
        this.root = dendrogramTree;
        return dendrogramTree;
    }

    public int clusterInstance(int n) {
        int n2 = 0;
        if (this.clusters == null) {
            try {
                this.findClusters();
            }
            catch (ClusterException clusterException) {
                System.err.println("Error clustering");
                clusterException.printStackTrace();
            }
        }
        ++n;
        for (int i = 0; i < this.k; ++i) {
            if (!this.isInTree(n, this.clusters[i])) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    private boolean isInTree(int n, DendrogramTree dendrogramTree) {
        if (dendrogramTree.isLeaf()) {
            return Math.abs(dendrogramTree.getID()) == n;
        }
        return this.isInTree(n, dendrogramTree.getLeft()) || this.isInTree(n, dendrogramTree.getRight());
    }

    public int[] clusterInstances() {
        if (this.clusters == null) {
            try {
                this.findClusters();
            }
            catch (ClusterException clusterException) {
                System.err.print("Error clustering data");
                clusterException.printStackTrace();
            }
        }
        int[] nArray = new int[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            nArray[i] = this.clusterInstance(i);
        }
        return nArray;
    }

    public void findClusters() throws ClusterException {
        if (this.root == null) {
            this.buildDendrogramTree();
        }
        this.clusters = new DendrogramTree[this.k];
        this.clusters[0] = this.root;
        for (int i = 1; i < this.k; ++i) {
            double d = this.clusters[0].getHeight();
            int n = 0;
            for (int j = 0; j < i; ++j) {
                if (!(this.clusters[j].getHeight() > d)) continue;
                d = this.clusters[j].getHeight();
                n = j;
            }
            this.clusters[i] = this.clusters[n].getRight();
            this.clusters[n] = this.clusters[n].getLeft();
        }
    }

    public RawDataInterface getClusterCentroids() {
        if (this.clusterCentroids == null) {
            this.generateStats();
        }
        WekaRawData wekaRawData = new WekaRawData(this.clusterCentroids);
        return wekaRawData;
    }

    private void generateStats() {
        if (this.clusterSizes == null) {
            this.getClusterSizes();
        }
        if (this.instances == null) {
            this.instances = (Instances)this.inputData.getData();
        }
        this.clusterCentroids = new Instances(this.instances, this.clusters.length);
        this.clusterMaximums = new Instances(this.instances, this.clusters.length);
        this.clusterMinimums = new Instances(this.instances, this.clusters.length);
        this.clusterStandardDeviations = new Instances(this.instances, this.clusters.length);
        for (int i = 0; i < this.clusters.length; ++i) {
            double d;
            int n;
            Instance instance;
            int n2 = this.instances.firstInstance().numAttributes();
            double[] dArray = new double[n2];
            Instance instance2 = new Instance(1.0, dArray);
            Instance instance3 = new Instance(1.0, dArray);
            Instance instance4 = new Instance(1.0, dArray);
            Instance instance5 = new Instance(1.0, dArray);
            Instance instance6 = new Instance(1.0, dArray);
            boolean bl = true;
            for (Integer n3 : this.clusterIndexes[i]) {
                instance = this.instances.instance(n3.intValue());
                for (n = 0; n < n2; ++n) {
                    d = instance.value(n);
                    instance2.setValue(n, instance2.value(n) + d);
                    instance4.setValue(n, Math.max(instance4.value(n), d));
                    if (bl) {
                        instance3.setValue(n, d);
                        continue;
                    }
                    instance3.setValue(n, Math.min(instance3.value(n), d));
                }
                bl = false;
            }
            for (int j = 0; j < n2; ++j) {
                instance5.setValue(j, instance2.value(j) / (double)this.clusterSizes[i]);
            }
            this.clusterCentroids.add(instance5);
            this.clusterMaximums.add(instance4);
            this.clusterMinimums.add(instance3);
            for (Integer n3 : this.clusterIndexes[i]) {
                instance = this.instances.instance(n3.intValue());
                for (n = 0; n < n2; ++n) {
                    d = instance.value(n);
                    instance6.setValue(n, instance6.value(n) + Math.pow(instance5.value(n) - d, 2.0));
                }
            }
            for (int j = 0; j < n2; ++j) {
                instance6.setValue(j, Math.sqrt(instance6.value(j)));
            }
            this.clusterStandardDeviations.add(instance6);
        }
    }

    public ClusterDescription getClusterDescription(int n) throws ClusterException {
        return null;
    }

    public RawDataInterface getClusterMaximums() {
        if (this.clusterMaximums == null) {
            this.generateStats();
        }
        WekaRawData wekaRawData = new WekaRawData(this.clusterMaximums);
        return wekaRawData;
    }

    public RawDataInterface getClusterMinimums() {
        if (this.clusterMinimums == null) {
            this.generateStats();
        }
        WekaRawData wekaRawData = new WekaRawData(this.clusterMinimums);
        return wekaRawData;
    }

    public int[] getClusterSizes() {
        if (this.clusterSizes == null) {
            this.clusterSizes = new int[this.clusters.length];
            if (this.clusterIndexes == null) {
                this.clusterIndexes = new List[this.clusters.length];
            }
            for (int i = 0; i < this.clusters.length; ++i) {
                if (this.clusterIndexes[i] == null) {
                    this.clusterIndexes[i] = this.clusters[i].getIndexes();
                }
                this.clusterSizes[i] = this.clusterIndexes[i].size();
            }
        }
        return this.clusterSizes;
    }

    public RawDataInterface getClusterStandardDeviations() {
        if (this.clusterStandardDeviations == null) {
            this.generateStats();
        }
        WekaRawData wekaRawData = new WekaRawData(this.clusterStandardDeviations);
        return wekaRawData;
    }

    public int getK() {
        return this.k;
    }

    public int getNumInstances() {
        return this.trees.length;
    }

    public void reset() {
        this.clusters = null;
        this.clusterCentroids = null;
        this.clusterMaximums = null;
        this.clusterMinimums = null;
        this.clusterStandardDeviations = null;
        this.clusterSizes = null;
        this.clusterIndexes = null;
    }

    public void setInputData(RawDataInterface rawDataInterface) {
        this.inputData = rawDataInterface;
    }

    public void setK(int n) {
        this.k = n;
    }

    public static void main(String[] stringArray) {
        int n = 2;
        int n2 = 4;
        int n3 = 3 * n2;
        ArrayList<String> arrayList = new ArrayList<String>(n3);
        arrayList.add("x");
        arrayList.add("y");
        WekaRawData wekaRawData = new WekaRawData("test", arrayList, n3, n, null);
        for (int i = 0; i < n3; ++i) {
            int n4 = i % n2;
            System.out.print("modval: " + n4);
            for (int j = 0; j < n; ++j) {
                double d = 0.5 + Math.random() / 10.0 + (double)n4;
                System.out.print(" val[" + j + "]: " + d);
                wekaRawData.addValue(i, j, d);
            }
            System.out.println("");
        }
        DistanceMatrix distanceMatrix = new DistanceMatrix(n3);
        distanceMatrix.solveManhattanDistances(wekaRawData);
        PerfExplorerOutput.println("Got Distances...");
        JavaHierarchicalCluster javaHierarchicalCluster = new JavaHierarchicalCluster(distanceMatrix);
        DendrogramTree dendrogramTree = javaHierarchicalCluster.buildDendrogramTree();
        PerfExplorerOutput.println("\n\n" + dendrogramTree.toString());
        javaHierarchicalCluster = new JavaHierarchicalCluster();
        javaHierarchicalCluster.setInputData(wekaRawData);
        javaHierarchicalCluster.setK(n2);
        int[] nArray = javaHierarchicalCluster.clusterInstances();
        for (int i = 0; i < n3; ++i) {
            System.out.println("Instance " + i + " is in cluster: " + nArray[i]);
        }
    }
}

