/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.common;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class AlignedStackedBarRenderer
extends StackedBarRenderer {
    private boolean renderAsPercentages = false;
    private boolean didAlign = false;
    private double[] rowBases;

    public AlignedStackedBarRenderer() {
        this(false);
    }

    public AlignedStackedBarRenderer(boolean bl) {
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER);
        this.setBasePositiveItemLabelPosition(itemLabelPosition);
        this.setBaseNegativeItemLabelPosition(itemLabelPosition);
        this.setPositiveItemLabelPositionFallback(null);
        this.setNegativeItemLabelPositionFallback(null);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AlignedStackedBarRenderer)) {
            return false;
        }
        AlignedStackedBarRenderer alignedStackedBarRenderer = (AlignedStackedBarRenderer)((Object)object);
        if (this.renderAsPercentages != alignedStackedBarRenderer.renderAsPercentages) {
            return false;
        }
        return super.equals(object);
    }

    private void initAlignment(CategoryDataset categoryDataset) {
        int n = categoryDataset.getColumnCount();
        int n2 = categoryDataset.getRowCount();
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                Number number = categoryDataset.getValue(i, j);
                double d2 = number == null ? 0.0 : number.doubleValue();
                d = Math.max(d, d2);
            }
            dArray[i] = d * 0.7;
        }
        this.rowBases = new double[n2];
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            d = i == 0 ? 0.0 : this.rowBases[i - 1];
            this.rowBases[i] = dArray[i] + d;
        }
        this.didAlign = true;
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        CategoryItemLabelGenerator categoryItemLabelGenerator;
        double d;
        double d2;
        double d3;
        Number number;
        if (!this.didAlign) {
            this.initAlignment(categoryDataset);
        }
        if ((number = categoryDataset.getValue(n, n2)) == null) {
            return;
        }
        double d4 = number.doubleValue() * 0.7;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d5 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        double d6 = d3 = this.getBase();
        double d7 = 0.0;
        if (n > 0) {
            d7 = this.rowBases[n - 1];
        }
        d3 = Math.max(this.getBase(), d7);
        d6 = Math.min(this.getBase(), d7);
        boolean bl = d4 > 0.0;
        boolean bl2 = valueAxis.isInverted();
        RectangleEdge rectangleEdge = plotOrientation == PlotOrientation.HORIZONTAL ? (bl && bl2 || !bl && !bl2 ? RectangleEdge.RIGHT : RectangleEdge.LEFT) : (bl && !bl2 || !bl && bl2 ? RectangleEdge.BOTTOM : RectangleEdge.TOP);
        RectangleEdge rectangleEdge2 = categoryPlot.getRangeAxisEdge();
        if (bl) {
            d2 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge2);
            d = valueAxis.valueToJava2D(d3 + d4, rectangle2D, rectangleEdge2);
        } else {
            d2 = valueAxis.valueToJava2D(d6, rectangle2D, rectangleEdge2);
            d = valueAxis.valueToJava2D(d6 + d4, rectangle2D, rectangleEdge2);
        }
        double d8 = Math.min(d2, d);
        double d9 = Math.max(Math.abs(d - d2), this.getMinimumBarLength());
        Rectangle2D.Double double_ = null;
        double_ = plotOrientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(d8, d5, d9, categoryItemRendererState.getBarWidth()) : new Rectangle2D.Double(d5, d8, categoryItemRendererState.getBarWidth(), d9);
        if (n3 == 0) {
            if (this.getShadowsVisible()) {
                boolean bl3 = bl && d3 == this.getBase() || !bl && d6 == this.getBase();
                this.getBarPainter().paintBarShadow(graphics2D, (BarRenderer)this, n, n2, (RectangularShape)double_, rectangleEdge, bl3);
            }
        } else if (n3 == 1) {
            this.getBarPainter().paintBar(graphics2D, (BarRenderer)this, n, n2, (RectangularShape)double_, rectangleEdge);
            EntityCollection entityCollection = categoryItemRendererState.getEntityCollection();
            if (entityCollection != null) {
                this.addItemEntity(entityCollection, categoryDataset, n, n2, double_);
            }
        } else if (n3 == 2 && (categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_, d4 < 0.0);
        }
    }
}

