/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.common;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfexplorer.common.ConsoleOutputStream;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class Console
extends JFrame {
    JTextPane textPane = new JTextPane();
    private PrintStream out = null;
    private PrintStream err = null;
    private PrintStream oldOut = System.out;
    private PrintStream oldErr = System.err;
    private Document doc = null;
    private SimpleAttributeSet errorStyle = null;
    private SimpleAttributeSet outputStyle = null;

    public Console() throws IOException {
        super("PerfExplorer Console");
        ConsoleOutputStream consoleOutputStream = new ConsoleOutputStream(this, false);
        this.out = new PrintStream(consoleOutputStream, true);
        System.setOut(this.out);
        ConsoleOutputStream consoleOutputStream2 = new ConsoleOutputStream(this, true);
        this.err = new PrintStream(consoleOutputStream2, true);
        System.setErr(this.err);
        this.textPane.setEditable(false);
        this.getContentPane().add((Component)new JScrollPane(this.textPane), "Center");
        this.setPreferredSize(new Dimension(800, 600));
        this.pack();
        this.setVisible(true);
        URL uRL = Utility.getResource((String)"tau32x32.gif");
        if (uRL != null) {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
        }
        this.doc = this.textPane.getDocument();
        this.errorStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.errorStyle, Color.red);
        this.outputStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.outputStyle, Color.black);
    }

    public void print(boolean bl, String string) {
        SimpleAttributeSet simpleAttributeSet = this.outputStyle;
        if (bl) {
            simpleAttributeSet = this.errorStyle;
        }
        try {
            this.doc.insertString(this.doc.getLength(), string, simpleAttributeSet);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.textPane.setCaretPosition(this.textPane.getDocument().getLength());
    }
}

