/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.common;

import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.IntervalEvent;
import edu.uoregon.tau.perfdmf.IntervalLocationProfile;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.FieldPosition;

public class RMISortableIntervalEvent
extends IntervalEvent
implements Serializable,
Comparable {
    public int metricIndex;

    public RMISortableIntervalEvent(IntervalEvent intervalEvent, DatabaseAPI databaseAPI, int n) {
        super(databaseAPI);
        this.setID(intervalEvent.getID());
        this.setName(intervalEvent.getName());
        this.setGroup(intervalEvent.getGroup());
        this.setTrialID(intervalEvent.getTrialID());
        try {
            this.setMeanSummary(intervalEvent.getMeanSummary());
            this.setTotalSummary(intervalEvent.getTotalSummary());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.metricIndex = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            DecimalFormat decimalFormat = new DecimalFormat("00.00");
            FieldPosition fieldPosition = new FieldPosition(0);
            decimalFormat.format(this.getMeanSummary().getExclusivePercentage(this.metricIndex), stringBuffer, fieldPosition);
            stringBuffer.append("%");
        }
        catch (Exception exception) {
            // empty catch block
        }
        stringBuffer.append(" : ");
        stringBuffer.append(this.getName());
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        IntervalEvent intervalEvent = (IntervalEvent)object;
        IntervalLocationProfile intervalLocationProfile = null;
        IntervalLocationProfile intervalLocationProfile2 = null;
        try {
            intervalLocationProfile = this.getMeanSummary();
            intervalLocationProfile2 = intervalEvent.getMeanSummary();
        }
        catch (Exception exception) {
            return 0;
        }
        if (intervalLocationProfile.getExclusive(this.metricIndex) < intervalLocationProfile2.getExclusive(this.metricIndex)) {
            return 1;
        }
        if (intervalLocationProfile.getExclusive(this.metricIndex) > intervalLocationProfile2.getExclusive(this.metricIndex)) {
            return -1;
        }
        return 0;
    }
}

