/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.PerformanceAnalysisOperation;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.glue.Provenance;
import edu.uoregon.tau.perfexplorer.glue.TrialResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPerformanceOperation
implements PerformanceAnalysisOperation,
Serializable {
    private Long id;
    protected List<PerformanceResult> inputs = null;
    protected List<PerformanceResult> outputs = null;

    protected AbstractPerformanceOperation() {
        Provenance.addOperation(this);
    }

    protected AbstractPerformanceOperation(PerformanceResult performanceResult) {
        if (performanceResult == null) {
            System.err.println("\n\n *** ERROR: Input Trial is null. ***\n\n");
        }
        this.setInput(performanceResult);
        this.outputs = new ArrayList<PerformanceResult>();
        Provenance.addOperation(this);
    }

    protected AbstractPerformanceOperation(Trial trial) {
        TrialResult trialResult = new TrialResult(trial);
        this.setInput(trialResult);
        this.outputs = new ArrayList<PerformanceResult>();
        Provenance.addOperation(this);
    }

    protected AbstractPerformanceOperation(List<PerformanceResult> list) {
        this.setInputs(list);
        this.outputs = new ArrayList<PerformanceResult>();
        Provenance.addOperation(this);
    }

    @Override
    public List<PerformanceResult> getInputs() {
        return this.inputs;
    }

    @Override
    public void setInputs(List<PerformanceResult> list) {
        this.inputs = list;
    }

    public void setInputsTrials(List<Trial> list) {
        this.inputs = new ArrayList<PerformanceResult>();
        for (Trial trial : list) {
            TrialResult trialResult = new TrialResult(trial);
            this.addInput(trialResult);
        }
    }

    @Override
    public void setInput(PerformanceResult performanceResult) {
        this.inputs = new ArrayList<PerformanceResult>();
        this.inputs.add(performanceResult);
    }

    public void setInput(Trial trial) {
        this.inputs = new ArrayList<PerformanceResult>();
        TrialResult trialResult = new TrialResult(trial);
        this.inputs.add(trialResult);
    }

    @Override
    public void addInput(PerformanceResult performanceResult) {
        this.inputs.add(performanceResult);
    }

    public void addInput(Trial trial) {
        TrialResult trialResult = new TrialResult(trial);
        this.inputs.add(trialResult);
    }

    @Override
    public List<PerformanceResult> getOutputs() {
        return this.outputs;
    }

    @Override
    public void setOutputs(List<PerformanceResult> list) {
        this.outputs = list;
    }

    @Override
    public PerformanceResult getOutputAtIndex(int n) {
        return this.outputs.get(n);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public void reset() {
        this.outputs.clear();
    }
}

