/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.glue.Utilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResult
implements PerformanceResult,
Serializable {
    protected Set<Integer> threads = new TreeSet<Integer>();
    protected Set<String> events = new TreeSet<String>();
    protected Set<String> metrics = new TreeSet<String>();
    protected Set<String> userEvents = new TreeSet<String>();
    protected Map<Integer, Map<String, Map<String, Double>>> inclusiveData = new HashMap<Integer, Map<String, Map<String, Double>>>();
    protected Map<Integer, Map<String, Map<String, Double>>> exclusiveData = new HashMap<Integer, Map<String, Map<String, Double>>>();
    protected Map<Integer, Map<String, Double>> callData = new HashMap<Integer, Map<String, Double>>();
    protected Map<Integer, Map<String, Double>> subroutineData = new HashMap<Integer, Map<String, Double>>();
    protected Map<Integer, Map<String, Double[]>> usereventData = new HashMap<Integer, Map<String, Double[]>>();
    public static final int INCLUSIVE = 0;
    public static final int EXCLUSIVE = 1;
    public static final int CALLS = 2;
    public static final int SUBROUTINES = 3;
    public static final int USEREVENT_NUMEVENTS = 4;
    public static final int USEREVENT_MAX = 5;
    public static final int USEREVENT_MIN = 6;
    public static final int USEREVENT_MEAN = 7;
    public static final int USEREVENT_SUMSQR = 8;
    private static List<Integer> types = null;
    protected String mainEvent = null;
    protected double mainInclusive = 0.0;
    protected String mainMetric = null;
    protected Trial trial = null;
    protected DataSource dataSource = null;
    protected Integer trialID = null;
    protected Map<Integer, String> eventMap = new HashMap<Integer, String>();
    protected String name = null;
    protected boolean ignoreWarnings = false;
    protected int originalThreads = 0;

    public static List<Integer> getTypes() {
        return AbstractResult.getTypes(true);
    }

    public static List<Integer> getTypes(boolean bl) {
        if (types == null) {
            types = new ArrayList<Integer>();
            types.add(0);
            types.add(1);
            types.add(2);
            types.add(3);
            if (bl) {
                types.add(4);
                types.add(5);
                types.add(6);
                types.add(7);
                types.add(8);
            }
        }
        return types;
    }

    public static String typeToString(int n) {
        switch (n) {
            case 0: {
                return "INCLUSIVE";
            }
            case 1: {
                return "EXCLUSIVE";
            }
            case 2: {
                return "CALLS";
            }
            case 3: {
                return "SUBROUTINES";
            }
            case 4: {
                return "USEREVENT_NUMEVENTS";
            }
            case 5: {
                return "USEREVENT_MAX";
            }
            case 6: {
                return "USEREVENT_MIN";
            }
            case 7: {
                return "USEREVENT_MEAN";
            }
            case 8: {
                return "USEREVENT_SUMSQR";
            }
        }
        return "";
    }

    protected AbstractResult() {
    }

    public AbstractResult(PerformanceResult performanceResult) {
        this.copyData(performanceResult);
        this.copyFields(performanceResult);
    }

    public AbstractResult(PerformanceResult performanceResult, boolean bl) {
        if (bl) {
            this.copyData(performanceResult);
        }
        this.copyFields(performanceResult);
    }

    private void copyData(PerformanceResult performanceResult) {
        for (Integer n : performanceResult.getThreads()) {
            for (String string : performanceResult.getEvents()) {
                for (String string2 : performanceResult.getMetrics()) {
                    this.putExclusive(n, string, string2, performanceResult.getExclusive(n, string, string2));
                    this.putInclusive(n, string, string2, performanceResult.getInclusive(n, string, string2));
                }
                this.putCalls(n, string, performanceResult.getCalls(n, string));
                this.putSubroutines(n, string, performanceResult.getSubroutines(n, string));
            }
            for (String string : performanceResult.getUserEvents()) {
                this.putDataPoint(n, string, null, 4, this.getDataPoint(n, string, null, 4));
                this.putDataPoint(n, string, null, 5, this.getDataPoint(n, string, null, 5));
                this.putDataPoint(n, string, null, 6, this.getDataPoint(n, string, null, 6));
                this.putDataPoint(n, string, null, 7, this.getDataPoint(n, string, null, 7));
                this.putDataPoint(n, string, null, 8, this.getDataPoint(n, string, null, 8));
            }
        }
    }

    private void copyFields(PerformanceResult performanceResult) {
        this.eventMap = performanceResult.getEventMap();
        this.mainEvent = performanceResult.getMainEvent();
        this.dataSource = performanceResult.getDataSource();
        this.trial = performanceResult.getTrial();
        this.trialID = performanceResult.getTrialID();
        this.eventMap = performanceResult.getEventMap();
        this.name = performanceResult.getName();
    }

    @Override
    public void putInclusive(Integer n, String string, String string2, double d) {
        if (!this.threads.contains(n)) {
            this.threads.add(n);
        }
        if (!this.events.contains(string)) {
            this.events.add(string);
        }
        if (!this.metrics.contains(string2)) {
            this.metrics.add(string2);
        }
        if (!this.inclusiveData.containsKey(n)) {
            this.inclusiveData.put(n, new HashMap());
        }
        if (!this.inclusiveData.get(n).containsKey(string)) {
            this.inclusiveData.get(n).put(string, new HashMap());
        }
        this.inclusiveData.get(n).get(string).put(string2, d);
        if (d > this.mainInclusive && !string.contains(" => ") && (this.mainMetric == null || this.mainMetric.equals(string2))) {
            this.mainInclusive = d;
            this.mainEvent = string;
            this.mainMetric = string2;
        }
    }

    @Override
    public void putExclusive(Integer n, String string, String string2, double d) {
        if (!this.threads.contains(n)) {
            this.threads.add(n);
        }
        if (!this.events.contains(string)) {
            this.events.add(string);
        }
        if (!this.metrics.contains(string2)) {
            this.metrics.add(string2);
        }
        if (!this.exclusiveData.containsKey(n)) {
            this.exclusiveData.put(n, new HashMap());
        }
        if (!this.exclusiveData.get(n).containsKey(string)) {
            this.exclusiveData.get(n).put(string, new HashMap());
        }
        this.exclusiveData.get(n).get(string).put(string2, d);
    }

    @Override
    public void putCalls(Integer n, String string, double d) {
        if (!this.threads.contains(n)) {
            this.threads.add(n);
        }
        if (!this.events.contains(string)) {
            this.events.add(string);
        }
        if (!this.callData.containsKey(n)) {
            this.callData.put(n, new HashMap());
        }
        this.callData.get(n).put(string, d);
    }

    @Override
    public void putSubroutines(Integer n, String string, double d) {
        if (!this.threads.contains(n)) {
            this.threads.add(n);
        }
        if (!this.events.contains(string)) {
            this.events.add(string);
        }
        if (!this.subroutineData.containsKey(n)) {
            this.subroutineData.put(n, new HashMap());
        }
        this.subroutineData.get(n).put(string, d);
    }

    @Override
    public void putUsereventNumevents(Integer n, String string, double d) {
        Double[] doubleArray;
        if (!this.threads.contains(n)) {
            this.threads.add(n);
        }
        if (!this.userEvents.contains(string)) {
            this.userEvents.add(string);
        }
        if (!this.usereventData.containsKey(n)) {
            this.usereventData.put(n, new HashMap());
        }
        if ((doubleArray = this.usereventData.get(n).get(string)) == null) {
            doubleArray = new Double[5];
        }
        doubleArray[0] = d;
        this.usereventData.get(n).put(string, doubleArray);
    }

    @Override
    public void putUsereventMax(Integer n, String string, double d) {
        Double[] doubleArray;
        if (!this.threads.contains(n)) {
            this.threads.add(n);
        }
        if (!this.userEvents.contains(string)) {
            this.userEvents.add(string);
        }
        if (!this.usereventData.containsKey(n)) {
            this.usereventData.put(n, new HashMap());
        }
        if ((doubleArray = this.usereventData.get(n).get(string)) == null) {
            doubleArray = new Double[5];
        }
        doubleArray[1] = d;
        this.usereventData.get(n).put(string, doubleArray);
    }

    @Override
    public void putUsereventMin(Integer n, String string, double d) {
        Double[] doubleArray;
        if (!this.threads.contains(n)) {
            this.threads.add(n);
        }
        if (!this.userEvents.contains(string)) {
            this.userEvents.add(string);
        }
        if (!this.usereventData.containsKey(n)) {
            this.usereventData.put(n, new HashMap());
        }
        if ((doubleArray = this.usereventData.get(n).get(string)) == null) {
            doubleArray = new Double[5];
        }
        doubleArray[2] = d;
        this.usereventData.get(n).put(string, doubleArray);
    }

    @Override
    public void putUsereventMean(Integer n, String string, double d) {
        Double[] doubleArray;
        if (!this.threads.contains(n)) {
            this.threads.add(n);
        }
        if (!this.userEvents.contains(string)) {
            this.userEvents.add(string);
        }
        if (!this.usereventData.containsKey(n)) {
            this.usereventData.put(n, new HashMap());
        }
        if ((doubleArray = this.usereventData.get(n).get(string)) == null) {
            doubleArray = new Double[5];
        }
        doubleArray[3] = d;
        this.usereventData.get(n).put(string, doubleArray);
    }

    @Override
    public void putUsereventSumsqr(Integer n, String string, double d) {
        Double[] doubleArray;
        if (!this.threads.contains(n)) {
            this.threads.add(n);
        }
        if (!this.userEvents.contains(string)) {
            this.userEvents.add(string);
        }
        if (!this.usereventData.containsKey(n)) {
            this.usereventData.put(n, new HashMap());
        }
        if ((doubleArray = this.usereventData.get(n).get(string)) == null) {
            doubleArray = new Double[5];
        }
        doubleArray[4] = d;
        this.usereventData.get(n).put(string, doubleArray);
    }

    @Override
    public double getInclusive(Integer n, String string, String string2) {
        Double d = null;
        try {
            d = this.inclusiveData.get(n).get(string).get(string2);
            if (d != null) {
                return d;
            }
        }
        catch (NullPointerException nullPointerException) {
            if (!this.ignoreWarnings) {
                System.err.println("*** Warning - null inclusive value for thread: " + n + ", event: " + string + ", metric: " + string2 + " ***");
            }
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public double getExclusive(Integer n, String string, String string2) {
        Double d = null;
        try {
            d = this.exclusiveData.get(n).get(string).get(string2);
            if (d != null) {
                return d;
            }
        }
        catch (NullPointerException nullPointerException) {
            if (!this.ignoreWarnings) {
                System.err.println("*** Warning - null exclusive value for thread: " + n + ", event: " + string + ", metric: " + string2 + " ***");
            }
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public double getCalls(Integer n, String string) {
        Double d = null;
        try {
            d = this.callData.get(n).get(string);
            if (d != null) {
                return d;
            }
        }
        catch (NullPointerException nullPointerException) {
            if (!this.ignoreWarnings) {
                System.err.println("*** Warning - null calls value for thread: " + n + ", event: " + string + " ***");
            }
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public double getSubroutines(Integer n, String string) {
        Double d = null;
        try {
            d = this.callData.get(n).get(string);
            if (d != null) {
                return d;
            }
        }
        catch (NullPointerException nullPointerException) {
            if (!this.ignoreWarnings) {
                System.err.println("*** Warning - null subroutine value for thread: " + n + ", event: " + string + " ***");
            }
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public double getUsereventNumevents(Integer n, String string) {
        Double[] doubleArray = null;
        try {
            doubleArray = this.usereventData.get(n).get(string);
            if (doubleArray != null) {
                return doubleArray[0];
            }
        }
        catch (NullPointerException nullPointerException) {
            if (!this.ignoreWarnings) {
                System.err.println("*** Warning - null userevent value for thread: " + n + ", event: " + string + " ***");
            }
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public double getUsereventMax(Integer n, String string) {
        Double[] doubleArray = null;
        try {
            doubleArray = this.usereventData.get(n).get(string);
            if (doubleArray != null) {
                return doubleArray[1];
            }
        }
        catch (NullPointerException nullPointerException) {
            if (!this.ignoreWarnings) {
                System.err.println("*** Warning - null userevent max value for thread: " + n + ", event: " + string + " ***");
            }
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public double getUsereventMin(Integer n, String string) {
        Double[] doubleArray = null;
        try {
            doubleArray = this.usereventData.get(n).get(string);
            if (doubleArray != null) {
                return doubleArray[2];
            }
        }
        catch (NullPointerException nullPointerException) {
            if (!this.ignoreWarnings) {
                System.err.println("*** Warning - null userevent min value for thread: " + n + ", event: " + string + " ***");
            }
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public double getUsereventMean(Integer n, String string) {
        Double[] doubleArray = null;
        try {
            doubleArray = this.usereventData.get(n).get(string);
            if (doubleArray != null) {
                return doubleArray[3];
            }
        }
        catch (NullPointerException nullPointerException) {
            if (!this.ignoreWarnings) {
                System.err.println("*** Warning - null userevent mean value for thread: " + n + ", event: " + string + " ***");
            }
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public double getUsereventSumsqr(Integer n, String string) {
        Double[] doubleArray = null;
        try {
            doubleArray = this.usereventData.get(n).get(string);
            if (doubleArray != null) {
                return doubleArray[4];
            }
        }
        catch (NullPointerException nullPointerException) {
            if (!this.ignoreWarnings) {
                System.err.println("*** Warning - null userevent sumsqr value for thread: " + n + ", event: " + string + " ***");
            }
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public Set<String> getEvents() {
        return this.events;
    }

    @Override
    public Set<String> getMetrics() {
        return this.metrics;
    }

    @Override
    public Set<Integer> getThreads() {
        return this.threads;
    }

    @Override
    public String getMainEvent() {
        return this.mainEvent;
    }

    @Override
    public Set<String> getUserEvents() {
        return this.userEvents;
    }

    @Override
    public Set<String> getUserEvents(Integer n) {
        Set<String> set;
        block2: {
            set = null;
            try {
                set = this.usereventData.get(n).keySet();
            }
            catch (NullPointerException nullPointerException) {
                if (this.ignoreWarnings) break block2;
                System.err.println("*** Warning - null userevent set for thread: " + n + " ***");
            }
        }
        return set;
    }

    @Override
    public Integer getOriginalThreads() {
        if (this.originalThreads == 0) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (this.trial != null) {
                n = Integer.parseInt(this.trial.getField("node_count"));
                n2 = Integer.parseInt(this.trial.getField("contexts_per_node"));
                n3 = Integer.parseInt(this.trial.getField("threads_per_context"));
            }
            if (n > 0) {
                this.originalThreads = n * n2 * n3;
            } else if (this.dataSource != null) {
                n3 = 0;
                n = this.dataSource.getNumberOfNodes();
                for (int i = 0; i < n; ++i) {
                    n2 = this.dataSource.getNumberOfContexts(i);
                    for (int j = 0; j < n2; ++j) {
                        n3 += this.dataSource.getNumberOfThreads(i, j);
                    }
                }
                this.originalThreads = n3;
            } else {
                this.originalThreads = this.threads.size();
            }
        }
        return this.originalThreads;
    }

    public void setOriginalThreads(Integer n) {
    }

    @Override
    public double getDataPoint(Integer n, String string, String string2, int n2) {
        switch (n2) {
            case 0: {
                return this.getInclusive(n, string, string2);
            }
            case 1: {
                return this.getExclusive(n, string, string2);
            }
            case 2: {
                return this.getCalls(n, string);
            }
            case 3: {
                return this.getSubroutines(n, string);
            }
            case 4: {
                return this.getUsereventNumevents(n, string);
            }
            case 5: {
                return this.getUsereventMax(n, string);
            }
            case 6: {
                return this.getUsereventMin(n, string);
            }
            case 7: {
                return this.getUsereventMean(n, string);
            }
            case 8: {
                return this.getUsereventSumsqr(n, string);
            }
        }
        return 0.0;
    }

    @Override
    public void putDataPoint(Integer n, String string, String string2, int n2, double d) {
        switch (n2) {
            case 0: {
                this.putInclusive(n, string, string2, d);
            }
            case 1: {
                this.putExclusive(n, string, string2, d);
            }
            case 2: {
                this.putCalls(n, string, d);
            }
            case 3: {
                this.putSubroutines(n, string, d);
            }
            case 4: {
                this.putUsereventNumevents(n, string, d);
            }
            case 5: {
                this.putUsereventMax(n, string, d);
            }
            case 6: {
                this.putUsereventMin(n, string, d);
            }
            case 7: {
                this.putUsereventMean(n, string, d);
            }
            case 8: {
                this.putUsereventSumsqr(n, string, d);
            }
        }
    }

    @Override
    public String getTimeMetric() {
        for (String string : this.metrics) {
            if (!string.toUpperCase().contains("TIME") || string.startsWith("(")) continue;
            return string;
        }
        if (!this.ignoreWarnings) {
            System.err.println("*** Warning - no time metric found in Trial ***");
        }
        for (String string : this.metrics) {
            if (string.toUpperCase().equals("PAPI_TOT_CYC")) {
                return string;
            }
            if (!string.toUpperCase().equals("CPU_CYCLES")) continue;
            return string;
        }
        return null;
    }

    @Override
    public String getFPMetric() {
        for (String string : this.metrics) {
            if (!string.toUpperCase().contains("PAPI_FP_") || string.startsWith("(")) continue;
            return string;
        }
        if (!this.ignoreWarnings) {
            System.err.println("*** Warning - no floating point metric found in Trial ***");
        }
        return null;
    }

    @Override
    public String getL1AccessMetric() {
        for (String string : this.metrics) {
            if (string.toUpperCase().contains("PAPI_L1_TCA") && !string.startsWith("(")) {
                return string;
            }
            if (!string.toUpperCase().contains("PAPI_L1_DCA") || string.startsWith("(")) continue;
            return string;
        }
        if (!this.ignoreWarnings) {
            System.err.println("*** Warning - no L1 access metric found in Trial ***");
        }
        return null;
    }

    @Override
    public String getL2AccessMetric() {
        for (String string : this.metrics) {
            if (string.toUpperCase().contains("PAPI_L2_TCA") && !string.startsWith("(")) {
                return string;
            }
            if (string.toUpperCase().contains("PAPI_L1_TCM") && !string.startsWith("(")) {
                return string;
            }
            if (string.toUpperCase().contains("PAPI_L2_DCA") && !string.startsWith("(")) {
                return string;
            }
            if (!string.toUpperCase().contains("PAPI_L1_DCM") || string.startsWith("(")) continue;
            return string;
        }
        if (!this.ignoreWarnings) {
            System.err.println("*** Warning - no L2 access metric found in Trial ***");
        }
        return null;
    }

    @Override
    public String getL3AccessMetric() {
        for (String string : this.metrics) {
            if (string.toUpperCase().contains("PAPI_L3_TCA") && !string.startsWith("(")) {
                return string;
            }
            if (string.toUpperCase().contains("PAPI_L2_TCM") && !string.startsWith("(")) {
                return string;
            }
            if (string.toUpperCase().contains("PAPI_L3_DCA") && !string.startsWith("(")) {
                return string;
            }
            if (!string.toUpperCase().contains("PAPI_L2_DCM") || string.startsWith("(")) continue;
            return string;
        }
        if (!this.ignoreWarnings) {
            System.err.println("*** Warning - no L3 access metric found in Trial ***");
        }
        return null;
    }

    @Override
    public String getL1MissMetric() {
        for (String string : this.metrics) {
            if (string.toUpperCase().contains("PAPI_L1_TCM") && !string.startsWith("(")) {
                return string;
            }
            if (string.toUpperCase().contains("PAPI_L1_DCM") && !string.startsWith("(")) {
                return string;
            }
            if (string.toUpperCase().contains("PAPI_L2_TCA") && !string.startsWith("(")) {
                return string;
            }
            if (!string.toUpperCase().contains("PAPI_L2_DCA") || string.startsWith("(")) continue;
            return string;
        }
        if (!this.ignoreWarnings) {
            System.err.println("*** Warning - no L1 miss metric found in Trial ***");
        }
        return null;
    }

    @Override
    public String getL2MissMetric() {
        for (String string : this.metrics) {
            if (string.toUpperCase().contains("PAPI_L2_TCM") && !string.startsWith("(")) {
                return string;
            }
            if (string.toUpperCase().contains("PAPI_L2_DCM") && !string.startsWith("(")) {
                return string;
            }
            if (string.toUpperCase().contains("PAPI_L3_TCA") && !string.startsWith("(")) {
                return string;
            }
            if (!string.toUpperCase().contains("PAPI_L3_DCA") || string.startsWith("(")) continue;
            return string;
        }
        if (!this.ignoreWarnings) {
            System.err.println("*** Warning - no L2 miss metric found in Trial ***");
        }
        return null;
    }

    @Override
    public String getL3MissMetric() {
        for (String string : this.metrics) {
            if (string.toUpperCase().contains("PAPI_L3_TCM") && !string.startsWith("(")) {
                return string;
            }
            if (!string.toUpperCase().contains("PAPI_L3_DCM") || string.startsWith("(")) continue;
            return string;
        }
        if (!this.ignoreWarnings) {
            System.err.println("*** Warning - no L3 miss metric found in Trial ***");
        }
        return null;
    }

    @Override
    public String getTLBMissMetric() {
        for (String string : this.metrics) {
            if (string.toUpperCase().contains("PAPI_TLB_CM") && !string.startsWith("(")) {
                return string;
            }
            if (!string.toUpperCase().contains("PAPI_TLB_DM") || string.startsWith("(")) continue;
            return string;
        }
        if (!this.ignoreWarnings) {
            System.err.println("*** Warning - no TLB miss metric found in Trial ***");
        }
        return null;
    }

    @Override
    public String getTotalInstructionMetric() {
        for (String string : this.metrics) {
            if (!string.toUpperCase().contains("PAPI_TOT_INS") || string.startsWith("(")) continue;
            return string;
        }
        if (!this.ignoreWarnings) {
            System.err.println("*** Warning - no total instruction metric found in Trial ***");
        }
        return null;
    }

    @Override
    public Map<String, Double> getSortedByValue(String string, int n, boolean bl) {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        for (String string2 : this.getEvents()) {
            hashMap.put(string2, this.getDataPoint(0, string2, string, n));
        }
        hashMap = Utilities.sortHashMapByValues(hashMap, bl);
        return hashMap;
    }

    @Override
    public Integer getTrialID() {
        return this.trialID;
    }

    public void setTrialID(Integer n) {
        this.trialID = n;
    }

    @Override
    public Trial getTrial() {
        return this.trial;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setTrial(Trial trial) {
        this.trial = trial;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Integer n : this.getThreads()) {
            for (String string : this.getEvents()) {
                for (String string2 : this.getMetrics()) {
                    stringBuilder.append(n + " : " + string + " : " + string2 + " : " + this.getExclusive(n, string, string2) + "\n");
                }
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public Map<Integer, String> getEventMap() {
        return this.eventMap;
    }

    @Override
    public void setEventMap(Map<Integer, String> map) {
        this.eventMap = map;
    }

    public double getMainInclusive() {
        return this.mainInclusive;
    }

    public void setMainInclusive(double d) {
        this.mainInclusive = d;
    }

    @Override
    public void updateEventMap() {
        Set<Integer> set = this.eventMap.keySet();
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (Integer n : set) {
            String string = this.eventMap.get(n);
            if (!this.events.contains(string)) continue;
            hashMap.put(n, string);
        }
        this.eventMap = hashMap;
    }

    @Override
    public void setIgnoreWarnings(boolean bl) {
        this.ignoreWarnings = bl;
    }
}

