/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.MaxResult;
import edu.uoregon.tau.perfexplorer.glue.MeanResult;
import edu.uoregon.tau.perfexplorer.glue.MinResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.glue.StDevResult;
import edu.uoregon.tau.perfexplorer.glue.TotalResult;
import edu.uoregon.tau.perfexplorer.glue.VarianceResult;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicStatisticsOperation
extends AbstractPerformanceOperation {
    public static int TOTAL = 0;
    public static int MEAN = 1;
    public static int VARIANCE = 2;
    public static int STDDEV = 3;
    public static int MIN = 4;
    public static int MAX = 5;
    private boolean combined = false;
    private boolean includeNull = false;

    public BasicStatisticsOperation(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    public BasicStatisticsOperation(PerformanceResult performanceResult, boolean bl) {
        super(performanceResult);
        this.combined = bl;
    }

    public BasicStatisticsOperation(Trial trial, boolean bl) {
        super(trial);
        this.combined = bl;
    }

    public BasicStatisticsOperation(List<PerformanceResult> list, boolean bl) {
        super(list);
        this.combined = bl;
    }

    @Override
    public List<PerformanceResult> processData() {
        if (!this.combined) {
            return this.processDataNotCombined();
        }
        if (this.inputs.size() == 1) {
            System.err.println("*** Warning - only one trial in combined statistics process ***");
        }
        TotalResult totalResult = new TotalResult();
        MeanResult meanResult = new MeanResult();
        VarianceResult varianceResult = new VarianceResult();
        StDevResult stDevResult = new StDevResult();
        MinResult minResult = new MinResult();
        MaxResult maxResult = new MaxResult();
        totalResult.setIgnoreWarnings(true);
        minResult.setIgnoreWarnings(true);
        maxResult.setIgnoreWarnings(true);
        varianceResult.setIgnoreWarnings(true);
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        TreeSet<String> treeSet3 = new TreeSet<String>();
        for (Object object : this.inputs) {
            treeSet.addAll(object.getThreads());
            treeSet3.addAll(object.getEvents());
            treeSet2.addAll(object.getMetrics());
        }
        HashMap hashMap = new HashMap();
        for (String string : treeSet3) {
            hashMap.put(string, 0);
        }
        double d = 0.0;
        for (Iterator iterator : this.inputs) {
            for (Integer n : treeSet) {
                for (String string : treeSet3) {
                    for (String string2 : treeSet2) {
                        totalResult.putExclusive(n, string, string2, totalResult.getExclusive(n, string, string2) + iterator.getExclusive(n, string, string2));
                        minResult.putDataPoint(n, string, string2, 1, iterator.getExclusive(n, string, string2));
                        maxResult.putDataPoint(n, string, string2, 1, iterator.getExclusive(n, string, string2));
                        totalResult.putInclusive(n, string, string2, totalResult.getInclusive(n, string, string2) + iterator.getInclusive(n, string, string2));
                        minResult.putDataPoint(n, string, string2, 0, iterator.getInclusive(n, string, string2));
                        maxResult.putDataPoint(n, string, string2, 0, iterator.getInclusive(n, string, string2));
                    }
                    d = iterator.getCalls(n, string);
                    if (d > 0.0) {
                        hashMap.put(string, (Integer)hashMap.get(string) + 1);
                    }
                    totalResult.putCalls(n, string, totalResult.getCalls(n, string) + d);
                    minResult.putDataPoint(n, string, null, 2, d);
                    maxResult.putDataPoint(n, string, null, 2, d);
                    totalResult.putSubroutines(n, string, totalResult.getSubroutines(n, string) + iterator.getSubroutines(n, string));
                    minResult.putDataPoint(n, string, null, 3, iterator.getSubroutines(n, string));
                    maxResult.putDataPoint(n, string, null, 3, iterator.getSubroutines(n, string));
                }
            }
        }
        int n = this.inputs.size();
        for (Integer n2 : treeSet) {
            for (String string : treeSet3) {
                if (!this.includeNull) {
                    n = (Integer)hashMap.get(string);
                }
                for (String string3 : treeSet2) {
                    meanResult.putExclusive(n2, string, string3, totalResult.getExclusive(n2, string, string3) / (double)n);
                    meanResult.putInclusive(n2, string, string3, totalResult.getInclusive(n2, string, string3) / (double)n);
                    if (Double.isNaN(meanResult.getExclusive(n2, string, string3))) {
                        meanResult.putExclusive(n2, string, string3, 0.0);
                    }
                    if (!Double.isNaN(meanResult.getInclusive(n2, string, string3))) continue;
                    meanResult.putInclusive(n2, string, string3, 0.0);
                }
                meanResult.putCalls(n2, string, totalResult.getCalls(n2, string) / (double)n);
                meanResult.putSubroutines(n2, string, totalResult.getSubroutines(n2, string) / (double)n);
                if (Double.isNaN(meanResult.getCalls(n2, string))) {
                    meanResult.putCalls(n2, string, 0.0);
                }
                if (!Double.isNaN(meanResult.getCalls(n2, string))) continue;
                meanResult.putCalls(n2, string, 0.0);
            }
        }
        for (PerformanceResult performanceResult : this.inputs) {
            for (Integer n3 : treeSet) {
                for (String string : treeSet3) {
                    for (String string4 : treeSet2) {
                        varianceResult.putExclusive(n3, string, string4, varianceResult.getExclusive(n3, string, string4) + Math.pow(meanResult.getExclusive(n3, string, string4) - performanceResult.getExclusive(n3, string, string4), 2.0));
                        varianceResult.putInclusive(n3, string, string4, varianceResult.getInclusive(n3, string, string4) + Math.pow(meanResult.getInclusive(n3, string, string4) - performanceResult.getInclusive(n3, string, string4), 2.0));
                    }
                    varianceResult.putCalls(n3, string, varianceResult.getCalls(n3, string) + Math.pow(meanResult.getCalls(n3, string) - performanceResult.getCalls(n3, string), 2.0));
                    varianceResult.putSubroutines(n3, string, varianceResult.getSubroutines(n3, string) + Math.pow(meanResult.getSubroutines(n3, string) - performanceResult.getSubroutines(n3, string), 2.0));
                }
            }
        }
        n = this.inputs.size() - 1;
        for (Integer n4 : treeSet) {
            for (String string : treeSet3) {
                if (!this.includeNull) {
                    n = (Integer)hashMap.get(string);
                    n = n == 1 ? 1 : n - 1;
                }
                for (String string5 : treeSet2) {
                    varianceResult.putExclusive(n4, string, string5, varianceResult.getExclusive(n4, string, string5) / (double)n);
                    stDevResult.putExclusive(n4, string, string5, Math.sqrt(varianceResult.getExclusive(n4, string, string5)));
                    varianceResult.putInclusive(n4, string, string5, varianceResult.getInclusive(n4, string, string5) / (double)n);
                    stDevResult.putInclusive(n4, string, string5, Math.sqrt(varianceResult.getInclusive(n4, string, string5)));
                }
                varianceResult.putCalls(n4, string, varianceResult.getCalls(n4, string) / (double)n);
                stDevResult.putCalls(n4, string, Math.sqrt(varianceResult.getCalls(n4, string)));
                varianceResult.putSubroutines(n4, string, varianceResult.getSubroutines(n4, string) / (double)n);
                stDevResult.putSubroutines(n4, string, Math.sqrt(varianceResult.getSubroutines(n4, string)));
            }
        }
        this.outputs.add(totalResult);
        this.outputs.add(meanResult);
        this.outputs.add(varianceResult);
        this.outputs.add(stDevResult);
        this.outputs.add(minResult);
        this.outputs.add(maxResult);
        return this.outputs;
    }

    public List<PerformanceResult> processDataNotCombined() {
        for (PerformanceResult performanceResult : this.inputs) {
            TotalResult totalResult = new TotalResult(performanceResult, false);
            MeanResult meanResult = new MeanResult(performanceResult, false);
            VarianceResult varianceResult = new VarianceResult(performanceResult, false);
            StDevResult stDevResult = new StDevResult(performanceResult, false);
            MinResult minResult = new MinResult(performanceResult, false);
            MaxResult maxResult = new MaxResult(performanceResult, false);
            totalResult.setIgnoreWarnings(true);
            minResult.setIgnoreWarnings(true);
            maxResult.setIgnoreWarnings(true);
            varianceResult.setIgnoreWarnings(true);
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            TreeSet<String> treeSet2 = new TreeSet<String>();
            TreeSet<String> treeSet3 = new TreeSet<String>();
            treeSet.addAll(performanceResult.getThreads());
            treeSet3.addAll(performanceResult.getEvents());
            treeSet2.addAll(performanceResult.getMetrics());
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (String string : treeSet3) {
                hashMap.put(string, 0);
            }
            double d = 0.0;
            for (Integer n : treeSet) {
                for (String string : treeSet3) {
                    d = performanceResult.getCalls(n, string);
                    if (!(d > 0.0)) continue;
                    for (String string2 : treeSet2) {
                        totalResult.putExclusive(0, string, string2, totalResult.getExclusive(0, string, string2) + performanceResult.getExclusive(n, string, string2));
                        minResult.putDataPoint(0, string, string2, 1, performanceResult.getExclusive(n, string, string2));
                        maxResult.putDataPoint(0, string, string2, 1, performanceResult.getExclusive(n, string, string2));
                        totalResult.putInclusive(0, string, string2, totalResult.getInclusive(0, string, string2) + performanceResult.getInclusive(n, string, string2));
                        minResult.putDataPoint(0, string, string2, 0, performanceResult.getInclusive(n, string, string2));
                        maxResult.putDataPoint(0, string, string2, 0, performanceResult.getInclusive(n, string, string2));
                    }
                    hashMap.put(string, (Integer)hashMap.get(string) + 1);
                    totalResult.putCalls(0, string, totalResult.getCalls(0, string) + d);
                    minResult.putDataPoint(0, string, null, 2, d);
                    maxResult.putDataPoint(0, string, null, 2, d);
                    totalResult.putSubroutines(0, string, totalResult.getSubroutines(0, string) + performanceResult.getSubroutines(n, string));
                    minResult.putDataPoint(0, string, null, 3, performanceResult.getSubroutines(n, string));
                    maxResult.putDataPoint(0, string, null, 3, performanceResult.getSubroutines(n, string));
                }
            }
            int n = performanceResult.getThreads().size();
            for (String string : treeSet3) {
                if (!this.includeNull) {
                    n = (Integer)hashMap.get(string);
                }
                for (Object object : treeSet2) {
                    meanResult.putExclusive(0, string, (String)object, totalResult.getExclusive(0, string, (String)object) / (double)n);
                    meanResult.putInclusive(0, string, (String)object, totalResult.getInclusive(0, string, (String)object) / (double)n);
                    if (Double.isNaN(meanResult.getExclusive(0, string, (String)object))) {
                        meanResult.putExclusive(0, string, (String)object, 0.0);
                    }
                    if (!Double.isNaN(meanResult.getInclusive(0, string, (String)object))) continue;
                    meanResult.putInclusive(0, string, (String)object, 0.0);
                }
                meanResult.putCalls(0, string, totalResult.getCalls(0, string) / (double)n);
                meanResult.putSubroutines(0, string, totalResult.getSubroutines(0, string) / (double)n);
                if (Double.isNaN(meanResult.getCalls(0, string))) {
                    meanResult.putCalls(0, string, 0.0);
                }
                if (!Double.isNaN(meanResult.getCalls(0, string))) continue;
                meanResult.putCalls(0, string, 0.0);
            }
            for (Integer n2 : treeSet) {
                for (Object object : treeSet3) {
                    if (this.includeNull || !(performanceResult.getCalls(n2, (String)object) > 0.0)) continue;
                    for (String string : treeSet2) {
                        varianceResult.putExclusive(0, (String)object, string, varianceResult.getExclusive(0, (String)object, string) + Math.pow(meanResult.getExclusive(0, (String)object, string) - performanceResult.getExclusive(n2, (String)object, string), 2.0));
                        varianceResult.putInclusive(0, (String)object, string, varianceResult.getInclusive(0, (String)object, string) + Math.pow(meanResult.getInclusive(0, (String)object, string) - performanceResult.getInclusive(n2, (String)object, string), 2.0));
                    }
                    varianceResult.putCalls(0, (String)object, varianceResult.getCalls(0, (String)object) + Math.pow(meanResult.getCalls(0, (String)object) - performanceResult.getCalls(n2, (String)object), 2.0));
                    varianceResult.putSubroutines(0, (String)object, varianceResult.getSubroutines(0, (String)object) + Math.pow(meanResult.getSubroutines(0, (String)object) - performanceResult.getSubroutines(n2, (String)object), 2.0));
                }
            }
            n = performanceResult.getThreads().size() - 1;
            for (String string : treeSet3) {
                if (!this.includeNull) {
                    n = (Integer)hashMap.get(string);
                    n = n == 1 ? 1 : n - 1;
                }
                for (Object object : treeSet2) {
                    varianceResult.putExclusive(0, string, (String)object, varianceResult.getExclusive(0, string, (String)object) / (double)n);
                    stDevResult.putExclusive(0, string, (String)object, Math.sqrt(varianceResult.getExclusive(0, string, (String)object)));
                    varianceResult.putInclusive(0, string, (String)object, varianceResult.getInclusive(0, string, (String)object) / (double)n);
                    stDevResult.putInclusive(0, string, (String)object, Math.sqrt(varianceResult.getInclusive(0, string, (String)object)));
                }
                varianceResult.putCalls(0, string, varianceResult.getCalls(0, string) / (double)n);
                stDevResult.putCalls(0, string, Math.sqrt(varianceResult.getCalls(0, string)));
                varianceResult.putSubroutines(0, string, varianceResult.getSubroutines(0, string) / (double)n);
                stDevResult.putSubroutines(0, string, Math.sqrt(varianceResult.getSubroutines(0, string)));
            }
            this.outputs.add(totalResult);
            this.outputs.add(meanResult);
            this.outputs.add(varianceResult);
            this.outputs.add(stDevResult);
            this.outputs.add(minResult);
            this.outputs.add(maxResult);
        }
        return this.outputs;
    }

    public boolean isCombined() {
        return this.combined;
    }

    public void setCombined(boolean bl) {
        this.combined = bl;
    }

    public boolean isIncludeNull() {
        return this.includeNull;
    }

    public void setIncludeNull(boolean bl) {
        this.includeNull = bl;
    }
}

