/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerClient;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.DefaultResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.vis.HeatMapData;
import edu.uoregon.tau.vis.HeatMapWindow;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildMessageHeatMap
extends AbstractPerformanceOperation {
    private HeatMapData mapData = null;
    private int size = 0;
    private static final String allPaths = "All Paths";
    private static final int COUNT = 0;
    private static final int MAX = 1;
    private static final int MIN = 2;
    private static final int MEAN = 3;
    private static final int STDDEV = 4;
    private static final int VOLUME = 5;
    private JFrame window = null;

    public BuildMessageHeatMap(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    @Override
    public List<PerformanceResult> processData() {
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        for (PerformanceResult performanceResult : this.inputs) {
            long l = System.currentTimeMillis();
            this.size = performanceResult.getThreads().size();
            this.outputs.add(new DefaultResult(performanceResult, false));
            boolean bl = false;
            this.mapData = new HeatMapData(this.size);
            for (Integer n : performanceResult.getThreads()) {
                for (String string : performanceResult.getUserEvents(n)) {
                    if (performanceResult.getUsereventNumevents(n, string) == 0.0) continue;
                    if (string.startsWith("Message size sent to node ") && !string.contains("=>")) {
                        bl = true;
                        this.extractData(performanceResult, n, string, string, allPaths);
                        continue;
                    }
                    if (!string.startsWith("Message size sent to node ") || !string.contains("=>")) continue;
                    bl = true;
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                    String string2 = stringTokenizer.nextToken().trim();
                    String string3 = stringTokenizer.nextToken().trim();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "=>");
                    String string4 = null;
                    while (stringTokenizer2.hasMoreTokens()) {
                        string4 = stringTokenizer2.nextToken().trim();
                        this.extractData(performanceResult, n, string, string2, string4);
                    }
                }
            }
            if (!bl) {
                JOptionPane.showMessageDialog(PerfExplorerClient.getMainFrame(), "This trial does not have communication matrix data.\nTo collect communication matrix data, set the environment variable TAU_COMM_MATRIX=1 before executing your application.", "No Communication Matrix Data", 0);
                return null;
            }
            long l2 = System.currentTimeMillis() - l;
            float f = (float)l2 / 1000.0f;
            System.out.println("Total time to extract data: " + decimalFormat.format(f) + " seconds");
            l = System.currentTimeMillis();
            this.mapData.massageData();
            l2 = System.currentTimeMillis() - l;
            f = (float)l2 / 1000.0f;
            System.out.println("Total time to process data: " + f + " seconds");
            this.window = new HeatMapWindow("Message Size Heat Maps", this.mapData);
            URL object2 = Utility.getResource((String)"tau32x32.gif");
            if (object2 != null) {
                this.window.setIconImage(Toolkit.getDefaultToolkit().getImage(object2));
            }
            this.window.setVisible(true);
        }
        return this.outputs;
    }

    private void extractData(PerformanceResult performanceResult, Integer n, String string, String string2, String string3) {
        double d = 0.0;
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "Message size sent to node ");
        if (stringTokenizer.hasMoreTokens()) {
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            double[] dArray2 = this.mapData.get(n.intValue(), n2, string3);
            if (dArray2 == null) {
                dArray2 = dArray;
            }
            double d2 = performanceResult.getUsereventNumevents(n, string);
            dArray2[0] = dArray2[0] + d2;
            double d3 = performanceResult.getUsereventMax(n, string);
            dArray2[1] = Math.max(d3, dArray2[1]);
            double d4 = performanceResult.getUsereventMin(n, string);
            dArray2[2] = dArray2[2] > 0.0 ? Math.min(dArray2[2], d4) : d4;
            double d5 = performanceResult.getUsereventMean(n, string);
            dArray2[3] = dArray2[3] + d5;
            double d6 = performanceResult.getUsereventSumsqr(n, string);
            dArray2[4] = dArray2[4] + d6;
            d = d2 * d5;
            dArray2[5] = dArray2[5] + d;
            this.mapData.put(n.intValue(), n2, string3, dArray2);
        }
    }

    public static void centerFrame(JFrame jFrame) {
        int n = 700;
        int n2 = 500;
        Point point = PerfExplorerClient.getMainFrame().getLocationOnScreen();
        Dimension dimension = PerfExplorerClient.getMainFrame().getSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        int n5 = (n3 - n) / 2;
        int n6 = (n4 - n2) / 2;
        n5 = (int)point.getX() + n5;
        n6 = (int)point.getY() + n6;
        jFrame.setLocation(n5, n6);
    }
}

