/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.clustering.ClusterInterface;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.DefaultResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClusterOperation
extends AbstractPerformanceOperation {
    protected Integer maxClusters = 2;
    protected String metric;
    protected int type;
    protected double evaluation = 0.0;
    protected double adjustedEvaluation = 0.0;
    protected ClusterInterface clusterer = null;
    protected int B = 10;
    protected double gapStatistic = 0.0;
    protected double gapStatisticError = 0.0;
    protected boolean computeGapStatistic = false;
    protected int[] clusterIDs = null;

    public ClusterOperation() {
    }

    public ClusterOperation(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    public ClusterOperation(Trial trial) {
        super(trial);
    }

    public ClusterOperation(List<PerformanceResult> list) {
        super(list);
    }

    @Override
    public List<PerformanceResult> processData() {
        return null;
    }

    protected PerformanceResult generateReferenceDataset(PerformanceResult performanceResult, PerformanceResult performanceResult2, PerformanceResult performanceResult3) {
        DefaultResult defaultResult = new DefaultResult();
        for (String string : performanceResult.getEvents()) {
            double d = Double.MAX_VALUE;
            for (Integer n : performanceResult2.getThreads()) {
                if (!(d > performanceResult2.getDataPoint(n, string, this.metric, this.type))) continue;
                d = performanceResult2.getDataPoint(n, string, this.metric, this.type);
            }
            double d2 = Double.MIN_VALUE;
            for (Integer n : performanceResult3.getThreads()) {
                if (!(d2 < performanceResult3.getDataPoint(n, string, this.metric, this.type))) continue;
                d2 = performanceResult3.getDataPoint(n, string, this.metric, this.type);
            }
            double d3 = d2 - d;
            for (Integer n : performanceResult.getThreads()) {
                double d4 = Math.random() * d3 + d;
                defaultResult.putDataPoint(n, string, this.metric, this.type, d4);
            }
        }
        return defaultResult;
    }

    protected double computeErrorMeasure(PerformanceResult performanceResult, ClusterInterface clusterInterface, boolean bl) {
        Set<String> set = performanceResult.getEvents();
        int n = performanceResult.getThreads().size();
        double[] dArray = new double[this.maxClusters.intValue()];
        int[] nArray = clusterInterface.getClusterSizes();
        if (nArray.length < this.maxClusters) {
            System.err.println("\n**************** not enough clusters! **************\n");
        }
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = 0.0;
            for (int j = 0; j < n; ++j) {
                int n2 = clusterInterface.clusterInstance(j);
                for (int k = j; k < n; ++k) {
                    int n3 = clusterInterface.clusterInstance(k);
                    if (i != n2 || n2 != n3) continue;
                    for (String string : set) {
                        int n4 = i;
                        dArray[n4] = dArray[n4] + Math.pow(performanceResult.getDataPoint(j, string, this.metric, this.type) - performanceResult.getDataPoint(k, string, this.metric, this.type), 2.0);
                    }
                }
            }
            d += dArray[i] / (double)(2 * nArray[i]);
        }
        if (bl) {
            System.out.println("Error Measure: " + d);
        }
        d = Math.log(d);
        return d;
    }

    public Integer getMaxClusters() {
        return this.maxClusters;
    }

    public void setMaxClusters(Integer n) {
        this.maxClusters = n;
    }

    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String string) {
        this.metric = string;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public double getGapStatistic() {
        return this.gapStatistic;
    }

    public double getGapStatisticError() {
        return this.gapStatisticError;
    }

    public boolean isComputeGapStatistic() {
        return this.computeGapStatistic;
    }

    public void setComputeGapStatistic(boolean bl) {
        this.computeGapStatistic = bl;
    }

    protected void computeGapStatistic(PerformanceResult performanceResult, PerformanceResult performanceResult2, PerformanceResult performanceResult3) {
        System.out.println("Computing Gap Statistic");
        double d = this.computeErrorMeasure(performanceResult, this.clusterer, false);
        double[] dArray = new double[this.B];
        double d2 = 0.0;
        for (int i = 0; i < this.B; ++i) {
            PerformanceResult performanceResult4 = this.generateReferenceDataset(performanceResult, performanceResult2, performanceResult3);
            ClusterInterface clusterInterface = this.doClustering(performanceResult4);
            dArray[i] = this.computeErrorMeasure(performanceResult4, clusterInterface, false);
            d2 += dArray[i];
        }
        this.gapStatistic = (d2 /= (double)this.B) - d;
        double d3 = 0.0;
        for (int i = 0; i < this.B; ++i) {
            d3 += Math.pow(dArray[i] - d2, 2.0);
        }
        d3 /= (double)this.B;
        d3 = Math.pow(d3, 0.5);
        this.gapStatisticError = d3 * Math.sqrt(1 + 1 / this.B);
    }

    protected abstract ClusterInterface doClustering(PerformanceResult var1);
}

