/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.DeriveMetricOperation;
import edu.uoregon.tau.perfexplorer.glue.MergeTrialsOperation;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.glue.ScaleMetricOperation;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeriveMetricEquation
extends AbstractPerformanceOperation {
    private ArrayList<String> equation = null;
    private PerformanceResult input = null;
    private String newName = null;

    public DeriveMetricEquation(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    public DeriveMetricEquation(Trial trial) {
        super(trial);
    }

    public DeriveMetricEquation(List<PerformanceResult> list) {
        super(list);
    }

    public DeriveMetricEquation(PerformanceResult performanceResult, String string) {
        super(performanceResult);
        this.input = performanceResult;
        this.equation = this.infixToPostfix(string);
    }

    public DeriveMetricEquation(PerformanceResult performanceResult, String string, String string2) {
        this(performanceResult, string);
        this.newName = string2;
    }

    public DeriveMetricEquation(PerformanceResult performanceResult, String[] stringArray) {
        super(performanceResult);
        this.input = performanceResult;
        this.equation = this.infixToPostfix(stringArray);
    }

    private ArrayList<String> infixToPostfix(String string) {
        char[] cArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        Stack<Character> stack = new Stack<Character>();
        block19: for (char c : cArray = string.toCharArray()) {
            switch (c) {
                case '+': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(Character.valueOf('+'));
                    continue block19;
                }
                case '-': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(Character.valueOf('-'));
                    continue block19;
                }
                case '/': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(' && ((Character)stack.peek()).charValue() != '-' && ((Character)stack.peek()).charValue() != '+') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(Character.valueOf('/'));
                    continue block19;
                }
                case '*': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(' && ((Character)stack.peek()).charValue() != '-' && ((Character)stack.peek()).charValue() != '+') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(Character.valueOf('*'));
                    continue block19;
                }
                case '(': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    stack.push(Character.valueOf('('));
                    continue block19;
                }
                case ')': {
                    if (!string2.equals("")) {
                        arrayList.add(string2 + "");
                    }
                    string2 = "";
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                        stack.pop();
                    }
                    catch (EmptyStackException emptyStackException) {
                        System.err.println("Unmatched )");
                    }
                    continue block19;
                }
                case ' ': {
                    continue block19;
                }
                default: {
                    string2 = string2 + c;
                }
            }
        }
        if (!string2.equals("")) {
            arrayList.add(string2 + "");
        }
        string2 = "";
        while (!stack.isEmpty()) {
            arrayList.add(stack.pop() + "");
        }
        return arrayList;
    }

    private ArrayList<String> infixToPostfix(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Stack<Character> stack = new Stack<Character>();
        block18: for (String string : stringArray) {
            char c = string.charAt(0);
            switch (c) {
                case '+': {
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(Character.valueOf('+'));
                    continue block18;
                }
                case '-': {
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(Character.valueOf('-'));
                    continue block18;
                }
                case '/': {
                    try {
                        while (((Character)stack.peek()).charValue() != '(' && ((Character)stack.peek()).charValue() != '-' && ((Character)stack.peek()).charValue() != '+') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(Character.valueOf('/'));
                    continue block18;
                }
                case '*': {
                    try {
                        while (((Character)stack.peek()).charValue() != '(' && ((Character)stack.peek()).charValue() != '-' && ((Character)stack.peek()).charValue() != '+') {
                            arrayList.add(stack.pop() + "");
                        }
                    }
                    catch (EmptyStackException emptyStackException) {
                        // empty catch block
                    }
                    stack.push(Character.valueOf('*'));
                    continue block18;
                }
                case '(': {
                    stack.push(Character.valueOf('('));
                    continue block18;
                }
                case ')': {
                    try {
                        while (((Character)stack.peek()).charValue() != '(') {
                            arrayList.add(stack.pop() + "");
                        }
                        stack.pop();
                    }
                    catch (EmptyStackException emptyStackException) {
                        System.err.println("Unmatched )");
                    }
                    continue block18;
                }
                default: {
                    arrayList.add(string);
                }
            }
        }
        while (!stack.isEmpty()) {
            arrayList.add(stack.pop() + "");
        }
        return arrayList;
    }

    private boolean isValue(String string) {
        return Pattern.matches("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*", string);
    }

    @Override
    public List<PerformanceResult> processData() {
        Object object;
        PerformanceResult performanceResult;
        ScaleMetricOperation scaleMetricOperation;
        String string;
        String string2;
        String string3;
        PerformanceResult performanceResult2 = null;
        for (int i = 0; this.equation.size() > 3 && this.equation.size() > i; ++i) {
            if (!this.isOperation(this.equation.get(i))) continue;
            string3 = this.getOp(this.equation.remove(i));
            string2 = this.equation.remove(i - 1);
            string = this.equation.remove(i - 2);
            i -= 2;
            if (this.isValue(string)) {
                double d = Double.valueOf(string);
                scaleMetricOperation = new ScaleMetricOperation(this.input, d, string2, string3);
                performanceResult = scaleMetricOperation.processData().get(0);
            } else if (this.isValue(string2)) {
                double d = Double.valueOf(string2);
                scaleMetricOperation = new ScaleMetricOperation(this.input, string, d, string3);
                performanceResult = scaleMetricOperation.processData().get(0);
            } else {
                object = new DeriveMetricOperation(this.input, string, string2, string3);
                performanceResult = ((DeriveMetricOperation)object).processData().get(0);
            }
            object = (String)performanceResult.getMetrics().toArray()[0];
            this.equation.add(i, (String)object);
            MergeTrialsOperation mergeTrialsOperation = new MergeTrialsOperation(this.input);
            mergeTrialsOperation.addInput(performanceResult);
            this.input = performanceResult2 = mergeTrialsOperation.processData().get(0);
        }
        string3 = this.getOp(this.equation.remove(2));
        string2 = this.equation.remove(1);
        string = this.equation.remove(0);
        if (this.isValue(string)) {
            double d = Double.valueOf(string);
            scaleMetricOperation = new ScaleMetricOperation(this.input, d, string2, string3);
            if (this.newName != null) {
                scaleMetricOperation.setNewName(this.newName);
            }
            performanceResult = scaleMetricOperation.processData().get(0);
        } else if (this.isValue(string2)) {
            double d = Double.valueOf(string2);
            scaleMetricOperation = new ScaleMetricOperation(this.input, string, d, string3);
            if (this.newName != null) {
                scaleMetricOperation.setNewName(this.newName);
            }
            performanceResult = scaleMetricOperation.processData().get(0);
        } else {
            object = new DeriveMetricOperation(this.input, string, string2, string3);
            if (this.newName != null) {
                ((DeriveMetricOperation)object).setNewName(this.newName);
            }
            performanceResult = ((DeriveMetricOperation)object).processData().get(0);
        }
        MergeTrialsOperation mergeTrialsOperation = new MergeTrialsOperation(this.input);
        mergeTrialsOperation.addInput(performanceResult);
        this.input = performanceResult2 = mergeTrialsOperation.processData().get(0);
        if (performanceResult2 == null) {
            System.err.println("\n\n *** ERROR: Invaild Equation  ***\n\n");
        } else {
            this.outputs.add(performanceResult2);
        }
        return this.outputs;
    }

    private String getOp(String string) {
        char c = string.charAt(0);
        switch (c) {
            case '+': {
                return "+";
            }
            case '-': {
                return "-";
            }
            case '*': {
                return "*";
            }
            case '/': {
                return "/";
            }
        }
        return null;
    }

    private boolean isOperation(String string) {
        char c = string.charAt(0);
        return c == '+' || c == '-' || c == '*' || c == '/';
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String string) {
        this.newName = string;
    }

    public boolean exists() {
        return ((PerformanceResult)this.inputs.get(0)).getMetrics().contains(this.newName);
    }
}

