/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.TrialMetadata;
import edu.uoregon.tau.perfexplorer.rules.FactWrapper;
import edu.uoregon.tau.perfexplorer.rules.RuleHarness;
import edu.uoregon.tau.perfexplorer.rules.SelfAsserting;
import java.util.Hashtable;
import java.util.Set;
import org.drools.FactHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferenceMetadataOperation
implements SelfAsserting {
    TrialMetadata baseline = null;
    TrialMetadata comparison = null;
    Hashtable<String, String[]> differences = new Hashtable();
    double expectedRatio = 1.0;
    Hashtable<String, FactHandle> assertedFacts = new Hashtable();
    public static final String NAME = DifferenceMetadataOperation.class.getName();
    private RuleHarness ruleHarness = null;

    public double getExpectedRatio() {
        return this.expectedRatio;
    }

    public void setExpectedRatio(double d) {
        this.expectedRatio = d;
    }

    public DifferenceMetadataOperation(TrialMetadata trialMetadata, TrialMetadata trialMetadata2) {
        this.baseline = trialMetadata;
        this.comparison = trialMetadata2;
        this.doComparison();
    }

    public DifferenceMetadataOperation(Trial trial, Trial trial2) {
        this.baseline = new TrialMetadata(trial);
        this.comparison = new TrialMetadata(trial2);
        this.doComparison();
    }

    private void doComparison() {
        String[] stringArray;
        String string;
        Hashtable<String, String> hashtable = this.baseline.getCommonAttributes();
        Hashtable<String, String> hashtable2 = this.comparison.getCommonAttributes();
        Set<String> set = hashtable.keySet();
        Set<String> set2 = hashtable2.keySet();
        for (String string2 : set) {
            string = hashtable.get(string2);
            stringArray = hashtable2.get(string2);
            if (stringArray != null && string.equals(stringArray)) continue;
            String[] stringArray2 = new String[]{string, stringArray};
            this.differences.put(string2, stringArray2);
        }
        set2.removeAll(set);
        for (String string2 : set2) {
            string = hashtable2.get(string2);
            stringArray = new String[]{"", string};
            this.differences.put(string2, stringArray);
        }
    }

    public TrialMetadata getBaseline() {
        return this.baseline;
    }

    public void setBaseline(TrialMetadata trialMetadata) {
        this.baseline = trialMetadata;
    }

    public TrialMetadata getComparison() {
        return this.comparison;
    }

    public void setComparison(TrialMetadata trialMetadata) {
        this.comparison = trialMetadata;
    }

    public Hashtable<String, String[]> getDifferences() {
        return this.differences;
    }

    public void setDifferences(Hashtable<String, String[]> hashtable) {
        this.differences = hashtable;
    }

    public String differencesAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        Hashtable<String, String[]> hashtable = this.getDifferences();
        Set<String> set = hashtable.keySet();
        for (String string : set) {
            if (string.startsWith("buildenv:") || string.startsWith("runenv:") || string.startsWith("build:")) continue;
            String[] stringArray = hashtable.get(string);
            stringBuilder.append(string + " " + stringArray[0] + " " + stringArray[1] + "\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public void assertFacts() {
        if (RuleHarness.getInstance() != null) {
            // empty if block
        }
        this.assertFacts(RuleHarness.getInstance());
    }

    @Override
    public void assertFacts(RuleHarness ruleHarness) {
        this.ruleHarness = ruleHarness;
        Set<String> set = this.differences.keySet();
        for (String string : set) {
            String[] stringArray = this.differences.get(string);
            FactHandle factHandle = RuleHarness.assertObject(new FactWrapper(string, NAME, stringArray));
            this.assertedFacts.put(string, factHandle);
        }
    }

    @Override
    public void removeFact(String string) {
        FactHandle factHandle = this.assertedFacts.get(string);
        if (factHandle == null) {
            System.err.println("HANDLE NOT FOUND for " + string + ", " + NAME);
        } else {
            RuleHarness.retractObject(factHandle);
        }
    }
}

