/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.common.AlphanumComparator;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.client.MyCategoryAxis;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerChart;
import edu.uoregon.tau.perfexplorer.glue.BasicStatisticsOperation;
import edu.uoregon.tau.perfexplorer.glue.DrawGraph;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import java.awt.BasicStroke;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawMMMGraph
extends DrawGraph {
    private static final long serialVersionUID = 9035232637754955690L;
    private boolean sortXAxis = false;
    private String stripValue = null;

    public DrawMMMGraph(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    public DrawMMMGraph(Trial trial) {
        super(trial);
    }

    public DrawMMMGraph(List<PerformanceResult> list) {
        super(list);
    }

    @Override
    public List<PerformanceResult> processData() {
        Object object;
        Object object2;
        TreeSet<Object> treeSet;
        PerformanceResult performanceResult22;
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.inputs.get(BasicStatisticsOperation.MEAN));
        arrayList.add(this.inputs.get(BasicStatisticsOperation.MIN));
        arrayList.add(this.inputs.get(BasicStatisticsOperation.MAX));
        HashSet<Object> hashSet = new HashSet<Object>();
        for (PerformanceResult performanceResult22 : arrayList) {
            Object object322;
            treeSet = null;
            TreeSet<Object> treeSet2 = null;
            object2 = null;
            treeSet = this._events == null ? performanceResult22.getEvents() : this._events;
            treeSet2 = this._metrics == null ? performanceResult22.getMetrics() : this._metrics;
            if (this.sortXAxis && this.categoryType != 0) {
                if (this.categoryType == 1) {
                    object = new TreeSet(new AlphanumComparator());
                    for (Object object322 : treeSet) {
                        object.add(object322);
                    }
                    treeSet = object;
                } else if (this.categoryType == 2) {
                    object = new TreeSet<Object>((Comparator<Object>)new AlphanumComparator());
                    for (Object object322 : treeSet2) {
                        object.add(object322);
                    }
                    treeSet2 = object;
                } else if (this.categoryType == 3) {
                    // empty if block
                }
            }
            treeSet2 = this._metrics == null ? performanceResult22.getMetrics() : this._metrics;
            object2 = this._threads == null ? performanceResult22.getThreads() : this._threads;
            object = "";
            Object object4 = "";
            object322 = treeSet.iterator();
            while (object322.hasNext()) {
                String string = (String)object322.next();
                for (String string2 : treeSet2) {
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        Integer n = (Integer)iterator.next();
                        if (this.seriesType == 0) {
                            object = ((Object)performanceResult22).toString();
                        } else if (this.seriesType == 1) {
                            object = string;
                        } else if (this.seriesType == 2) {
                            object = string2;
                        } else if (this.seriesType == 3) {
                            object = n.toString();
                        }
                        if (this.categoryType == 0) {
                            object4 = ((Object)performanceResult22).toString();
                        } else if (this.categoryType == 1) {
                            object4 = string;
                        } else if (this.categoryType == 2) {
                            object4 = string2;
                        } else if (this.categoryType == 3) {
                            object4 = n.toString();
                        }
                        if (this.stripValue != null) {
                            object4 = ((String)object4).replaceAll(this.stripValue, "");
                            object4 = ((String)object4).replaceAll("> \\]", "");
                        }
                        defaultCategoryDataset.addValue(performanceResult22.getDataPoint(n, string, string2, this.valueType), (Comparable)object, (Comparable)object4);
                        hashSet.add(object4);
                    }
                }
            }
        }
        JFreeChart jFreeChart = ChartFactory.createLineChart((String)this.title, (String)this.xAxisLabel, (String)this.yAxisLabel, (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        Utility.applyDefaultChartTheme((JFreeChart)jFreeChart);
        performanceResult22 = (CategoryPlot)jFreeChart.getPlot();
        treeSet = (LineAndShapeRenderer)performanceResult22.getRenderer();
        treeSet.setBaseShapesFilled(true);
        treeSet.setBaseShapesVisible(true);
        treeSet.setDrawOutlines(true);
        treeSet.setBaseItemLabelsVisible(true);
        for (int i = 0; i < defaultCategoryDataset.getRowCount(); ++i) {
            treeSet.setSeriesStroke(i, new BasicStroke(2.0f));
        }
        if (this.logYAxis) {
            LogarithmicAxis logarithmicAxis = new LogarithmicAxis(this.yAxisLabel);
            logarithmicAxis.setAutoRangeIncludesZero(true);
            logarithmicAxis.setAllowNegativesFlag(true);
            logarithmicAxis.setLog10TickLabelsFlag(true);
            performanceResult22.setRangeAxis(0, (ValueAxis)logarithmicAxis);
        }
        NumberAxis numberAxis = (NumberAxis)performanceResult22.getRangeAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        object2 = null;
        object2 = new MyCategoryAxis(this.xAxisLabel);
        if (hashSet.size() > 40) {
            ((MyCategoryAxis)((Object)object2)).setTickLabelSkip(hashSet.size() / 20);
            ((MyCategoryAxis)((Object)object2)).setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        } else if (hashSet.size() > 20) {
            ((MyCategoryAxis)((Object)object2)).setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        }
        performanceResult22.setDomainAxis((CategoryAxis)object2);
        object = new PerfExplorerChart(jFreeChart, "General Chart");
        return null;
    }

    public void setSortXAxis(boolean bl) {
        this.sortXAxis = bl;
    }

    public boolean getSortXAxis() {
        return this.sortXAxis;
    }

    public void setStripXName(String string) {
        this.stripValue = string;
    }
}

