/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.clustering.ClusterInterface;
import edu.uoregon.tau.perfexplorer.clustering.KMeansClusterInterface;
import edu.uoregon.tau.perfexplorer.clustering.RawDataInterface;
import edu.uoregon.tau.perfexplorer.clustering.weka.AnalysisFactory;
import edu.uoregon.tau.perfexplorer.glue.ClusterOperation;
import edu.uoregon.tau.perfexplorer.glue.ClusterOutputResult;
import edu.uoregon.tau.perfexplorer.glue.DefaultResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMeansOperation
extends ClusterOperation {
    public KMeansOperation(PerformanceResult performanceResult, String string, int n, int n2) {
        super(performanceResult);
        this.metric = string;
        this.type = n;
        this.maxClusters = n2;
    }

    public KMeansOperation(Trial trial) {
        super(trial);
    }

    public KMeansOperation(List<PerformanceResult> list) {
        super(list);
    }

    @Override
    public List<PerformanceResult> processData() {
        for (PerformanceResult performanceResult : this.inputs) {
            System.out.println("instances: " + performanceResult.getThreads().size());
            System.out.println("dimensions: " + performanceResult.getEvents().size());
            this.clusterer = this.doClustering(performanceResult);
            ClusterOutputResult clusterOutputResult = new ClusterOutputResult(this.clusterer.getClusterCentroids(), this.metric, this.type);
            this.outputs.add(clusterOutputResult);
            this.outputs.add(new ClusterOutputResult(this.clusterer.getClusterStandardDeviations(), this.metric, this.type));
            ClusterOutputResult clusterOutputResult2 = new ClusterOutputResult(this.clusterer.getClusterMinimums(), this.metric, this.type);
            ClusterOutputResult clusterOutputResult3 = new ClusterOutputResult(this.clusterer.getClusterMaximums(), this.metric, this.type);
            this.outputs.add(clusterOutputResult2);
            this.outputs.add(clusterOutputResult3);
            DefaultResult defaultResult = new DefaultResult();
            int n = 0;
            for (int n2 : this.clusterer.getClusterSizes()) {
                defaultResult.putDataPoint(n++, "count", this.metric, this.type, n2);
            }
            this.outputs.add(defaultResult);
            Object object = new ArrayList<String>(performanceResult.getEvents());
            for (Integer n3 : performanceResult.getThreads()) {
                int n2;
                n2 = this.clusterer.clusterInstance(n3);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.evaluation += Math.pow(performanceResult.getDataPoint(n3, string, this.metric, this.type) - clusterOutputResult.getDataPoint(n2, string, this.metric, this.type), 2.0);
                }
            }
            this.evaluation = Math.sqrt(this.evaluation / (double)this.maxClusters.intValue());
            System.out.println(this.maxClusters + " clusters, Total squared distance from centroids: " + this.evaluation);
            double d = performanceResult.getThreads().size() - this.maxClusters;
            d /= (double)performanceResult.getThreads().size();
            d = Math.sqrt(d);
            this.adjustedEvaluation = this.evaluation / d;
            System.out.println(this.maxClusters + " clusters, Total adjusted squared distance from centroids: " + this.adjustedEvaluation);
            if (!this.computeGapStatistic) continue;
            this.computeGapStatistic(performanceResult, clusterOutputResult2, clusterOutputResult3);
        }
        return this.outputs;
    }

    @Override
    protected ClusterInterface doClustering(PerformanceResult performanceResult) {
        ArrayList<String> arrayList = new ArrayList<String>(performanceResult.getEvents());
        RawDataInterface rawDataInterface = AnalysisFactory.createRawData("Cluster Test", arrayList, performanceResult.getThreads().size(), arrayList.size(), null);
        for (Integer n : performanceResult.getThreads()) {
            int n2 = 0;
            for (String string : arrayList) {
                rawDataInterface.addValue((int)n, n2++, performanceResult.getDataPoint(n, string, this.metric, this.type));
                if (!string.equals(performanceResult.getMainEvent())) continue;
                rawDataInterface.addMainValue(n, n2 - 1, performanceResult.getDataPoint(n, string, this.metric, this.type));
            }
        }
        KMeansClusterInterface kMeansClusterInterface = AnalysisFactory.createKMeansEngine();
        kMeansClusterInterface.setInputData(rawDataInterface);
        kMeansClusterInterface.setK(this.maxClusters);
        kMeansClusterInterface.doPCA(false);
        try {
            kMeansClusterInterface.findClusters();
        }
        catch (Exception exception) {
            System.err.println("failure to cluster.");
            System.exit(0);
        }
        return kMeansClusterInterface;
    }
}

