/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfexplorer.cqos.WekaClassifierWrapper;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.glue.TrialMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearOptimizerOperation
extends AbstractPerformanceOperation {
    public static final String SUPPORT_VECTOR_MACHINE = "weka.classifiers.functions.SMO";
    public static final String NAIVE_BAYES = "weka.classifiers.bayes.NaiveBayes";
    public static final String MULTILAYER_PERCEPTRON = "weka.classifiers.functions.MultilayerPerceptron";
    public static final String LINEAR_REGRESSION = "weka.classifiers.functions.LinearRegression";
    private String metric = "Time";
    private Set<String> metadataFields = null;
    private String classLabel = null;
    private WekaClassifierWrapper wrapper = null;
    private String classifierType = "weka.classifiers.functions.LinearRegression";

    public LinearOptimizerOperation(List<PerformanceResult> list, String string, Set<String> set, String string2) {
        super(list);
        this.metric = string;
        this.metadataFields = set;
        this.classLabel = string;
    }

    @Override
    public List<PerformanceResult> processData() {
        Object object;
        HashMap<Hashtable, Object> hashMap = new HashMap<Hashtable, Object>();
        for (Object object2 : this.inputs) {
            Hashtable hashtable = new Hashtable();
            object = new TrialMetadata((PerformanceResult)object2);
            Iterator iterator = ((TrialMetadata)object).getCommonAttributes();
            if (this.metadataFields != null) {
                for (String string : this.metadataFields) {
                    if (string.equals(this.classLabel)) continue;
                    hashtable.put(string, ((Hashtable)((Object)iterator)).get(string));
                }
            } else {
                for (String string : ((Hashtable)((Object)iterator)).keySet()) {
                    if (string.equals(this.classLabel)) continue;
                    hashtable.put(string, ((Hashtable)((Object)iterator)).get(string));
                }
            }
            hashtable.put(this.metric, Double.toString(object2.getInclusive(0, object2.getMainEvent(), this.metric)));
            if (!object2.getMetrics().contains(this.metric)) {
                PerformanceResult performanceResult = (PerformanceResult)hashMap.get(hashtable);
                if (performanceResult == null) {
                    hashMap.put(hashtable, object2);
                    continue;
                }
                TrialMetadata trialMetadata = new TrialMetadata(performanceResult);
                if (!(Double.parseDouble((String)((Hashtable)((Object)iterator)).get(this.metric)) < Double.parseDouble(trialMetadata.getCommonAttributes().get(this.metric)))) continue;
                hashMap.put(hashtable, object2);
                continue;
            }
            PerformanceResult performanceResult = (PerformanceResult)hashMap.get(hashtable);
            if (performanceResult == null) {
                hashMap.put(hashtable, object2);
                continue;
            }
            if (!(object2.getInclusive(0, object2.getMainEvent(), this.metric) < performanceResult.getInclusive(0, performanceResult.getMainEvent(), this.metric))) continue;
            hashMap.put(hashtable, object2);
        }
        ArrayList arrayList = new ArrayList();
        for (Hashtable hashtable : hashMap.keySet()) {
            object = new HashMap();
            if (this.metadataFields != null) {
                for (String string : this.metadataFields) {
                    object.put(string, hashtable.get(string));
                }
            } else {
                for (String string : hashtable.keySet()) {
                    object.put(string, hashtable.get(string));
                }
            }
            arrayList.add(object);
            System.out.println(object.toString());
        }
        System.out.println("Total instances for training: " + arrayList.size());
        System.out.println("Using keys: " + this.metadataFields.toString());
        try {
            this.wrapper = new WekaClassifierWrapper(arrayList, this.classLabel);
            this.wrapper.setClassifierType(this.classifierType);
            this.wrapper.buildClassifier();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        return null;
    }

    public String getClass(Map<String, String> map) {
        return this.wrapper.getClass(map);
    }

    public double classifyInstance(Map<String, String> map) {
        return this.wrapper.classifyInstance(map);
    }

    public double getConfidence() {
        return this.wrapper.getConfidence();
    }

    public void writeClassifier(String string) {
        WekaClassifierWrapper.writeClassifier(string, this.wrapper);
    }

    public String getClassifierType() {
        return this.classifierType;
    }

    public void setClassifierType(String string) {
        this.classifierType = string;
    }

    public double[] getCoefficients() {
        return this.wrapper.getCoefficients();
    }
}

