/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.clustering.ClassifierInterface;
import edu.uoregon.tau.perfexplorer.clustering.RawDataInterface;
import edu.uoregon.tau.perfexplorer.clustering.weka.AnalysisFactory;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaiveBayesOperation
extends AbstractPerformanceOperation {
    protected String metric = null;
    protected int type = 1;
    protected ClassifierInterface classifier = null;
    protected List<String> classNames = null;
    protected final String trainString = "Naive Bayes Training";
    protected final String testString = "Naive Bayes Test";
    protected List<double[]> distributions = null;

    public NaiveBayesOperation(PerformanceResult performanceResult, String string, int n) {
        super(performanceResult);
        this.metric = string;
        this.type = n;
    }

    public NaiveBayesOperation(Trial trial) {
        super(trial);
    }

    public NaiveBayesOperation(List<PerformanceResult> list) {
        super(list);
    }

    @Override
    public List<PerformanceResult> processData() {
        RawDataInterface rawDataInterface = null;
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        this.classNames = new ArrayList<String>();
        for (PerformanceResult performanceResult : this.inputs) {
            for (String object : performanceResult.getEvents()) {
                hashSet.add(object);
            }
            n += performanceResult.getThreads().size();
            this.classNames.add(performanceResult.getName());
        }
        ArrayList arrayList = new ArrayList(hashSet);
        rawDataInterface = AnalysisFactory.createRawData(this.trainString, arrayList, n, arrayList.size(), this.classNames);
        int n2 = 0;
        for (PerformanceResult performanceResult : this.inputs) {
            for (Integer n3 : performanceResult.getThreads()) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    rawDataInterface.addValue(n2, i, performanceResult.getDataPoint(n3, string, this.metric, this.type));
                }
                rawDataInterface.addValue(n2, arrayList.size(), performanceResult.getName());
                ++n2;
            }
        }
        this.getClassifierFromFactory(rawDataInterface);
        try {
            this.classifier.buildClassifier();
        }
        catch (Exception exception) {
            System.err.println("failure to build classifier.");
            System.exit(0);
        }
        return this.outputs;
    }

    protected void getClassifierFromFactory(RawDataInterface rawDataInterface) {
        this.classifier = AnalysisFactory.createNaiveBayesClassifier(rawDataInterface);
    }

    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String string) {
        this.metric = string;
    }

    public List<String> classifyInstances(PerformanceResult performanceResult) {
        List<String> list = null;
        ArrayList<String> arrayList = new ArrayList<String>(performanceResult.getEvents());
        RawDataInterface rawDataInterface = AnalysisFactory.createRawData(this.testString, arrayList, performanceResult.getThreads().size(), arrayList.size(), this.classNames);
        for (Integer n : performanceResult.getThreads()) {
            int n2 = 0;
            for (String string : arrayList) {
                rawDataInterface.addValue((int)n, n2++, performanceResult.getDataPoint(n, string, this.metric, this.type));
                if (!string.equals(performanceResult.getMainEvent())) continue;
                rawDataInterface.addMainValue(n, n2 - 1, performanceResult.getDataPoint(n, string, this.metric, this.type));
            }
        }
        list = this.classifier.classifyInstances(rawDataInterface);
        this.distributions = this.classifier.getDistributions();
        return list;
    }

    public List<double[]> getDistributions() {
        return this.distributions;
    }
}

