/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.DefaultResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RatioOperation
extends AbstractPerformanceOperation {
    private boolean straightRatio = true;
    private String metricSuffix = "";

    public RatioOperation(PerformanceResult performanceResult, PerformanceResult performanceResult2) {
        super(performanceResult);
        this.addInput(performanceResult2);
    }

    public RatioOperation(PerformanceResult performanceResult, PerformanceResult performanceResult2, String string) {
        super(performanceResult);
        this.addInput(performanceResult2);
        this.metricSuffix = string;
    }

    public RatioOperation(Trial trial, Trial trial2) {
        super(trial);
        this.addInput(trial2);
    }

    public RatioOperation(List<PerformanceResult> list) {
        super(list);
    }

    @Override
    public List<PerformanceResult> processData() {
        PerformanceResult performanceResult = (PerformanceResult)this.inputs.get(0);
        PerformanceResult performanceResult2 = (PerformanceResult)this.inputs.get(1);
        DefaultResult defaultResult = new DefaultResult((PerformanceResult)this.inputs.get(0), false);
        Set<Integer> set = performanceResult.getThreads();
        set.addAll(performanceResult2.getThreads());
        Set<String> set2 = performanceResult.getEvents();
        set2.addAll(performanceResult2.getEvents());
        Set<String> set3 = performanceResult.getMetrics();
        set3.addAll(performanceResult2.getMetrics());
        for (Integer n : set) {
            for (String string : set2) {
                for (String string2 : set3) {
                    if (this.straightRatio) {
                        defaultResult.putExclusive(n, string, string2 + this.metricSuffix, performanceResult.getExclusive(n, string, string2) / performanceResult2.getExclusive(n, string, string2));
                        defaultResult.putInclusive(n, string, string2 + this.metricSuffix, performanceResult.getInclusive(n, string, string2) / performanceResult2.getInclusive(n, string, string2));
                    } else {
                        defaultResult.putExclusive(n, string, string2 + this.metricSuffix, Math.abs(performanceResult.getExclusive(n, string, string2) - performanceResult2.getExclusive(n, string, string2)) / performanceResult2.getExclusive(n, string, string2));
                        defaultResult.putInclusive(n, string, string2 + this.metricSuffix, Math.abs(performanceResult.getInclusive(n, string, string2) - performanceResult2.getInclusive(n, string, string2)) / performanceResult2.getInclusive(n, string, string2));
                    }
                    if (Double.isNaN(defaultResult.getExclusive(n, string, string2 + this.metricSuffix))) {
                        defaultResult.putExclusive(n, string, string2 + this.metricSuffix, 0.0);
                    }
                    if (!Double.isNaN(defaultResult.getInclusive(n, string, string2 + this.metricSuffix))) continue;
                    defaultResult.putInclusive(n, string, string2 + this.metricSuffix, 0.0);
                }
                if (this.straightRatio) {
                    defaultResult.putCalls(n, string, performanceResult.getCalls(n, string) / performanceResult2.getCalls(n, string));
                    defaultResult.putSubroutines(n, string, performanceResult.getSubroutines(n, string) / performanceResult2.getSubroutines(n, string));
                } else {
                    defaultResult.putCalls(n, string, Math.abs(performanceResult.getCalls(n, string) - performanceResult2.getCalls(n, string)) / performanceResult2.getCalls(n, string));
                    defaultResult.putSubroutines(n, string, Math.abs(performanceResult.getSubroutines(n, string) - performanceResult2.getSubroutines(n, string)) / performanceResult2.getSubroutines(n, string));
                }
                if (Double.isNaN(defaultResult.getCalls(n, string))) {
                    defaultResult.putCalls(n, string, 0.0);
                }
                if (!Double.isNaN(defaultResult.getSubroutines(n, string))) continue;
                defaultResult.putSubroutines(n, string, 0.0);
            }
        }
        this.outputs.add(defaultResult);
        return this.outputs;
    }

    public PerformanceResult getNumerator() {
        return (PerformanceResult)this.inputs.get(0);
    }

    public PerformanceResult getDenominator() {
        return (PerformanceResult)this.inputs.get(1);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.toString();
    }

    public boolean getStraightRatio() {
        return this.straightRatio;
    }

    public void setStraightRatio(boolean bl) {
        this.straightRatio = bl;
    }
}

