/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveResultOperation
extends AbstractPerformanceOperation {
    private boolean forceOverwrite = false;
    private int maxNodes = 1;
    private int maxContexts = 1;
    private int maxThreads = 1;
    private int curNode = 0;
    private int curContext = 0;
    private int curThread = -1;
    private DB db = null;
    private Trial trial;
    private StringBuilder buf = null;
    private PreparedStatement statement = null;
    private double mainInclusive = 0.0;
    private double[] accumulators = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};

    public SaveResultOperation(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    public SaveResultOperation(Trial trial) {
        super(trial);
        this.trial = trial;
    }

    public SaveResultOperation(List<PerformanceResult> list) {
        super(list);
    }

    @Override
    public List<PerformanceResult> processData() {
        for (PerformanceResult performanceResult : this.inputs) {
            this.trial = performanceResult.getTrial();
            if (this.trial == null) {
                System.err.println("SaveResultOperation.processData() not implemented for " + performanceResult.getClass().getName());
                System.err.println("The Trial reference is null - no idea where this data is supposed to go.");
                continue;
            }
            this.db = PerfExplorerServer.getServer().getDB();
            try {
                Object object2;
                this.db.setAutoCommit(false);
                this.getNodeContextThreadInfo();
                HashSet<String> hashSet = new HashSet<String>();
                for (Object object2 : this.trial.getMetrics()) {
                    hashSet.add(object2.getName());
                }
                object2 = performanceResult.getMetrics().iterator();
                while (object2.hasNext()) {
                    String string = (String)object2.next();
                    if (hashSet.contains(string)) {
                        if (!this.forceOverwrite) continue;
                        continue;
                    }
                    this.mainInclusive = performanceResult.getInclusive(0, performanceResult.getMainEvent(), string);
                    int n = this.insertMetric(string);
                    for (String string2 : performanceResult.getEvents()) {
                        int n2 = this.insertEvent(string2);
                        this.curNode = 0;
                        this.curContext = 0;
                        this.curThread = -1;
                        for (int i = 0; i < this.accumulators.length; ++i) {
                            this.accumulators[i] = 0.0;
                        }
                        for (Integer n3 : performanceResult.getThreads()) {
                            this.insertILP(performanceResult, n, n2, n3, string2, string);
                        }
                        this.insertTotalAndAverage(performanceResult, n, n2, string2, string);
                    }
                    this.db.commit();
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                if (this.db.getDBType().equals("postgresql")) {
                    System.err.println(this.statement.toString());
                } else {
                    System.err.println(this.buf.toString());
                }
                exception.printStackTrace();
                try {
                    this.db.rollback();
                    this.db.setAutoCommit(true);
                }
                catch (Exception exception2) {}
            }
        }
        return this.inputs;
    }

    private void getNodeContextThreadInfo() throws SQLException {
        this.buf = new StringBuilder();
        this.buf.append("select node_count, contexts_per_node, threads_per_context from trial where id = ?");
        this.statement = this.db.prepareStatement(this.buf.toString());
        this.statement.setInt(1, this.trial.getID());
        ResultSet resultSet = this.statement.executeQuery();
        if (resultSet.next()) {
            this.maxNodes = resultSet.getInt(1);
            this.maxContexts = resultSet.getInt(2);
            this.maxThreads = resultSet.getInt(3);
        }
        resultSet.close();
        this.statement.close();
    }

    private void insertILP(PerformanceResult performanceResult, int n, int n2, Integer n3, String string, String string2) throws SQLException {
        ++this.curThread;
        if (this.curThread >= this.maxThreads) {
            this.curThread = 0;
            ++this.curContext;
        }
        if (this.curContext >= this.maxContexts) {
            this.curContext = 0;
            ++this.curNode;
        }
        this.buf = new StringBuilder();
        this.buf.append("insert into interval_location_profile (interval_event, node, ");
        this.buf.append("context, thread, metric, inclusive_percentage, inclusive, ");
        if (this.db.getDBType().compareTo("oracle") == 0) {
            this.buf.append("exclusive_percentage, excl, ");
        } else {
            this.buf.append("exclusive_percentage, exclusive, ");
        }
        if (this.db.getDBType().compareTo("derby") == 0) {
            this.buf.append("num_calls, subroutines, ");
        } else {
            this.buf.append("call, subroutines, ");
        }
        this.buf.append("inclusive_per_call) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.statement = this.db.prepareStatement(this.buf.toString());
        this.statement.setInt(1, n2);
        this.statement.setInt(2, this.curNode);
        this.statement.setInt(3, this.curContext);
        this.statement.setInt(4, this.curThread);
        this.statement.setInt(5, n);
        if (this.mainInclusive == 0.0) {
            this.statement.setDouble(6, 0.0);
        } else {
            this.statement.setDouble(6, performanceResult.getInclusive(n3, string, string2) / this.mainInclusive);
        }
        this.statement.setDouble(7, performanceResult.getInclusive(n3, string, string2));
        if (this.mainInclusive == 0.0) {
            this.statement.setDouble(8, 0.0);
        } else {
            this.statement.setDouble(8, performanceResult.getExclusive(n3, string, string2) / this.mainInclusive);
        }
        this.statement.setDouble(9, performanceResult.getExclusive(n3, string, string2));
        this.statement.setDouble(10, performanceResult.getCalls(n3, string));
        this.statement.setDouble(11, performanceResult.getSubroutines(n3, string));
        if (performanceResult.getCalls(n3, string) == 0.0) {
            this.statement.setDouble(12, 0.0);
        } else {
            this.statement.setDouble(12, performanceResult.getInclusive(n3, string, string2) / performanceResult.getCalls(n3, string));
            this.accumulators[6] = this.accumulators[6] + performanceResult.getInclusive(n3, string, string2) / performanceResult.getCalls(n3, string);
        }
        this.statement.execute();
        this.statement.close();
        if (this.mainInclusive != 0.0) {
            this.accumulators[0] = this.accumulators[0] + performanceResult.getInclusive(n3, string, string2) / this.mainInclusive;
        }
        this.accumulators[1] = this.accumulators[1] + performanceResult.getInclusive(n3, string, string2);
        if (this.mainInclusive != 0.0) {
            this.accumulators[2] = this.accumulators[2] + performanceResult.getExclusive(n3, string, string2) / this.mainInclusive;
        }
        this.accumulators[3] = this.accumulators[3] + performanceResult.getExclusive(n3, string, string2);
        this.accumulators[4] = this.accumulators[4] + performanceResult.getCalls(n3, string);
        this.accumulators[5] = this.accumulators[5] + performanceResult.getSubroutines(n3, string);
    }

    private void insertTotalAndAverage(PerformanceResult performanceResult, int n, int n2, String string, String string2) throws SQLException {
        this.buf = new StringBuilder();
        this.buf.append("insert into interval_total_summary (interval_event, metric, ");
        this.buf.append("inclusive_percentage, inclusive, ");
        if (this.db.getDBType().compareTo("oracle") == 0) {
            this.buf.append("exclusive_percentage, excl, ");
        } else {
            this.buf.append("exclusive_percentage, exclusive, ");
        }
        if (this.db.getDBType().compareTo("derby") == 0) {
            this.buf.append("num_calls, subroutines, ");
        } else {
            this.buf.append("call, subroutines, ");
        }
        this.buf.append("inclusive_per_call) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.statement = this.db.prepareStatement(this.buf.toString());
        this.statement.setInt(1, n2);
        this.statement.setInt(2, n);
        this.statement.setDouble(3, this.accumulators[0]);
        this.statement.setDouble(4, this.accumulators[1]);
        this.statement.setDouble(5, this.accumulators[2]);
        this.statement.setDouble(6, this.accumulators[3]);
        this.statement.setDouble(7, this.accumulators[4]);
        this.statement.setDouble(8, this.accumulators[5]);
        this.statement.setDouble(9, this.accumulators[6]);
        this.statement.execute();
        this.statement.close();
        this.buf = new StringBuilder();
        this.buf.append("insert into interval_mean_summary (interval_event, metric, ");
        this.buf.append("inclusive_percentage, inclusive, ");
        if (this.db.getDBType().compareTo("oracle") == 0) {
            this.buf.append("exclusive_percentage, excl, ");
        } else {
            this.buf.append("exclusive_percentage, exclusive, ");
        }
        if (this.db.getDBType().compareTo("derby") == 0) {
            this.buf.append("num_calls, subroutines, ");
        } else {
            this.buf.append("call, subroutines, ");
        }
        this.buf.append("inclusive_per_call) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.statement = this.db.prepareStatement(this.buf.toString());
        this.statement.setInt(1, n2);
        this.statement.setInt(2, n);
        int n3 = performanceResult.getThreads().size();
        this.statement.setDouble(3, this.accumulators[0] / (double)n3);
        this.statement.setDouble(4, this.accumulators[1] / (double)n3);
        this.statement.setDouble(5, this.accumulators[2] / (double)n3);
        this.statement.setDouble(6, this.accumulators[3] / (double)n3);
        this.statement.setDouble(7, this.accumulators[4] / (double)n3);
        this.statement.setDouble(8, this.accumulators[5] / (double)n3);
        this.statement.setDouble(9, this.accumulators[6] / (double)n3);
        this.statement.execute();
        this.statement.close();
    }

    private int insertEvent(String string) throws SQLException {
        int n = 0;
        this.buf = new StringBuilder();
        this.buf.append("select id from interval_event where trial = ? and name = ?");
        this.statement = this.db.prepareStatement(this.buf.toString());
        this.statement.setInt(1, this.trial.getID());
        this.statement.setString(2, string);
        ResultSet resultSet = this.statement.executeQuery();
        if (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        resultSet.close();
        this.statement.close();
        if (n == 0) {
            this.buf = new StringBuilder();
            this.buf.append("insert into interval_event (trial, name) values (?, ?)");
            this.statement = this.db.prepareStatement(this.buf.toString());
            this.statement.setInt(1, this.trial.getID());
            this.statement.setString(2, string);
            this.statement.execute();
            this.statement.close();
        }
        return n;
    }

    private int insertMetric(String string) throws SQLException, NumberFormatException {
        this.buf = new StringBuilder();
        this.buf.append("insert into metric (trial, name) values (?, ?) ");
        this.statement = this.db.prepareStatement(this.buf.toString());
        this.statement.setInt(1, this.trial.getID());
        this.statement.setString(2, string);
        this.statement.execute();
        this.statement.close();
        this.statement.close();
        String string2 = new String();
        string2 = this.db.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (this.db.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM metric" : (this.db.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM metric" : (this.db.getDBType().compareTo("oracle") == 0 ? "SELECT metric_id_seq.currval FROM DUAL" : "select currval('metric_id_seq');")));
        int n = Integer.parseInt(this.db.getDataItem(string2));
        return n;
    }

    public boolean isForceOverwrite() {
        return this.forceOverwrite;
    }

    public void setForceOverwrite(boolean bl) {
        this.forceOverwrite = bl;
    }
}

