/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.ClusterOperation;
import edu.uoregon.tau.perfexplorer.glue.KMeansOperation;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartKMeansOperation
extends AbstractPerformanceOperation {
    private Integer maxClusters = 2;
    private String metric;
    private int type;
    private double evaluation = 0.0;
    private double adjustedEvaluation = 0.0;

    public SmartKMeansOperation(PerformanceResult performanceResult, String string, int n, int n2) {
        super(performanceResult);
        this.metric = string;
        this.type = n;
        this.maxClusters = n2;
    }

    public SmartKMeansOperation(PerformanceResult performanceResult) {
        super(performanceResult);
    }

    public SmartKMeansOperation(Trial trial) {
        super(trial);
    }

    public SmartKMeansOperation(List<PerformanceResult> list) {
        super(list);
    }

    @Override
    public List<PerformanceResult> processData() {
        List<PerformanceResult> list = null;
        double d = 0.0;
        double d2 = 0.0;
        block0: for (PerformanceResult performanceResult : this.inputs) {
            for (int i = 1; i <= this.maxClusters; ++i) {
                KMeansOperation kMeansOperation = new KMeansOperation(performanceResult, this.metric, this.type, i);
                kMeansOperation.setComputeGapStatistic(true);
                list = ((ClusterOperation)kMeansOperation).processData();
                System.out.println("Gap Statistic for " + i + " clusters: " + kMeansOperation.getGapStatistic() + " +/- " + kMeansOperation.getGapStatisticError());
                System.out.println("Previous Gap statistic: " + d);
                double d3 = kMeansOperation.getGapStatistic();
                double d4 = kMeansOperation.getGapStatisticError();
                if (i == 1) {
                    this.outputs = list;
                    d = d3;
                    d2 = i;
                    continue;
                }
                if (d < 0.0 || d3 - d4 < 0.0 || d3 - 1.0 * d4 > d) {
                    this.outputs = list;
                    d = d3;
                    d2 = i;
                    continue;
                }
                if (d3 < 0.0 && d > 0.0) {
                    this.outputs = list;
                    d = d3;
                    d2 = i;
                    continue block0;
                }
                if (d2 < (double)(i - 1) || d3 < 0.0 && d > 0.0) continue block0;
            }
        }
        return this.outputs;
    }
}

