/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.DefaultResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitTrialClusters
extends AbstractPerformanceOperation {
    private List<PerformanceResult> clusterResults = null;
    private boolean includeNoisePoints = false;

    public SplitTrialClusters(PerformanceResult performanceResult, List<PerformanceResult> list) {
        super(performanceResult);
        this.clusterResults = list;
    }

    public SplitTrialClusters(List<PerformanceResult> list, List<PerformanceResult> list2) {
        super(list);
        this.clusterResults = list2;
    }

    @Override
    public List<PerformanceResult> processData() {
        int n = 0;
        for (PerformanceResult performanceResult : this.inputs) {
            int n2;
            int n3 = this.clusterResults.get(n * 5).getThreads().size();
            ArrayList<DefaultResult> arrayList = new ArrayList<DefaultResult>(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                arrayList.add(n2, new DefaultResult(performanceResult, false));
            }
            n2 = n3;
            for (Integer n4 : performanceResult.getThreads()) {
                int n5 = (int)this.clusterResults.get(n * 5 + 4).getCalls(n4, "Cluster ID");
                if (this.includeNoisePoints && n5 < 0) {
                    n2 = arrayList.size();
                    if (arrayList.size() == n2) {
                        arrayList.add(n2, new DefaultResult(performanceResult, false));
                    }
                }
                for (String string : performanceResult.getEvents()) {
                    if (n5 >= 0 && performanceResult.getCalls(n4, string) > 0.0) {
                        for (String string2 : performanceResult.getMetrics()) {
                            ((PerformanceResult)arrayList.get(n5)).putExclusive(n4, string, string2, performanceResult.getExclusive(n4, string, string2));
                            ((PerformanceResult)arrayList.get(n5)).putInclusive(n4, string, string2, performanceResult.getInclusive(n4, string, string2));
                        }
                        ((PerformanceResult)arrayList.get(n5)).putCalls(n4, string, performanceResult.getCalls(n4, string));
                        ((PerformanceResult)arrayList.get(n5)).putSubroutines(n4, string, performanceResult.getSubroutines(n4, string));
                        continue;
                    }
                    if (!this.includeNoisePoints || !(performanceResult.getCalls(n4, string) > 0.0)) continue;
                    for (String string2 : performanceResult.getMetrics()) {
                        ((PerformanceResult)arrayList.get(n2)).putExclusive(n4, string, string2, performanceResult.getExclusive(n4, string, string2));
                        ((PerformanceResult)arrayList.get(n2)).putInclusive(n4, string, string2, performanceResult.getInclusive(n4, string, string2));
                    }
                    ((PerformanceResult)arrayList.get(n2)).putCalls(n4, string, performanceResult.getCalls(n4, string));
                    ((PerformanceResult)arrayList.get(n2)).putSubroutines(n4, string, performanceResult.getSubroutines(n4, string));
                }
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                this.outputs.add(arrayList.get(i));
                System.out.println(((PerformanceResult)arrayList.get(i)).getThreads());
            }
            ++n;
        }
        return this.outputs;
    }

    public void setIncludeNoisePoints(boolean bl) {
        this.includeNoisePoints = bl;
    }

    public boolean getIncludeNoisePoints() {
        return this.includeNoisePoints;
    }
}

