/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.AbstractPerformanceOperation;
import edu.uoregon.tau.perfexplorer.glue.DefaultResult;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.glue.Utilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopXEvents
extends AbstractPerformanceOperation
implements Serializable {
    protected Double threshold = 0.0;
    protected String metric = null;
    protected Integer type = 0;
    protected List<String> sortedEventNames = new ArrayList<String>();

    public TopXEvents(PerformanceResult performanceResult, String string, int n, double d) {
        super(performanceResult);
        this.threshold = d;
        this.metric = string;
        this.type = n;
    }

    public TopXEvents(Trial trial, String string, int n, double d) {
        super(trial);
        this.threshold = d;
        this.metric = string;
        this.type = n;
    }

    public TopXEvents(List<PerformanceResult> list, String string, int n, double d) {
        super(list);
        this.threshold = d;
        this.metric = string;
        this.type = n;
    }

    @Override
    public List<PerformanceResult> processData() {
        Serializable serializable;
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        block0: for (PerformanceResult performanceResult : this.inputs) {
            serializable = Integer.valueOf(0);
            for (String string : performanceResult.getEvents()) {
                hashMap.put(string, performanceResult.getDataPoint((Integer)serializable, string, this.metric, this.type));
            }
            Iterator<String> iterator = Utilities.sortHashMapByValues(hashMap, false);
            int n = 1;
            for (String string2 : iterator.keySet()) {
                this.sortedEventNames.add(string2);
                if (!((double)(++n) > this.threshold)) continue;
                continue block0;
            }
        }
        for (PerformanceResult performanceResult : this.inputs) {
            serializable = new DefaultResult(performanceResult, false);
            this.outputs.add(serializable);
            for (String string : this.sortedEventNames) {
                for (String string2 : performanceResult.getMetrics()) {
                    for (Integer n : performanceResult.getThreads()) {
                        serializable.putExclusive(n, string, string2, performanceResult.getExclusive(n, string, string2));
                        serializable.putInclusive(n, string, string2, performanceResult.getInclusive(n, string, string2));
                        serializable.putCalls(n, string, performanceResult.getCalls(n, string));
                        serializable.putSubroutines(n, string, performanceResult.getSubroutines(n, string));
                    }
                }
            }
            serializable.updateEventMap();
        }
        return this.outputs;
    }

    public List<String> getSortedEventNames() {
        return this.sortedEventNames;
    }
}

