/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfexplorer.common.RMISortableIntervalEvent;
import edu.uoregon.tau.perfexplorer.glue.AbstractResult;
import edu.uoregon.tau.perfexplorer.glue.Utilities;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class TrialResult
extends AbstractResult {
    private boolean callPath = true;

    public TrialResult() {
    }

    public TrialResult(TrialResult trialResult) {
        super(trialResult);
    }

    public TrialResult(Trial trial) {
        this.trialID = trial.getID();
        this.trial = trial;
        this.name = this.trial.getName();
        this.buildTrialResult(trial, null, null, null);
    }

    public TrialResult(Trial trial, String string, String string2, String string3, boolean bl) {
        this.trialID = trial.getID();
        this.trial = trial;
        this.callPath = bl;
        this.name = this.trial.getName();
        this.buildTrialResult(trial, string, string2, string3);
    }

    private void buildTrialResult(Trial trial, String string, String string2, String string3) {
        DB dB = PerfExplorerServer.getServer().getDB();
        StringBuilder stringBuilder = null;
        PreparedStatement preparedStatement = null;
        try {
            Object object;
            int n = Integer.parseInt(trial.getField("threads_per_context"));
            int n2 = Integer.parseInt(trial.getField("contexts_per_node")) * n;
            stringBuilder = new StringBuilder();
            stringBuilder.append("select e.name, ");
            stringBuilder.append("m.name, ");
            stringBuilder.append("(p.node * " + n2 + ") + ");
            stringBuilder.append("(p.context * " + n + ") + ");
            stringBuilder.append("p.thread as thread, ");
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuilder.append("p.excl, ");
            } else {
                stringBuilder.append("p.exclusive, ");
            }
            stringBuilder.append("p.inclusive, ");
            if (dB.getDBType().compareTo("derby") == 0) {
                stringBuilder.append("p.num_calls, ");
            } else {
                stringBuilder.append("p.call, ");
            }
            stringBuilder.append("p.subroutines, e.id ");
            stringBuilder.append("from interval_event e ");
            stringBuilder.append("left outer join interval_location_profile p ");
            stringBuilder.append("on e.id = p.interval_event ");
            stringBuilder.append("left outer join metric m on m.trial = e.trial ");
            stringBuilder.append("and m.id = p.metric ");
            stringBuilder.append("where e.trial = ? ");
            if (string != null) {
                stringBuilder.append(" and m.name = ? ");
            }
            if (string2 != null) {
                stringBuilder.append(" and e.name = ? ");
            }
            if (string3 != null) {
                stringBuilder.append(" and thread = ? ");
            }
            if (!this.callPath) {
                stringBuilder.append(" and (e.group_name is null or e.group_name not like '%TAU_CALLPATH%') ");
            }
            stringBuilder.append(" order by 3,2,1 ");
            preparedStatement = dB.prepareStatement(stringBuilder.toString());
            preparedStatement.setInt(1, trial.getID());
            int n3 = 2;
            if (string != null) {
                preparedStatement.setString(n3++, string);
            }
            if (string2 != null) {
                preparedStatement.setString(n3++, string2);
            }
            if (string3 != null) {
                preparedStatement.setString(n3++, string3);
            }
            long l = System.currentTimeMillis();
            ResultSet resultSet = preparedStatement.executeQuery();
            long l2 = System.currentTimeMillis() - l;
            float f = (float)l2 / 1000.0f;
            System.out.println("Time to query interval data: " + f + " seconds");
            while (resultSet.next()) {
                object = resultSet.getString(1);
                Integer n4 = resultSet.getInt(3);
                this.putExclusive(n4, (String)object, resultSet.getString(2), resultSet.getDouble(4));
                this.putInclusive(n4, (String)object, resultSet.getString(2), resultSet.getDouble(5));
                this.putCalls(n4, (String)object, resultSet.getDouble(6));
                this.putSubroutines(n4, (String)object, resultSet.getDouble(7));
                Integer n5 = resultSet.getInt(8);
                this.eventMap.put(n5, object);
            }
            resultSet.close();
            preparedStatement.close();
            stringBuilder = new StringBuilder();
            stringBuilder.append("select a.name, ");
            stringBuilder.append("(p.node * " + n2 + ") + ");
            stringBuilder.append("(p.context * " + n + ") + ");
            stringBuilder.append("p.thread as thread, ");
            stringBuilder.append("p.sample_count, ");
            stringBuilder.append("p.maximum_value, ");
            stringBuilder.append("p.minimum_value, ");
            stringBuilder.append("p.mean_value, ");
            stringBuilder.append("p.standard_deviation ");
            stringBuilder.append("from atomic_event a ");
            stringBuilder.append("left outer join atomic_location_profile p ");
            stringBuilder.append("on a.id = p.atomic_event ");
            stringBuilder.append("where a.trial = ? ");
            stringBuilder.append(" order by 2,1 ");
            preparedStatement = dB.prepareStatement(stringBuilder.toString());
            preparedStatement.setInt(1, trial.getID());
            l = System.currentTimeMillis();
            resultSet = preparedStatement.executeQuery();
            l2 = System.currentTimeMillis() - l;
            f = (float)l2 / 1000.0f;
            System.out.println("Time to query counter data: " + f + " seconds");
            while (resultSet.next()) {
                object = resultSet.getInt(2);
                this.putUsereventNumevents(resultSet.getInt(2), resultSet.getString(1), resultSet.getDouble(3));
                this.putUsereventMax(resultSet.getInt(2), resultSet.getString(1), resultSet.getDouble(4));
                this.putUsereventMin(resultSet.getInt(2), resultSet.getString(1), resultSet.getDouble(5));
                this.putUsereventMean(resultSet.getInt(2), resultSet.getString(1), resultSet.getDouble(6));
                this.putUsereventSumsqr(resultSet.getInt(2), resultSet.getString(1), resultSet.getDouble(7));
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
            sQLException.printStackTrace();
            if (preparedStatement != null) {
                System.err.println(preparedStatement);
            }
            System.err.println(stringBuilder);
        }
    }

    public String toString() {
        return this.trial.getName();
    }

    public String getEventGroupName(String string) {
        String string2 = null;
        List<RMISortableIntervalEvent> list = Utilities.getEventsForTrial(this.trial, 0);
        for (RMISortableIntervalEvent rMISortableIntervalEvent : list) {
            if (!rMISortableIntervalEvent.getName().equals(string)) continue;
            string2 = rMISortableIntervalEvent.getGroup();
        }
        return string2;
    }
}

