/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfexplorer.glue.AbstractResult;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TrialTotalResult
extends AbstractResult {
    private Integer originalThreads = 0;

    public TrialTotalResult() {
    }

    public TrialTotalResult(TrialTotalResult trialTotalResult) {
        super(trialTotalResult);
    }

    public TrialTotalResult(Trial trial) {
        this.trial = trial;
        this.trialID = trial.getID();
        this.name = this.trial.getName();
        this.buildTrialTotalResult(trial, null, null);
    }

    public TrialTotalResult(Trial trial, String string, String string2) {
        this.trial = trial;
        this.trialID = trial.getID();
        this.name = this.trial.getName();
        this.buildTrialTotalResult(trial, string, string2);
    }

    private void buildTrialTotalResult(Trial trial, String string, String string2) {
        DB dB = PerfExplorerServer.getServer().getDB();
        try {
            int n = Integer.parseInt(trial.getField("threads_per_context"));
            int n2 = Integer.parseInt(trial.getField("contexts_per_node")) * n;
            this.originalThreads = n2 * Integer.parseInt(trial.getField("node_count"));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select e.name, ");
            stringBuilder.append("m.name, ");
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuilder.append("p.excl, ");
            } else {
                stringBuilder.append("p.exclusive, ");
            }
            stringBuilder.append("p.inclusive, ");
            if (dB.getDBType().compareTo("derby") == 0) {
                stringBuilder.append("p.num_calls, ");
            } else {
                stringBuilder.append("p.call, ");
            }
            stringBuilder.append("p.subroutines, e.id ");
            stringBuilder.append("from interval_event e ");
            stringBuilder.append("left outer join interval_total_summary p ");
            stringBuilder.append("on e.id = p.interval_event ");
            stringBuilder.append("left outer join metric m on m.trial = e.trial ");
            stringBuilder.append("and m.id = p.metric ");
            stringBuilder.append("where e.trial = ? ");
            if (string != null) {
                stringBuilder.append(" and m.name = ? ");
            }
            if (string2 != null) {
                stringBuilder.append(" and e.name = ? ");
            }
            stringBuilder.append(" order by 2,1 ");
            PreparedStatement preparedStatement = dB.prepareStatement(stringBuilder.toString());
            preparedStatement.setInt(1, trial.getID());
            int n3 = 1;
            if (string != null) {
                preparedStatement.setString(n3++, string);
            }
            if (string2 != null) {
                preparedStatement.setString(n3++, string2);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                this.putExclusive(0, string3, string4, resultSet.getDouble(3));
                this.putInclusive(0, string3, string4, resultSet.getDouble(4));
                this.putCalls(0, string3, resultSet.getDouble(5));
                this.putSubroutines(0, string3, resultSet.getDouble(6));
                Integer n4 = resultSet.getInt(7);
                this.eventMap.put(n4, string3);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
            sQLException.printStackTrace();
        }
    }

    public Integer getTrialID() {
        return this.trialID;
    }

    public void setTrialID(Integer n) {
        this.trialID = n;
    }

    public Integer getOriginalThreads() {
        return this.originalThreads;
    }

    public void setOriginalThreads(Integer n) {
        this.originalThreads = n;
    }
}

