/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue.psl;

import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.SourceRegion;
import edu.uoregon.tau.perfexplorer.glue.TrialResult;
import edu.uoregon.tau.perfexplorer.glue.psl.CodeRegion;
import edu.uoregon.tau.perfexplorer.glue.psl.CodeRegionFilter;
import edu.uoregon.tau.perfexplorer.glue.psl.RegionSummary;
import edu.uoregon.tau.perfexplorer.glue.psl.RegionSummaryIterator;
import edu.uoregon.tau.perfexplorer.glue.psl.SourceFile;
import edu.uoregon.tau.perfexplorer.glue.psl.Version;
import edu.uoregon.tau.perfexplorer.glue.psl.VirtualMachine;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Experiment {
    private Version version = null;
    private Date startTime = null;
    private Date endTime = null;
    private String commandLine = null;
    private String compiler = null;
    private String compilerOptions = null;
    private Set<RegionSummary> regionSummaries = null;
    private Set<VirtualMachine> virtualMachines = null;
    private TrialResult trialResult = null;
    private CodeRegion topCodeRegion = null;
    private int numberOfProcessingUnits = 1;

    public Experiment(Version version) {
        this.version = version;
        this.regionSummaries = new HashSet<RegionSummary>();
        this.virtualMachines = new HashSet<VirtualMachine>();
    }

    public Experiment(Version version, TrialResult trialResult) {
        this.version = version;
        this.trialResult = trialResult;
        this.regionSummaries = new HashSet<RegionSummary>();
        this.virtualMachines = new HashSet<VirtualMachine>();
        this.loadEverything();
    }

    public int getNumberOfProcessingUnits() {
        return this.numberOfProcessingUnits;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setCommandLine(String string) {
        this.commandLine = string;
    }

    public String getCompiler() {
        return this.compiler;
    }

    public void setCompiler(String string) {
        this.compiler = string;
    }

    public String getCompilerOptions() {
        return this.compilerOptions;
    }

    public void setCompilerOptions(String string) {
        this.compilerOptions = string;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date date) {
        this.endTime = date;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date date) {
        this.startTime = date;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public void addRegionSummary(RegionSummary regionSummary) {
        this.regionSummaries.add(regionSummary);
    }

    public Set<RegionSummary> getRegionSummaries() {
        return this.regionSummaries;
    }

    public void setRegionSummaries(Set<RegionSummary> set) {
        this.regionSummaries = set;
    }

    public void addVirtualMachine(VirtualMachine virtualMachine) {
        this.virtualMachines.add(virtualMachine);
    }

    public Set<VirtualMachine> getVirtualMachines() {
        return this.virtualMachines;
    }

    public void setVirtualMachines(Set<VirtualMachine> set) {
        this.virtualMachines = set;
    }

    public RegionSummaryIterator summaryIterator(CodeRegionFilter codeRegionFilter) {
        RegionSummaryIterator regionSummaryIterator = new RegionSummaryIterator(codeRegionFilter, this);
        return regionSummaryIterator;
    }

    public RegionSummaryIterator summaryIterator() {
        RegionSummaryIterator regionSummaryIterator = new RegionSummaryIterator(this);
        return regionSummaryIterator;
    }

    private void loadEverything() {
        this.numberOfProcessingUnits = this.trialResult.getThreads().size();
        boolean bl = false;
        for (String string : this.trialResult.getEvents()) {
            if (!Function.isCallPathFunction((String)string)) continue;
            bl = true;
        }
        this.topCodeRegion = !bl ? this.buildNonCallpathCodeRegion() : this.buildCallpathCodeRegion(this.trialResult.getMainEvent());
    }

    private CodeRegion buildNonCallpathCodeRegion() {
        CodeRegion codeRegion = null;
        for (String string : this.trialResult.getEvents()) {
            CodeRegion codeRegion2 = this.createCodeRegion(string);
            if (this.trialResult.getMainEvent().equals(string)) {
                codeRegion = codeRegion2;
            }
            for (Integer n : this.trialResult.getThreads()) {
                RegionSummary regionSummary = new RegionSummary(this, codeRegion2, n.toString());
                regionSummary.setInclusiveTime(this.trialResult.getInclusive(n, string, this.trialResult.getTimeMetric()));
                regionSummary.setExclusiveTime(this.trialResult.getExclusive(n, string, this.trialResult.getTimeMetric()));
                regionSummary.setTotalInstructions(this.trialResult.getExclusive(n, string, this.trialResult.getTotalInstructionMetric()));
                regionSummary.setFloatingPointInstructions(this.trialResult.getExclusive(n, string, this.trialResult.getFPMetric()));
                double[] dArray = new double[]{0.0, 0.0, 0.0};
                double[] dArray2 = new double[]{0.0, 0.0, 0.0};
                dArray2[0] = this.trialResult.getExclusive(n, string, this.trialResult.getL1MissMetric());
                dArray2[1] = this.trialResult.getExclusive(n, string, this.trialResult.getL2MissMetric());
                dArray2[2] = this.trialResult.getExclusive(n, string, this.trialResult.getL3MissMetric());
                regionSummary.setCacheMisses(dArray2);
                dArray[0] = this.trialResult.getExclusive(n, string, this.trialResult.getL1AccessMetric());
                dArray[1] = this.trialResult.getExclusive(n, string, this.trialResult.getL2AccessMetric());
                dArray[2] = this.trialResult.getExclusive(n, string, this.trialResult.getL3AccessMetric());
                regionSummary.setCacheAccesses(dArray);
                regionSummary.setProcessingUnit(n.toString());
            }
        }
        return codeRegion;
    }

    private CodeRegion buildCallpathCodeRegion(String string) {
        Object object;
        CodeRegion codeRegion = this.createCodeRegion(string);
        for (Integer object2 : this.trialResult.getThreads()) {
            RegionSummary regionSummary = new RegionSummary(this, codeRegion, object2.toString());
            regionSummary.setInclusiveTime(this.trialResult.getInclusive(object2, string, this.trialResult.getTimeMetric()));
            regionSummary.setExclusiveTime(this.trialResult.getExclusive(object2, string, this.trialResult.getTimeMetric()));
            regionSummary.setTotalInstructions(this.trialResult.getExclusive(object2, string, this.trialResult.getTotalInstructionMetric()));
            regionSummary.setFloatingPointInstructions(this.trialResult.getExclusive(object2, string, this.trialResult.getFPMetric()));
            object = new double[]{0.0, 0.0, 0.0};
            double[] dArray = new double[]{0.0, 0.0, 0.0};
            double[] dArray2 = new double[]{0.0, 0.0, 0.0};
            object[0] = this.trialResult.getExclusive(object2, string, this.trialResult.getL1MissMetric());
            object[1] = this.trialResult.getExclusive(object2, string, this.trialResult.getL2MissMetric());
            object[2] = this.trialResult.getExclusive(object2, string, this.trialResult.getL3MissMetric());
            regionSummary.setCacheMisses((double[])object);
            dArray2[0] = this.trialResult.getExclusive(object2, string, this.trialResult.getL1AccessMetric());
            dArray2[1] = this.trialResult.getExclusive(object2, string, this.trialResult.getL2AccessMetric());
            dArray2[2] = this.trialResult.getExclusive(object2, string, this.trialResult.getL3AccessMetric());
            regionSummary.setCacheAccesses(dArray2);
            regionSummary.setProcessingUnit(object2.toString());
        }
        for (String string2 : this.trialResult.getEvents()) {
            if (!string2.startsWith(string) || !Function.isCallPathFunction((String)string2)) continue;
            int n = string2.indexOf(" => ");
            object = string2.substring(n + 4);
            this.buildCallpathCodeRegion((String)object);
        }
        return codeRegion;
    }

    private CodeRegion createCodeRegion(String string) {
        SourceRegion sourceRegion = Function.getSourceLink((String)string);
        String string2 = sourceRegion.getFilename();
        CodeRegion codeRegion = null;
        if (string2 == null) {
            if (string.startsWith("MPI_")) {
                SourceFile sourceFile = this.version.addSourceFile("MPI");
                codeRegion = new CodeRegion(sourceFile);
                codeRegion.setShortName(string);
                codeRegion.setGroupType(CodeRegion.GroupType.MPI);
            } else {
                SourceFile sourceFile = this.version.addSourceFile("UNKNOWN");
                codeRegion = new CodeRegion(sourceFile);
                codeRegion.setShortName(string);
                codeRegion.setGroupType(CodeRegion.GroupType.GENERAL);
            }
        } else {
            SourceFile sourceFile = this.version.addSourceFile(string2.trim());
            codeRegion = new CodeRegion(sourceFile);
            codeRegion.setShortName(Experiment.removeSource(string).trim());
            codeRegion.setStartPositionLine(sourceRegion.getStartLine());
            codeRegion.setStartPositionColumn(sourceRegion.getStartColumn());
            codeRegion.setEndPositionLine(sourceRegion.getEndLine());
            codeRegion.setEndPositionColumn(sourceRegion.getEndColumn());
        }
        codeRegion.setLongName(string);
        return codeRegion;
    }

    private static String removeSource(String string) {
        if (string.startsWith("Loop:")) {
            return string;
        }
        while (string.indexOf("[{") != -1) {
            int n = string.indexOf("[{");
            int n2 = string.indexOf("}]");
            string = string.substring(0, n) + string.substring(n2 + 2);
        }
        return string;
    }

    public CodeRegion getTopCodeRegion() {
        return this.topCodeRegion;
    }

    public void setTopCodeRegion(CodeRegion codeRegion) {
        this.topCodeRegion = codeRegion;
    }
}

