/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue.psl;

import edu.uoregon.tau.perfexplorer.glue.psl.Experiment;
import edu.uoregon.tau.perfexplorer.glue.psl.RegionSummary;
import edu.uoregon.tau.perfexplorer.glue.psl.RegionSummaryFilter;
import java.util.Iterator;
import java.util.Set;

public class RegionSummaryIterator
implements Iterator {
    private RegionSummaryFilter filter = null;
    private Iterator<RegionSummary> summaries = null;
    private Set<RegionSummary> summarySet = null;
    private RegionSummary currentSummary = null;

    public RegionSummaryIterator(RegionSummaryFilter regionSummaryFilter, Experiment experiment) {
        this.filter = regionSummaryFilter;
        this.summarySet = experiment.getRegionSummaries();
        this.reset();
    }

    public RegionSummaryIterator(Experiment experiment) {
        this.summarySet = experiment.getRegionSummaries();
        this.reset();
    }

    public boolean hasNext() {
        return this.currentSummary != null;
    }

    public RegionSummary next() {
        RegionSummary regionSummary = this.currentSummary;
        if (regionSummary != null) {
            this.getNext();
        }
        return regionSummary;
    }

    private void getNext() {
        this.currentSummary = null;
        while (this.summaries.hasNext()) {
            RegionSummary regionSummary = this.summaries.next();
            if (this.filter != null) {
                if (!this.filter.accept(regionSummary)) continue;
                this.currentSummary = regionSummary;
                break;
            }
            this.currentSummary = regionSummary;
            break;
        }
    }

    public void remove() {
    }

    public RegionSummaryFilter getFilter() {
        return this.filter;
    }

    public void setFilter(RegionSummaryFilter regionSummaryFilter) {
        this.filter = regionSummaryFilter;
    }

    public void reset() {
        this.summaries = this.summarySet.iterator();
        this.getNext();
    }
}

