/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.rules;

import edu.uoregon.tau.perfexplorer.rules.SelfAsserting;
import edu.uoregon.tau.perfexplorer.rules.WorkingMemoryStringLogger;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import org.drools.FactHandle;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.compiler.PackageBuilder;
import org.drools.rule.Package;

public class RuleHarness {
    private WorkingMemory workingMemory = null;
    private RuleBase ruleBase = null;
    private WorkingMemoryStringLogger logger = null;
    private PackageBuilder builder = null;
    private static RuleHarness instance = null;

    public static RuleHarness useGlobalRules(String string) {
        instance = new RuleHarness(string);
        return instance;
    }

    public RuleHarness(String string) {
        try {
            this.readRule(string);
            this.workingMemory = this.ruleBase.newWorkingMemory();
            this.logger = new WorkingMemoryStringLogger(this.workingMemory);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void addRules(String string) {
        try {
            this.readRule(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void processRules() {
        try {
            System.out.println("Firing rules...\n");
            this.workingMemory.fireAllRules();
            System.out.println("...done with rules.");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static FactHandle assertObject(Object object) {
        FactHandle factHandle = null;
        RuleHarness ruleHarness = RuleHarness.getInstance();
        if (ruleHarness != null) {
            factHandle = ruleHarness.workingMemory.assertObject(object);
            if (object instanceof SelfAsserting) {
                SelfAsserting selfAsserting = (SelfAsserting)object;
                selfAsserting.assertFacts(ruleHarness);
            }
        }
        return factHandle;
    }

    public static void retractObject(FactHandle factHandle) {
        RuleHarness ruleHarness = RuleHarness.getInstance();
        if (ruleHarness != null) {
            ruleHarness.workingMemory.retractObject(factHandle);
        }
    }

    private void readRule(String string) throws Exception {
        if (string == null) {
            string = "/rules/PerfExplorer.drl";
        }
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(RuleHarness.class.getResourceAsStream(string));
        }
        catch (Exception exception) {
            try {
                inputStreamReader = new FileReader(string);
            }
            catch (Exception exception2) {
                System.err.println("Error reading rules!");
                System.err.println(exception.getMessage());
                System.err.println(exception2.getMessage());
                exception.printStackTrace(System.err);
                return;
            }
        }
        if (inputStreamReader == null) {
            System.err.println("Unable to read rules...");
            return;
        }
        if (this.builder == null) {
            this.builder = new PackageBuilder();
        }
        System.out.print("Reading rules: " + string + "...");
        this.builder.addPackageFromDrl((Reader)inputStreamReader);
        System.out.println(" done.");
        Package package_ = this.builder.getPackage();
        if (this.ruleBase == null) {
            this.ruleBase = RuleBaseFactory.newRuleBase();
        }
        try {
            this.ruleBase.addPackage(package_);
        }
        catch (Exception exception) {
            System.err.println("\n\n\t!!! ERROR PARSING RULES !!!\n\n");
            System.err.println(exception.toString());
            Thread thread = Thread.currentThread();
            thread.interrupt();
        }
    }

    public String getLog() {
        return this.logger.toString();
    }

    public static RuleHarness getInstance() {
        return instance;
    }
}

