/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.server;

import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfexplorer.clustering.ClusterException;
import edu.uoregon.tau.perfexplorer.clustering.ClusterInterface;
import edu.uoregon.tau.perfexplorer.clustering.DBScanClusterInterface;
import edu.uoregon.tau.perfexplorer.clustering.DataNormalizer;
import edu.uoregon.tau.perfexplorer.clustering.HierarchicalCluster;
import edu.uoregon.tau.perfexplorer.clustering.KMeansClusterInterface;
import edu.uoregon.tau.perfexplorer.clustering.RawDataInterface;
import edu.uoregon.tau.perfexplorer.clustering.weka.AnalysisFactory;
import edu.uoregon.tau.perfexplorer.common.AnalysisType;
import edu.uoregon.tau.perfexplorer.common.ChartType;
import edu.uoregon.tau.perfexplorer.common.PerfExplorerException;
import edu.uoregon.tau.perfexplorer.common.PerfExplorerOutput;
import edu.uoregon.tau.perfexplorer.common.RMIPerfExplorerModel;
import edu.uoregon.tau.perfexplorer.server.DataUtils;
import edu.uoregon.tau.perfexplorer.server.DendrogramTree;
import edu.uoregon.tau.perfexplorer.server.ImageUtils;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import edu.uoregon.tau.perfexplorer.server.Thumbnail;
import edu.uoregon.tau.perfexplorer.server.VirtualTopology;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.util.Hashtable;
import java.util.List;
import java.util.TimerTask;

public class AnalysisTask
extends TimerTask {
    private ChartType chartType = ChartType.DENDROGRAM;
    private RMIPerfExplorerModel modelData = null;
    private PerfExplorerServer server = null;
    private DatabaseAPI session = null;
    private int analysisID = 0;
    private int numTotalThreads = 0;
    private RawDataInterface rawData = null;
    private List<String> eventIDs = null;
    private double rCorrelation = 0.0;
    private boolean correlateToMain = false;
    private int connectionIndex = 0;

    public AnalysisTask(PerfExplorerServer perfExplorerServer, DatabaseAPI databaseAPI, int n) {
        this.server = perfExplorerServer;
        this.session = databaseAPI;
        this.connectionIndex = n;
    }

    public void saveAnalysisResult(String string, String string2, String string3, boolean bl) throws PerfExplorerException {
        Thumbnail.createThumbnail(string2, string3, bl);
        try {
            DB dB = this.session.db();
            PreparedStatement preparedStatement = null;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("insert into analysis_result (analysis_settings, ");
            stringBuilder.append("description, thumbnail_size, image_size, thumbnail, ");
            stringBuilder.append("image, result_type) values ");
            stringBuilder.append("(?, ?, ?, ?, ?, ?, ?) ");
            preparedStatement = dB.prepareStatement(stringBuilder.toString());
            preparedStatement.setInt(1, this.analysisID);
            preparedStatement.setString(2, string2);
            File file = new File(string2);
            FileInputStream fileInputStream = new FileInputStream(file);
            File file2 = new File(string3);
            FileInputStream fileInputStream2 = new FileInputStream(file2);
            preparedStatement.setInt(3, (int)file2.length());
            preparedStatement.setInt(4, (int)file.length());
            preparedStatement.setBinaryStream(5, (InputStream)fileInputStream2, (int)file2.length());
            preparedStatement.setBinaryStream(6, (InputStream)fileInputStream, (int)file.length());
            preparedStatement.setInt(7, Integer.parseInt(this.chartType.toString()));
            preparedStatement.executeUpdate();
            fileInputStream.close();
            preparedStatement.close();
            file.delete();
            file2.delete();
        }
        catch (Exception exception) {
            String string4 = "ERROR: Couldn't insert the analysis results into the database!";
            System.err.println(string4);
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            throw new PerfExplorerException(string4, exception);
        }
    }

    public void saveAnalysisResult(RawDataInterface rawDataInterface, RawDataInterface rawDataInterface2, File file, File file2) throws PerfExplorerException {
        DB dB = this.session.db();
        try {
            dB.setAutoCommit(false);
            PreparedStatement preparedStatement = null;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("insert into analysis_result ");
            stringBuilder.append(" (analysis_settings, description, thumbnail_size, thumbnail, image_size, image, result_type) values (?, ?, ?, ?, ?, ?, ?)");
            preparedStatement = dB.prepareStatement(stringBuilder.toString());
            preparedStatement.setInt(1, this.analysisID);
            preparedStatement.setString(2, new String("analysis_result"));
            FileInputStream fileInputStream = new FileInputStream(file);
            preparedStatement.setInt(3, (int)file2.length());
            preparedStatement.setBinaryStream(4, (InputStream)fileInputStream, (int)file.length());
            FileInputStream fileInputStream2 = new FileInputStream(file2);
            preparedStatement.setInt(5, (int)file2.length());
            preparedStatement.setBinaryStream(6, (InputStream)fileInputStream2, (int)file2.length());
            preparedStatement.setInt(7, Integer.parseInt(this.chartType.toString()));
            preparedStatement.executeUpdate();
            preparedStatement.close();
            dB.commit();
            dB.setAutoCommit(true);
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't insert the analysis results into the database!";
            System.err.println(string);
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            try {
                dB.setAutoCommit(true);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new PerfExplorerException(string, exception);
        }
    }

    public DendrogramTree createDendrogramTree(int[] nArray, double[] dArray) {
        DendrogramTree dendrogramTree = null;
        DendrogramTree dendrogramTree2 = null;
        DendrogramTree dendrogramTree3 = null;
        Hashtable<Integer, DendrogramTree> hashtable = new Hashtable<Integer, DendrogramTree>(nArray.length);
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            dendrogramTree = nArray[n] < 0 ? new DendrogramTree(nArray[n], 0.0) : (DendrogramTree)hashtable.get(new Integer(nArray[n]));
            dendrogramTree2 = nArray[++n] < 0 ? new DendrogramTree(nArray[n], 0.0) : (DendrogramTree)hashtable.get(new Integer(nArray[n]));
            ++n;
            dendrogramTree3 = new DendrogramTree(i + 1, dArray[i]);
            dendrogramTree3.setLeftAndRight(dendrogramTree, dendrogramTree2);
            hashtable.put(new Integer(i + 1), dendrogramTree3);
        }
        return dendrogramTree3;
    }

    public RawDataInterface doDimensionReduction() {
        return this.rawData;
    }

    public void run() {
        this.modelData = this.server.getNextRequest(this.connectionIndex);
        if (this.modelData != null) {
            this.analysisID = this.modelData.getAnalysisID();
            try {
                PerfExplorerOutput.println("Processing " + this.modelData.toString());
                this.rawData = DataUtils.getRawData(this.session, this.modelData);
                this.eventIDs = this.rawData.getEventNames();
                this.numTotalThreads = this.rawData.numVectors();
                RawDataInterface rawDataInterface = this.doDimensionReduction();
                if (this.modelData.getClusterMethod().equals(AnalysisType.K_MEANS)) {
                    int n = this.numTotalThreads <= this.modelData.getNumberOfClusters() ? this.numTotalThreads - 1 : this.modelData.getNumberOfClusters();
                    for (int i = 2; i <= n; ++i) {
                        PerfExplorerOutput.println("Doing " + i + " clusters:" + this.modelData.toString());
                        KMeansClusterInterface kMeansClusterInterface = AnalysisFactory.createKMeansEngine();
                        kMeansClusterInterface.setInputData(rawDataInterface);
                        kMeansClusterInterface.setK(i);
                        kMeansClusterInterface.findClusters();
                        this.saveClusterResults(kMeansClusterInterface, rawDataInterface);
                    }
                    System.out.println("...done clustering.");
                } else if (this.modelData.getClusterMethod().equals(AnalysisType.HIERARCHICAL)) {
                    int n = this.numTotalThreads <= this.modelData.getNumberOfClusters() ? this.numTotalThreads - 1 : this.modelData.getNumberOfClusters();
                    HierarchicalCluster hierarchicalCluster = AnalysisFactory.createHierarchicalClusteringEngine();
                    long l = System.currentTimeMillis();
                    hierarchicalCluster.setInputData(rawDataInterface);
                    long l2 = System.currentTimeMillis();
                    for (int i = 2; i <= n; ++i) {
                        PerfExplorerOutput.println("Doing " + i + " clusters:" + this.modelData.toString());
                        hierarchicalCluster.reset();
                        hierarchicalCluster.setK(i);
                        hierarchicalCluster.findClusters();
                        this.saveClusterResults(hierarchicalCluster, rawDataInterface);
                    }
                    System.out.println("...done clustering.");
                } else if (this.modelData.getClusterMethod().equals(AnalysisType.DBSCAN)) {
                    DBScanClusterInterface dBScanClusterInterface = AnalysisFactory.createDBScanEngine();
                    long l = System.currentTimeMillis();
                    DataNormalizer dataNormalizer = AnalysisFactory.createDataNormalizer(rawDataInterface);
                    rawDataInterface = dataNormalizer.getNormalizedData();
                    dBScanClusterInterface.setInputData(rawDataInterface);
                    long l3 = System.currentTimeMillis();
                    double[] dArray = dBScanClusterInterface.getKDistances();
                    int n = dBScanClusterInterface.guessEpsilonIndex();
                    double d = dArray[dArray.length - 1];
                    int n2 = 1;
                    int n3 = Math.min(50, n);
                    int[] nArray = null;
                    while (n3 > 0 && n > 0) {
                        boolean bl = false;
                        PerfExplorerOutput.println("Clustering with Epsilon = " + d + " : " + this.modelData.toString());
                        dBScanClusterInterface.setError(d);
                        dBScanClusterInterface.findClusters();
                        n2 = dBScanClusterInterface.getClusterSizes().length;
                        if (n2 < 2) {
                            System.out.println("No clusters found.");
                            d = dArray[--n];
                            --n3;
                            continue;
                        }
                        int[] nArray2 = dBScanClusterInterface.getClusterSizes();
                        if (nArray == null) {
                            bl = true;
                        } else if (nArray2.length != nArray.length && nArray2.length > nArray.length) {
                            bl = true;
                        }
                        if (bl) {
                            System.out.println(Integer.toString(n2) + " clusters found - saving results.");
                            this.saveClusterResults(dBScanClusterInterface, rawDataInterface);
                            nArray = nArray2;
                        } else {
                            System.out.println("No change in cluster membership - ignoring results.");
                        }
                        d = dArray[--n];
                        --n3;
                    }
                    System.out.println("...done clustering.");
                } else {
                    PerfExplorerOutput.println("Doing Correlation Analysis...");
                    this.chartType = ChartType.CORRELATION_SCATTERPLOT;
                    for (int i = 0; i < rawDataInterface.numDimensions(); ++i) {
                        for (int j = 0; j < rawDataInterface.numDimensions(); ++j) {
                            this.rCorrelation = rawDataInterface.getCorrelation(i, j);
                            File file = ImageUtils.generateCorrelationScatterplotThumbnail(this.chartType, this.modelData, rawDataInterface, i, j, this.correlateToMain);
                            File file2 = ImageUtils.generateCorrelationScatterplotImage(this.chartType, this.modelData, rawDataInterface, i, j, this.correlateToMain, this.rCorrelation);
                            this.saveAnalysisResult(rawDataInterface, rawDataInterface, file, file2);
                        }
                        PerfExplorerOutput.println("Finished: " + (i + 1) + " of " + rawDataInterface.numDimensions());
                    }
                    System.out.println("...done with correlation.");
                }
            }
            catch (PerfExplorerException perfExplorerException) {
                System.err.println(perfExplorerException.getMessage());
                perfExplorerException.printStackTrace();
            }
            catch (ClusterException clusterException) {
                System.err.println(clusterException.getMessage());
                clusterException.printStackTrace();
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                exception.printStackTrace();
            }
            this.server.taskFinished(this.connectionIndex);
            this.modelData = null;
        }
    }

    private void saveClusterResults(ClusterInterface clusterInterface, RawDataInterface rawDataInterface) throws PerfExplorerException, ClusterException {
        RawDataInterface[] rawDataInterfaceArray;
        Object object;
        Object object2;
        RawDataInterface rawDataInterface2 = clusterInterface.getClusterCentroids();
        RawDataInterface rawDataInterface3 = clusterInterface.getClusterStandardDeviations();
        int[] nArray = clusterInterface.getClusterSizes();
        File file = ImageUtils.generateClusterSizeThumbnail(this.modelData, nArray);
        File file2 = ImageUtils.generateClusterSizeImage(this.modelData, nArray);
        this.chartType = ChartType.HISTOGRAM;
        this.saveAnalysisResult(rawDataInterface2, rawDataInterface3, file, file2);
        if (this.modelData.getCurrentSelection() instanceof Metric) {
            object2 = AnalysisFactory.createPCAEngine(this.server.getCubeData(this.modelData, 4));
            object2.setInputData(rawDataInterface);
            object2.doPCA();
            object = object2.getResults();
            object2.setClusterer(clusterInterface);
            rawDataInterfaceArray = object2.getClusters();
            this.rCorrelation = 0.0;
            file = ImageUtils.generateClusterScatterplotThumbnail(ChartType.PCA_SCATTERPLOT, this.modelData, rawDataInterfaceArray);
            boolean bl = false;
            if (clusterInterface instanceof DBScanClusterInterface) {
                bl = true;
            }
            file2 = ImageUtils.generateClusterScatterplotImage(ChartType.PCA_SCATTERPLOT, this.modelData, (RawDataInterface)object, rawDataInterfaceArray, bl);
            this.saveAnalysisResult((RawDataInterface)object, (RawDataInterface)object, file, file2);
        }
        object2 = new VirtualTopology(this.modelData, clusterInterface);
        object = ((VirtualTopology)object2).getImage();
        rawDataInterfaceArray = ((VirtualTopology)object2).getThumbnail();
        this.saveAnalysisResult("Virtual Topology", (String)object, (String)rawDataInterfaceArray, false);
        this.chartType = ChartType.CLUSTER_MINIMUMS;
        file = ImageUtils.generateBreakdownThumbnail(this.modelData, clusterInterface.getClusterMinimums(), rawDataInterface3, this.eventIDs);
        file2 = ImageUtils.generateBreakdownImage(this.chartType, this.modelData, clusterInterface.getClusterMinimums(), rawDataInterface3, this.eventIDs);
        this.saveAnalysisResult(clusterInterface.getClusterMinimums(), rawDataInterface3, file, file2);
        this.chartType = ChartType.CLUSTER_AVERAGES;
        file = ImageUtils.generateBreakdownThumbnail(this.modelData, rawDataInterface2, rawDataInterface3, this.eventIDs);
        file2 = ImageUtils.generateBreakdownImage(this.chartType, this.modelData, rawDataInterface2, rawDataInterface3, this.eventIDs);
        this.saveAnalysisResult(rawDataInterface2, rawDataInterface3, file, file2);
        this.chartType = ChartType.CLUSTER_MAXIMUMS;
        file = ImageUtils.generateBreakdownThumbnail(this.modelData, clusterInterface.getClusterMaximums(), rawDataInterface3, this.eventIDs);
        file2 = ImageUtils.generateBreakdownImage(this.chartType, this.modelData, clusterInterface.getClusterMaximums(), rawDataInterface3, this.eventIDs);
        this.saveAnalysisResult(clusterInterface.getClusterMaximums(), rawDataInterface3, file, file2);
    }
}

