/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.server;

import edu.uoregon.tau.common.Gzip;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.AtomicEvent;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.IntervalEvent;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfexplorer.common.ChartDataType;
import edu.uoregon.tau.perfexplorer.common.PerfExplorerOutput;
import edu.uoregon.tau.perfexplorer.common.RMIGeneralChartData;
import edu.uoregon.tau.perfexplorer.common.RMIPerfExplorerModel;
import edu.uoregon.tau.perfexplorer.common.TransformationType;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import edu.uoregon.tau.perfexplorer.server.TauNamespaceContext;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralChartData
extends RMIGeneralChartData {
    private RMIPerfExplorerModel model;
    private String metricName = null;
    private String groupName = null;
    private String eventName = null;
    private String groupByColumn = null;
    private List columnValues = null;
    private StringBuilder buf = null;

    public GeneralChartData(RMIPerfExplorerModel rMIPerfExplorerModel, ChartDataType chartDataType) {
        super(chartDataType);
        this.model = rMIPerfExplorerModel;
        this.metricName = rMIPerfExplorerModel.getMetricName();
        this.groupName = rMIPerfExplorerModel.getGroupName();
        this.eventName = rMIPerfExplorerModel.getEventName();
    }

    public static GeneralChartData getChartData(RMIPerfExplorerModel rMIPerfExplorerModel, ChartDataType chartDataType) {
        GeneralChartData generalChartData = new GeneralChartData(rMIPerfExplorerModel, chartDataType);
        generalChartData.doQuery();
        return generalChartData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQuery() {
        Object object = null;
        DB dB = null;
        try {
            int n;
            AutoCloseable autoCloseable;
            String string;
            Object object2;
            Object object3;
            int n2;
            int n3;
            dB = PerfExplorerServer.getServer().getDB();
            Object object4 = this.model.getCurrentSelection();
            this.buf = GeneralChartData.buildCreateTableStatement("trial", "temp_trial", dB, true, false);
            this.buf.append("(select trial.* from trial ");
            this.buf.append("inner join experiment ");
            this.buf.append("on trial.experiment = experiment.id ");
            this.buf.append("inner join application ");
            this.buf.append("on experiment.application = application.id ");
            this.buf.append("where ");
            List<Object> list = this.model.getMultiSelection();
            if (list == null) {
                Object object5 = this.model.getCurrentSelection();
                if (object5 instanceof Application) {
                    this.buf.append("application.id = " + this.model.getApplication().getID());
                } else if (object5 instanceof Experiment) {
                    this.buf.append("experiment.id = " + this.model.getExperiment().getID());
                } else if (object5 instanceof Trial) {
                    this.buf.append("trial.id = " + this.model.getTrial().getID());
                }
            } else {
                int n4;
                boolean bl = false;
                for (n4 = 0; n4 < list.size(); ++n4) {
                    if (!(list.get(n4) instanceof Application)) continue;
                    Application application = (Application)list.get(n4);
                    if (!bl) {
                        this.buf.append("application.id in (");
                        bl = true;
                    } else {
                        this.buf.append(",");
                    }
                    this.buf.append(application.getID());
                }
                if (bl) {
                    this.buf.append(") ");
                }
                n4 = 0;
                for (n3 = 0; n3 < list.size(); ++n3) {
                    if (!(list.get(n3) instanceof Experiment)) continue;
                    Experiment experiment = (Experiment)list.get(n3);
                    if (n4 == 0) {
                        if (bl) {
                            this.buf.append(" and ");
                        }
                        this.buf.append("experiment.id in (");
                        n4 = 1;
                    } else {
                        this.buf.append(",");
                    }
                    this.buf.append(experiment.getID());
                }
                if (n4 != 0) {
                    this.buf.append(") ");
                }
                n3 = 0;
                for (n2 = 0; n2 < list.size(); ++n2) {
                    if (!(list.get(n2) instanceof Trial)) continue;
                    Trial trial = (Trial)list.get(n2);
                    if (n3 == 0) {
                        if (bl || n4 != 0) {
                            this.buf.append(" and ");
                        }
                        this.buf.append("trial.id in (");
                        n3 = 1;
                    } else {
                        this.buf.append(",");
                    }
                    this.buf.append(trial.getID());
                }
                if (n3 != 0) {
                    this.buf.append(") ");
                }
            }
            this.buf.append(") ");
            object = dB.prepareStatement(this.buf.toString());
            object.execute();
            object.close();
            boolean bl = false;
            if (this.model.getChartMetadataFieldName() != null || this.model.getChartMetadataFieldValue() != null || this.model.getChartSeriesName().toUpperCase().indexOf("XML") > 0 || this.model.getChartXAxisName().toUpperCase().indexOf("XML") > 0) {
                bl = true;
                Trial.getMetaData((DB)dB, (boolean)true);
                String[] stringArray = dB.getDatabase().getTrialFieldNames();
                n3 = 0;
                n2 = 0;
                for (int i = 0; i < Array.getLength(stringArray); ++i) {
                    if (stringArray[i].equalsIgnoreCase("XML_METADATA")) {
                        n3 = 1;
                        continue;
                    }
                    if (!stringArray[i].equalsIgnoreCase("XML_METADATA_GZ")) continue;
                    n2 = 1;
                }
                if (n3 != 0) {
                    this.buf = GeneralChartData.buildCreateTableStatement("xml_metadata", "temp_xml_metadata", dB, false, false);
                    if (dB.getDBType().compareTo("derby") == 0) {
                        this.buf.append(" (trial int, metadata_name varchar(4000), metadata_value varchar(4000))");
                    } else {
                        this.buf.append(" (trial int, metadata_name text, metadata_value text)");
                    }
                    object = dB.prepareStatement(this.buf.toString());
                    object.execute();
                    object.close();
                    object = n2 != 0 ? dB.prepareStatement("select id, XML_METADATA, XML_METADATA_GZ from temp_trial ") : dB.prepareStatement("select id, XML_METADATA from temp_trial ");
                    ResultSet resultSet = object.executeQuery();
                    object3 = DocumentBuilderFactory.newInstance();
                    object2 = ((DocumentBuilderFactory)object3).newDocumentBuilder();
                    dB.setAutoCommit(false);
                    while (resultSet.next()) {
                        string = resultSet.getString(2);
                        if (n2 != 0 && (string == null || string.length() == 0)) {
                            autoCloseable = resultSet.getBinaryStream(3);
                            string = Gzip.decompress((InputStream)autoCloseable);
                        }
                        if (string == null || string.length() == 0) continue;
                        autoCloseable = new StringReader(string);
                        InputSource inputSource = new InputSource((Reader)autoCloseable);
                        Document document = ((DocumentBuilder)object2).parse(inputSource);
                        NodeList nodeList = null;
                        NodeList nodeList2 = null;
                        XPath xPath = XPathFactory.newInstance().newXPath();
                        xPath.setNamespaceContext(new TauNamespaceContext());
                        nodeList = (NodeList)xPath.evaluate("/metadata/CommonProfileAttributes/attribute/name", document, XPathConstants.NODESET);
                        nodeList2 = (NodeList)xPath.evaluate("/metadata/CommonProfileAttributes/attribute/value", document, XPathConstants.NODESET);
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            Node node = nodeList.item(i).getFirstChild();
                            Node node2 = nodeList2.item(i).getFirstChild();
                            if (this.model.getChartMetadataFieldName() != null && !this.model.getChartMetadataFieldName().equals(node.getNodeValue()) || this.model.getChartMetadataFieldValue() != null && !this.model.getChartMetadataFieldValue().equals(node2.getNodeValue())) continue;
                            this.buf = new StringBuilder();
                            this.buf.append("insert into temp_xml_metadata VALUES (?,?,?)");
                            PreparedStatement preparedStatement = dB.prepareStatement(this.buf.toString());
                            preparedStatement.setInt(1, resultSet.getInt(1));
                            preparedStatement.setString(2, node.getNodeValue());
                            if (node2 == null) {
                                preparedStatement.setString(3, "");
                            } else {
                                preparedStatement.setString(3, node2.getNodeValue());
                            }
                            preparedStatement.executeUpdate();
                            preparedStatement.close();
                        }
                    }
                    dB.commit();
                    resultSet.close();
                    object.close();
                    dB.setAutoCommit(true);
                }
            }
            if (!this.model.getChartSeriesName().equals("atomic_event.name")) {
                this.buf = GeneralChartData.buildCreateTableStatement("metric", "temp_metric", dB, true, false);
                this.buf.append("(select metric.* from metric ");
                this.buf.append("inner join temp_trial ");
                this.buf.append("on metric.trial = temp_trial.id ");
                List<String> list2 = this.model.getMetricNames();
                if (list2 != null) {
                    this.buf.append("where upper(metric.name) like ? ");
                    for (n3 = 1; n3 < list2.size(); ++n3) {
                        this.buf.append("or upper(metric.name) like ? ");
                    }
                }
                this.buf.append(") ");
                object = dB.prepareStatement(this.buf.toString());
                if (list2 != null) {
                    for (n3 = 1; n3 <= list2.size(); ++n3) {
                        String string2 = list2.get(n3 - 1);
                        object.setString(n3, string2.toUpperCase());
                    }
                }
                object.execute();
                object.close();
            }
            if (this.model.getMainEventOnly()) {
                this.buf = new StringBuilder();
                this.buf.append("select ie.name from interval_event ie ");
                this.buf.append("inner join interval_mean_summary ims ");
                this.buf.append("on ie.id = ims.interval_event, ");
                this.buf.append("(select temp_trial.id as trialid, ");
                this.buf.append("temp_metric.id as metricid, ");
                this.buf.append("max(interval_mean_summary.inclusive) as maxinclusive ");
                this.buf.append("from interval_event inner join temp_trial ");
                this.buf.append("on interval_event.trial = temp_trial.id ");
                this.buf.append("inner join interval_mean_summary on ");
                this.buf.append("interval_mean_summary.interval_event = interval_event.id ");
                this.buf.append("inner join temp_metric ");
                this.buf.append("on interval_mean_summary.metric = temp_metric.id ");
                if (dB.getDBType().compareTo("derby") == 0) {
                    this.buf.append("group by temp_trial.id, temp_metric.id) mr ");
                } else {
                    this.buf.append("group by 1, 2) mr ");
                }
                this.buf.append("where ie.trial = trialid ");
                this.buf.append("and ims.metric = metricid ");
                this.buf.append("and ims.inclusive = maxinclusive");
                object = dB.prepareStatement(this.buf.toString());
                ResultSet resultSet = object.executeQuery();
                while (resultSet.next()) {
                    this.model.addEventName(resultSet.getString(1));
                }
                resultSet.close();
                object.close();
            }
            List<String> list3 = this.model.getGroupNames();
            List<String> list4 = this.model.getEventNames();
            if (this.model.getChartSeriesName().equals("atomic_event.name")) {
                this.buf = GeneralChartData.buildCreateTableStatement("event", "temp_event", dB, true, this.model.getChartSeriesName().equals("atomic_event.name"));
                this.buf.append("(select atomic_event.* from atomic_event ");
                this.buf.append("inner join temp_trial ");
                this.buf.append("on atomic_event.trial = temp_trial.id ");
                n = 0;
                if (this.model.getEventNoCallpath()) {
                    if (n != 0) {
                        this.buf.append("and ");
                    } else {
                        this.buf.append("where ");
                        n = 1;
                    }
                    this.buf.append("atomic_event.name not like ' : ' ");
                }
                if (list4 != null) {
                    boolean bl2 = false;
                    for (int i = 0; i < list4.size(); ++i) {
                        if (n != 0) {
                            if (bl2) {
                                this.buf.append("or ");
                            } else {
                                this.buf.append("and ");
                                bl2 = true;
                            }
                        } else {
                            this.buf.append("where ");
                            n = 1;
                        }
                        if (dB.getDBType().compareTo("db2") == 0) {
                            this.buf.append("atomic_event.name like ? ");
                            continue;
                        }
                        this.buf.append("atomic_event.name = ? ");
                    }
                }
                this.buf.append(")");
            } else {
                this.buf = GeneralChartData.buildCreateTableStatement("event", "temp_event", dB, true, false);
                this.buf.append("(select interval_event.* from interval_event ");
                this.buf.append("inner join temp_trial ");
                this.buf.append("on interval_event.trial = temp_trial.id ");
                this.buf.append("inner join interval_mean_summary ");
                this.buf.append("on interval_mean_summary.interval_event = interval_event.id ");
                this.buf.append("inner join temp_metric ");
                this.buf.append("on interval_mean_summary.metric = temp_metric.id ");
                n = 0;
                if (this.model.getEventNoCallpath()) {
                    if (n != 0) {
                        this.buf.append("and ");
                    } else {
                        this.buf.append("where ");
                        n = 1;
                    }
                    this.buf.append("(interval_event.group_name is null ");
                    this.buf.append("or (interval_event.group_name not like '%TAU_CALLPATH%')) ");
                }
                if (this.model.getDimensionReduction() == TransformationType.OVER_X_PERCENT) {
                    if (n != 0) {
                        this.buf.append("and ");
                    } else {
                        this.buf.append("where ");
                        n = 1;
                    }
                    this.buf.append("interval_mean_summary.exclusive_percentage > ");
                    this.buf.append(this.model.getXPercent());
                    this.buf.append(" ");
                }
                if (this.model.getEventExclusive100()) {
                    if (n != 0) {
                        this.buf.append("and ");
                    } else {
                        this.buf.append("where ");
                        n = 1;
                    }
                    this.buf.append("interval_mean_summary.exclusive_percentage = 100 ");
                }
                if (list3 != null) {
                    boolean bl3 = false;
                    for (int i = 0; i < list3.size(); ++i) {
                        if (n != 0) {
                            if (bl3) {
                                this.buf.append("or ");
                            } else {
                                this.buf.append("and ");
                                bl3 = true;
                            }
                        } else {
                            this.buf.append("where ");
                            n = 1;
                        }
                        if (dB.getDBType().compareTo("db2") == 0) {
                            this.buf.append("interval_event.group_name like ? ");
                            continue;
                        }
                        this.buf.append("interval_event.group_name = ? ");
                    }
                }
                if (list4 != null) {
                    boolean bl4 = false;
                    for (int i = 0; i < list4.size(); ++i) {
                        if (n != 0) {
                            if (bl4) {
                                this.buf.append("or ");
                            } else {
                                this.buf.append("and ");
                                bl4 = true;
                            }
                        } else {
                            this.buf.append("where ");
                            n = 1;
                        }
                        if (dB.getDBType().compareTo("db2") == 0) {
                            this.buf.append("interval_event.name like ? ");
                            continue;
                        }
                        this.buf.append("interval_event.name = ? ");
                    }
                }
                this.buf.append(")");
            }
            object = dB.prepareStatement(this.buf.toString());
            n = 1;
            if (list3 != null) {
                for (int i = 0; i < list3.size(); ++i) {
                    object3 = list3.get(i);
                    object.setString(n, (String)object3);
                    ++n;
                }
            }
            if (list4 != null) {
                for (int i = 0; i < list4.size(); ++i) {
                    object3 = list4.get(i);
                    object.setString(n, (String)object3);
                    ++n;
                }
            }
            object.execute();
            object.close();
            String string3 = this.model.getChartSeriesName();
            object3 = this.model.getChartXAxisName();
            object2 = this.model.getChartYAxisName();
            this.buf = new StringBuilder();
            string = "interval_mean_summary";
            if (this.model.getChartSeriesName().equals("atomic_event.name")) {
                string = "atomic_location_profile";
                this.buf.append("select ");
                if (dB.getDBType().compareTo("derby") == 0) {
                    if (this.model.isChartSeriesXML()) {
                        this.buf.append("'");
                    }
                    this.buf.append(this.fixClause(string3, dB));
                    if (this.model.isChartSeriesXML()) {
                        this.buf.append("'");
                    }
                    this.buf.append(", ");
                    this.buf.append(this.fixClause((String)object3, dB) + ", ");
                    this.buf.append(this.fixClause((String)object2, dB) + " ");
                } else {
                    if (this.model.isChartSeriesXML()) {
                        this.buf.append("'");
                    }
                    this.buf.append(this.fixClause(string3, dB));
                    if (this.model.isChartSeriesXML()) {
                        this.buf.append("'");
                    }
                    this.buf.append(" as series_name, ");
                    this.buf.append(this.fixClause((String)object3, dB) + " as xaxis_value, ");
                    this.buf.append(this.fixClause((String)object2, dB) + " as yaxis_value ");
                }
                this.buf.append("from " + string + " ");
                this.buf.append("inner join temp_event ");
                this.buf.append("on " + string + ".atomic_event = temp_event.id ");
            } else {
                if (((String)object2).indexOf("interval_mean_summary") >= 0) {
                    string = "interval_mean_summary";
                } else if (((String)object2).indexOf("interval_total_summary") >= 0) {
                    string = "interval_total_summary";
                } else if (((String)object2).indexOf("interval_location_profile") >= 0) {
                    string = "interval_location_profile";
                }
                this.buf.append("select ");
                if (dB.getDBType().compareTo("derby") == 0) {
                    if (this.model.isChartSeriesXML()) {
                        this.buf.append("'");
                    }
                    this.buf.append(this.fixClause(string3, dB));
                    if (this.model.isChartSeriesXML()) {
                        this.buf.append("'");
                    }
                    this.buf.append(", ");
                    this.buf.append(this.fixClause((String)object3, dB) + ", ");
                    this.buf.append(this.fixClause((String)object2, dB) + " ");
                } else {
                    if (this.model.isChartSeriesXML()) {
                        this.buf.append("'");
                    }
                    this.buf.append(this.fixClause(string3, dB));
                    if (this.model.isChartSeriesXML()) {
                        this.buf.append("'");
                    }
                    this.buf.append(" as series_name, ");
                    this.buf.append(this.fixClause((String)object3, dB) + " as xaxis_value, ");
                    this.buf.append(this.fixClause((String)object2, dB) + " as yaxis_value ");
                }
                this.buf.append("from " + string + " ");
                this.buf.append("inner join temp_metric ");
                this.buf.append("on " + string + ".metric = temp_metric.id ");
                this.buf.append("inner join temp_event ");
                this.buf.append("on " + string + ".interval_event = temp_event.id ");
            }
            this.buf.append("inner join temp_trial ");
            this.buf.append("on temp_event.trial = temp_trial.id ");
            if (bl) {
                this.buf.append("inner join temp_xml_metadata ");
                this.buf.append("on temp_event.trial = temp_xml_metadata.trial ");
            }
            this.buf.append("inner join experiment ");
            this.buf.append("on temp_trial.experiment = experiment.id ");
            this.buf.append("inner join application ");
            this.buf.append("on experiment.application = application.id ");
            if (dB.getDBType().compareTo("derby") == 0) {
                this.buf.append("group by " + this.fixClause(string3, dB));
                if (!string3.equals(object3)) {
                    this.buf.append(", " + this.fixClause((String)object3, dB));
                }
                if (string3.startsWith("trial.node_count") || ((String)object3).startsWith("trial.node_count")) {
                    this.buf.append(" order by 1, 2, 3, 4 ");
                } else {
                    this.buf.append(" order by 1, 2 ");
                }
            } else {
                this.buf.append("group by series_name, xaxis_value ");
                this.buf.append("order by 1, 2 ");
            }
            object = dB.prepareStatement(this.buf.toString());
            autoCloseable = object.executeQuery();
            while (autoCloseable.next()) {
                if (dB.getDBType().compareTo("derby") == 0) {
                    if (string3.startsWith("trial.node_count")) {
                        this.addRow(Integer.toString(autoCloseable.getInt(1) * autoCloseable.getInt(2) * autoCloseable.getInt(3)), autoCloseable.getString(4), autoCloseable.getDouble(5));
                        continue;
                    }
                    if (((String)object3).startsWith("trial.node_count")) {
                        this.addRow(autoCloseable.getString(1), Integer.toString(autoCloseable.getInt(2) * autoCloseable.getInt(3) * autoCloseable.getInt(4)), autoCloseable.getDouble(5));
                        continue;
                    }
                    this.addRow(autoCloseable.getString(1), autoCloseable.getString(2), autoCloseable.getDouble(3));
                    continue;
                }
                this.addRow(autoCloseable.getString(1), autoCloseable.getString(2), autoCloseable.getDouble(3));
            }
            autoCloseable.close();
            object.close();
        }
        catch (Exception exception) {
            if (object != null) {
                PerfExplorerOutput.println(object.toString());
            } else {
                PerfExplorerOutput.println(this.buf.toString());
            }
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        finally {
            try {
                dB.setAutoCommit(true);
                GeneralChartData.dropTable(dB, "temp_event");
                if (!this.model.getChartSeriesName().equals("atomic_event.name")) {
                    GeneralChartData.dropTable(dB, "temp_metric");
                }
                GeneralChartData.dropTable(dB, "temp_xml_metadata");
                GeneralChartData.dropTable(dB, "temp_trial");
            }
            catch (Exception exception) {}
        }
    }

    private static StringBuilder buildCreateTableStatement(String string, String string2, DB dB, boolean bl, boolean bl2) {
        GeneralChartData.dropTable(dB, string2);
        StringBuilder stringBuilder = new StringBuilder();
        if (dB.getDBType().equalsIgnoreCase("oracle")) {
            stringBuilder.append("create global temporary table ");
        } else if (dB.getDBType().equalsIgnoreCase("derby") || dB.getDBType().equalsIgnoreCase("db2")) {
            stringBuilder.append("create table ");
        } else {
            stringBuilder.append("create temporary table ");
        }
        stringBuilder.append(string2 + " ");
        if (bl) {
            if (dB.getDBType().equalsIgnoreCase("derby")) {
                String[] stringArray = null;
                String[] stringArray2 = null;
                if (string.equalsIgnoreCase("trial")) {
                    Trial.getMetaData((DB)dB, (boolean)true);
                    stringArray = dB.getDatabase().getTrialFieldNames();
                    stringArray2 = dB.getDatabase().getTrialFieldTypeNames();
                    Trial.getMetaData((DB)dB, (boolean)false);
                } else if (string.equalsIgnoreCase("metric")) {
                    Metric.getMetaData((DB)dB);
                    stringArray = dB.getDatabase().getMetricFieldNames();
                    stringArray2 = dB.getDatabase().getMetricFieldTypeNames();
                } else if (string.equalsIgnoreCase("event")) {
                    if (bl2) {
                        AtomicEvent.getMetaData((DB)dB);
                        stringArray = dB.getDatabase().getAtomicEventFieldNames();
                        stringArray2 = dB.getDatabase().getAtomicEventFieldTypeNames();
                    } else {
                        IntervalEvent.getMetaData((DB)dB);
                        stringArray = dB.getDatabase().getIntervalEventFieldNames();
                        stringArray2 = dB.getDatabase().getIntervalEventFieldTypeNames();
                    }
                }
                stringBuilder.append(" (");
                for (int i = 0; i < Array.getLength(stringArray); ++i) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(stringArray[i] + " " + stringArray2[i]);
                }
                stringBuilder.append(") ");
                try {
                    PreparedStatement preparedStatement = dB.prepareStatement(stringBuilder.toString());
                    preparedStatement.execute();
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {
                    System.err.println(stringBuilder.toString());
                    System.err.println(sQLException.getMessage());
                    sQLException.printStackTrace(System.err);
                }
                stringBuilder = new StringBuilder();
                stringBuilder.append(" insert into " + string2 + " ");
            } else {
                stringBuilder.append("as ");
            }
        }
        return stringBuilder;
    }

    private String fixClause(String string, DB dB) {
        String string2 = string.replaceAll("trial.", "temp_trial.").replaceAll("metric.", "temp_metric.").replaceAll("interval_event.", "temp_event.").replaceAll("atomic_event.", "temp_event.");
        if (dB.getDBType().equalsIgnoreCase("oracle")) {
            string2 = string2.replaceAll("exclusive", "exec");
        }
        if (dB.getDBType().equalsIgnoreCase("derby")) {
            string2 = string2.replaceAll("call", "num_calls");
            string2 = string2.replaceAll(" \\* ", ", ");
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getXMLFields(RMIPerfExplorerModel rMIPerfExplorerModel) {
        ArrayList<String> arrayList;
        StringBuilder stringBuilder = null;
        Statement statement = null;
        HashSet<String> hashSet = new HashSet<String>();
        DB dB = null;
        try {
            Object object;
            dB = PerfExplorerServer.getServer().getDB();
            arrayList = rMIPerfExplorerModel.getCurrentSelection();
            Trial.getMetaData((DB)dB, (boolean)true);
            String[] stringArray = dB.getDatabase().getTrialFieldNames();
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < Array.getLength(stringArray); ++i) {
                if (stringArray[i].equalsIgnoreCase("XML_METADATA")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[i].equalsIgnoreCase("XML_METADATA_GZ")) continue;
                bl2 = true;
            }
            if (!bl) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                return arrayList2;
            }
            stringBuilder = GeneralChartData.buildCreateTableStatement("trial", "temp_trial", dB, true, false);
            stringBuilder.append("(select trial.* from trial ");
            stringBuilder.append("inner join experiment ");
            stringBuilder.append("on trial.experiment = experiment.id ");
            stringBuilder.append("inner join application ");
            stringBuilder.append("on experiment.application = application.id ");
            stringBuilder.append("where ");
            List<Object> list = rMIPerfExplorerModel.getMultiSelection();
            if (list == null) {
                Object object2 = rMIPerfExplorerModel.getCurrentSelection();
                if (object2 instanceof Application) {
                    stringBuilder.append("application.id = " + rMIPerfExplorerModel.getApplication().getID());
                } else if (object2 instanceof Experiment) {
                    stringBuilder.append("experiment.id = " + rMIPerfExplorerModel.getExperiment().getID());
                } else if (object2 instanceof Trial) {
                    stringBuilder.append("trial.id = " + rMIPerfExplorerModel.getTrial().getID());
                }
            } else {
                int n;
                int n2;
                boolean bl3 = false;
                for (n2 = 0; n2 < list.size(); ++n2) {
                    if (!(list.get(n2) instanceof Application)) continue;
                    Application application = (Application)list.get(n2);
                    if (!bl3) {
                        stringBuilder.append("application.id in (");
                        bl3 = true;
                    } else {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(application.getID());
                }
                if (bl3) {
                    stringBuilder.append(") ");
                }
                n2 = 0;
                for (n = 0; n < list.size(); ++n) {
                    if (!(list.get(n) instanceof Experiment)) continue;
                    Experiment experiment = (Experiment)list.get(n);
                    if (n2 == 0) {
                        if (bl3) {
                            stringBuilder.append(" and ");
                        }
                        stringBuilder.append("experiment.id in (");
                        n2 = 1;
                    } else {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(experiment.getID());
                }
                if (n2 != 0) {
                    stringBuilder.append(") ");
                }
                n = 0;
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof Trial)) continue;
                    object = (Trial)list.get(i);
                    if (n == 0) {
                        if (bl3 || n2 != 0) {
                            stringBuilder.append(" and ");
                        }
                        stringBuilder.append("trial.id in (");
                        n = 1;
                    } else {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(object.getID());
                }
                if (n != 0) {
                    stringBuilder.append(") ");
                }
            }
            stringBuilder.append(") ");
            statement = dB.prepareStatement(stringBuilder.toString());
            statement.execute();
            statement.close();
            statement = null;
            statement = bl2 ? dB.prepareStatement("select id, XML_METADATA, XML_METADATA_GZ from temp_trial ") : dB.prepareStatement("select id, XML_METADATA from temp_trial ");
            ResultSet resultSet = statement.executeQuery();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            while (resultSet.next()) {
                Node node;
                int n;
                String string = resultSet.getString(2);
                if (bl2 && (string == null || string.length() == 0)) {
                    object = resultSet.getBinaryStream(3);
                    string = Gzip.decompress((InputStream)object);
                }
                object = new StringReader(string);
                InputSource inputSource = new InputSource((Reader)object);
                Document document = documentBuilder.parse(inputSource);
                NodeList nodeList = null;
                XPath xPath = XPathFactory.newInstance().newXPath();
                xPath.setNamespaceContext(new TauNamespaceContext());
                nodeList = (NodeList)xPath.evaluate("/metadata/CommonProfileAttributes/attribute/name", document, XPathConstants.NODESET);
                for (n = 0; n < nodeList.getLength(); ++n) {
                    node = nodeList.item(n).getFirstChild();
                    hashSet.add(node.getNodeValue());
                }
                nodeList = (NodeList)xPath.evaluate("/metadata/CommonProfileAttributes/attribute/name", document, XPathConstants.NODESET);
                for (n = 0; n < nodeList.getLength(); ++n) {
                    node = nodeList.item(n).getFirstChild();
                    hashSet.add(node.getNodeValue());
                }
            }
            resultSet.close();
            statement.close();
            statement = null;
        }
        catch (Exception exception) {
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            GeneralChartData.dropTable(dB, "temp_trial");
        }
        arrayList = new ArrayList<String>(hashSet);
        Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dropTable(DB dB, String string) {
        Statement statement = null;
        try {
            if (dB.getDBType().compareTo("oracle") == 0) {
                statement = dB.prepareStatement("truncate table " + string);
                statement.execute();
                statement.close();
            }
            statement = dB.prepareStatement("drop table " + string);
            statement.execute();
            statement.close();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }
}

