/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.server;

import edu.uoregon.tau.perfexplorer.clustering.ClusterInterface;
import edu.uoregon.tau.perfexplorer.common.RMIPerfExplorerModel;
import edu.uoregon.tau.perfexplorer.constants.Constants;
import edu.uoregon.tau.perfexplorer.server.PEChartColor;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class VirtualTopology
extends JPanel {
    RMIPerfExplorerModel modelData = null;
    ClusterInterface clusterer = null;
    int[] pixels = null;
    BufferedImage img = null;
    StringBuilder description = null;
    private static final int idealSize = 128;
    private static final Color[] colors = PEChartColor.createDefaultColorArray();

    public VirtualTopology(RMIPerfExplorerModel rMIPerfExplorerModel, ClusterInterface clusterInterface) {
        int n;
        this.modelData = rMIPerfExplorerModel;
        this.clusterer = clusterInterface;
        this.description = new StringBuilder();
        this.description.append(rMIPerfExplorerModel.toShortString() + ".");
        this.description.append(clusterInterface.getClusterSizes().length + "_clusters");
        this.pixels = new int[clusterInterface.getNumInstances()];
        int n2 = clusterInterface.getNumInstances();
        for (n = 1; n < n2 / 2; n *= 2) {
            n2 /= 2;
        }
        if (128 <= n || 128 <= n2) {
            this.img = new BufferedImage(n, n2, 1);
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    int n4 = clusterInterface.clusterInstance(n3);
                    if (n4 >= 0) {
                        this.img.setRGB(i, j, colors[n4].getRGB());
                    } else {
                        this.img.setRGB(i, j, Color.black.getRGB());
                    }
                    ++n3;
                }
            }
        } else {
            this.img = new BufferedImage(128, 128, 1);
            int n5 = 128 / n;
            int n6 = 128 / n2;
            int n7 = 0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    int n8 = clusterInterface.clusterInstance(n7);
                    int n9 = Color.black.getRGB();
                    if (n8 >= 0) {
                        n9 = colors[n8].getRGB();
                    }
                    for (int k = i * n5; k < (i + 1) * n5; ++k) {
                        for (int i2 = j * n6; i2 < (j + 1) * n6; ++i2) {
                            this.img.setRGB(k, i2, n9);
                        }
                    }
                    ++n7;
                }
            }
        }
    }

    public String getImage() {
        String string = Constants.TMPDIR + "clusterImage." + this.description + ".png";
        File file = new File(string);
        try {
            ImageIO.write((RenderedImage)this.img, "PNG", file);
        }
        catch (IOException iOException) {
            String string2 = "ERROR: Couldn't write the virtual topology image!";
            System.err.println(string2);
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        return string;
    }

    public String getThumbnail() {
        String string = Constants.TMPDIR + "clusterImage.thumb." + this.description + ".png";
        return string;
    }
}

